/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.doclet;

import de.virtimo.bpc.doclet.ApiInfo;
import de.virtimo.bpc.doclet.EndpointInfo;
import de.virtimo.bpc.doclet.ParamInfo;
import java.util.Comparator;
import java.util.List;

class AsciiDocGenerator {
    AsciiDocGenerator() {
    }

    public static String generateOverviewFileContent(List<ApiInfo> apiInfos) {
        Object result = "";
        result = (String)result + "// ----------------------------------------------------------------------------";
        result = (String)result + "\n";
        result = (String)result + "// Attention: This is a generated documentation, please do not change manually.";
        result = (String)result + "\n";
        result = (String)result + "// ----------------------------------------------------------------------------";
        result = (String)result + "\n";
        result = (String)result + "\n";
        apiInfos.sort(new Comparator<ApiInfo>(){

            @Override
            public int compare(ApiInfo o1, ApiInfo o2) {
                return o1.getTitle().compareTo(o2.getTitle());
            }
        });
        for (ApiInfo apiInfo : apiInfos) {
            result = (String)result + "== " + apiInfo.getTitle();
            if (apiInfo.hasDescription()) {
                result = (String)result + "\n";
                result = (String)result + AsciiDocGenerator.prepareJavadocCommentForAsciiDoc(apiInfo.getDescription());
                result = (String)result + "\n";
            }
            result = (String)result + "\n";
            result = (String)result + "include::" + apiInfo.getFileName() + "[]";
            result = (String)result + "\n\n";
        }
        return result;
    }

    public static String generateApiFileContent(ApiInfo apiInfo) {
        List<EndpointInfo> endpoints = apiInfo.getEndpoints();
        Object result = "";
        result = (String)result + "// ----------------------------------------------------------------------------";
        result = (String)result + "\n";
        result = (String)result + "// Attention: This is a generated documentation, please do not change manually.";
        result = (String)result + "\n";
        result = (String)result + "// Related Java Class: " + apiInfo.getClassName();
        result = (String)result + "\n";
        result = (String)result + "// ----------------------------------------------------------------------------";
        result = (String)result + "\n";
        result = (String)result + "\n";
        result = (String)result + "[cols=\"10a,90a\",options=header]";
        result = (String)result + "\n";
        result = (String)result + "|===";
        result = (String)result + "\n";
        result = (String)result + "|Method";
        result = (String)result + "\n";
        result = (String)result + "|Endpoint";
        result = (String)result + "\n";
        for (EndpointInfo endpoint : endpoints) {
            int rowSpan = 3;
            if (endpoint.hasPathParams()) {
                ++rowSpan;
            }
            if (endpoint.hasQueryParams()) {
                ++rowSpan;
            }
            if (endpoint.hasFormParams()) {
                ++rowSpan;
            }
            if (endpoint.hasConsumes()) {
                ++rowSpan;
            }
            if (endpoint.hasReturns() || endpoint.hasProduces()) {
                ++rowSpan;
            }
            result = (String)result + "\n";
            result = (String)result + "// ================================================================================================";
            result = (String)result + "\n";
            result = (String)result + "\n";
            result = (String)result + "." + rowSpan + "+";
            result = (String)result + "| [[" + AsciiDocGenerator.getUniqueAnchorId(endpoint) + "]] `" + endpoint.getHttpMethod() + "`";
            result = (String)result + "| `" + AsciiDocGenerator.encodeSpecialAsciiDocCharacters(endpoint.getEndpointPath()) + "`";
            result = (String)result + "\n";
            result = (String)result + "\n";
            result = (String)result + "1+a|**Description**";
            result = (String)result + "\n";
            if (endpoint.hasDescription()) {
                result = (String)result + "\n";
                result = (String)result + AsciiDocGenerator.prepareJavadocCommentForAsciiDoc(endpoint.getDescription());
                result = (String)result + "\n";
            } else {
                result = (String)result + "\n";
                result = (String)result + "TODO";
                result = (String)result + "\n";
            }
            if (endpoint.hasConsumes()) {
                result = (String)result + "\n";
                result = (String)result + "1+a|**Consumes**";
                result = (String)result + "\n";
                for (String mediaType : endpoint.getConsumes()) {
                    result = (String)result + "\n";
                    result = (String)result + "- `" + mediaType + "`";
                }
                result = (String)result + "\n";
            }
            if (endpoint.hasPathParams()) {
                result = (String)result + "\n";
                result = (String)result + "1+a|**Path Parameter**";
                result = (String)result + "\n";
                result = (String)result + AsciiDocGenerator.getParamsAsDescriptionList(endpoint.getPathParams());
                result = (String)result + "\n";
            }
            if (endpoint.hasQueryParams()) {
                result = (String)result + "\n";
                result = (String)result + "1+a|**Query Parameter**";
                result = (String)result + "\n";
                result = (String)result + AsciiDocGenerator.getParamsAsDescriptionList(endpoint.getQueryParams());
                result = (String)result + "\n";
            }
            if (endpoint.hasFormParams()) {
                result = (String)result + "\n";
                result = (String)result + "1+a|**Form Parameter**";
                result = (String)result + "\n";
                result = (String)result + AsciiDocGenerator.getParamsAsDescriptionList(endpoint.getFormParams());
                result = (String)result + "\n";
            }
            if (endpoint.hasReturns() || endpoint.hasProduces()) {
                result = (String)result + "\n";
                result = (String)result + "1+a|**Returns**";
                result = (String)result + "\n";
                if (endpoint.hasReturns()) {
                    result = (String)result + "\n";
                    result = (String)result + AsciiDocGenerator.prepareJavadocCommentForAsciiDoc(endpoint.getReturns());
                    result = (String)result + "\n";
                }
                if (endpoint.hasProduces()) {
                    result = (String)result + "\n";
                    result = (String)result + "Content-Type";
                    result = (String)result + "\n";
                    for (String mediaType : endpoint.getProduces()) {
                        result = (String)result + "\n";
                        result = (String)result + "- `" + mediaType + "`";
                    }
                    result = (String)result + "\n";
                }
            }
            result = (String)result + "\n";
            result = (String)result + "1+a|**Required Access Rights**";
            result = (String)result + "\n";
            result = (String)result + "\n";
            if (endpoint.isRequiresUserSession()) {
                if (endpoint.hasRequiredRole() || endpoint.hasRequiredRight()) {
                    result = (String)result + "include::requirement_role_or_right.adoc[]";
                    result = (String)result + "\n";
                    if (endpoint.hasRequiredRole()) {
                        result = (String)result + "\n";
                        result = (String)result + "- Role : `" + endpoint.getRequiredRole() + "`";
                    }
                    if (endpoint.hasRequiredRight()) {
                        result = (String)result + "\n";
                        result = (String)result + "- Right : `" + endpoint.getRequiredRight() + "`";
                    }
                    result = (String)result + "\n";
                } else {
                    result = (String)result + "include::requirement_user_session_or_api_key.adoc[]";
                    result = (String)result + "\n";
                }
            } else {
                result = (String)result + "include::requirement_none.adoc[]";
                result = (String)result + "\n";
                if (!endpoint.hasBpcAnnotations()) {
                    result = (String)result + "\n";
                    result = (String)result + "Possible vulnerability detected.\nPlease add at least the annotation `@BpcEndpoint` to\n\n " + apiInfo.getClassName() + "." + endpoint.getJavaMethodSignature();
                    result = (String)result + "\n";
                }
            }
            result = (String)result + "\n";
        }
        result = (String)result + "\n";
        result = (String)result + "|===";
        result = (String)result + "\n";
        return result;
    }

    private static String encodeSpecialAsciiDocCharacters(String value) {
        if (value != null) {
            value = value.replaceAll("\\{", "\\\\{");
        }
        return value;
    }

    private static String getUniqueAnchorId(EndpointInfo endpoint) {
        Object result = endpoint.getHttpMethod().trim().toLowerCase() + "_" + endpoint.getEndpointPath().toLowerCase();
        result = ((String)result).replaceAll("[^A-Za-z0-9_]", "_");
        result = ((String)result).replaceAll("_{2,}", "_");
        result = ((String)result).replaceAll("_$", "");
        return result;
    }

    private static String getParamsAsDescriptionList(List<ParamInfo> params) {
        Object result = "";
        for (ParamInfo param : params) {
            result = (String)result + "\n";
            result = (String)result + "`" + param.getName() + "`:: ";
            result = param.hasDescription() ? (String)result + param.getDescription() : (String)result + "TODO";
            if (!param.hasDefaultValue()) continue;
            if (!((String)result).endsWith("TODO") && !((String)result).endsWith(".")) {
                result = (String)result + ".";
            }
            result = (String)result + " Default is `" + param.getDefaultValue() + "`.";
        }
        return result;
    }

    private static String prepareJavadocCommentForAsciiDoc(String comment) {
        return AsciiDocGenerator.removeNewLinesAtTheEnd(AsciiDocGenerator.removeSingleLeadingSpaceOnEachLine(AsciiDocGenerator.removeStrangeHtmlTags(comment.trim())));
    }

    private static String removeSingleLeadingSpaceOnEachLine(String text) {
        String[] lines = text.split("\n");
        StringBuilder buffer = new StringBuilder();
        for (String line : lines) {
            if (line.startsWith(" ")) {
                buffer.append(line.substring(1));
            } else {
                buffer.append(line);
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    private static String removeNewLinesAtTheEnd(String text) {
        return text.replaceAll("[\n\r]$", "");
    }

    private static String removeStrangeHtmlTags(String text) {
        return text.replaceAll(",<p>,", "").replaceAll(",<", "<").replaceAll(">,", ">");
    }
}

