/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.jaxrs;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.apikey.APIKeyException;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import java.util.logging.Logger;
import javax.ws.rs.core.HttpHeaders;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.message.Message;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class UserSessionProvider
implements ContextProvider<UserSession> {
    private static final Logger LOG = Logger.getLogger(UserSessionProvider.class.getName());

    public UserSession createContext(Message message) {
        LOG.info("createContext message=" + message);
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        BpcServicesTracker<ClientSessionManager> clientSessionManagerTracker = new BpcServicesTracker<ClientSessionManager>(bundleContext, ClientSessionManager.class);
        try {
            HttpHeadersImpl httpHeaders = new HttpHeadersImpl(message);
            UserSession userSession = clientSessionManagerTracker.getService().getUserSession((HttpHeaders)httpHeaders);
            clientSessionManagerTracker.close();
            return userSession;
        }
        catch (Throwable throwable) {
            try {
                try {
                    clientSessionManagerTracker.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (APIKeyException | ServiceNotFoundException ex) {
                LOG.warning("Failed to get the user session: " + ex.getMessage());
                return null;
            }
        }
    }
}

