/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.logservice;

import de.virtimo.bpc.api.AbstractBackendModuleLoadedEventHandler;
import de.virtimo.bpc.api.AbstractEventHandler;
import de.virtimo.bpc.api.AbstractMaintenanceModeAcknowledgeEventHandler;
import de.virtimo.bpc.api.BackupManager;
import de.virtimo.bpc.api.BackupSetting;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.PercolatorsManager;
import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.exception.LogServiceException;
import de.virtimo.bpc.api.exception.LogServiceSettingsException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.logservice.LogDataResult;
import de.virtimo.bpc.logservice.LogService;
import de.virtimo.bpc.logservice.LogServiceModuleInstance;
import de.virtimo.bpc.logservice.db.DatabaseLogService;
import de.virtimo.bpc.logservice.es.ElasticsearchLogService;
import de.virtimo.bpc.logservice.resource.LogData;
import de.virtimo.bpc.module.AbstractInstantiableModule;
import de.virtimo.bpc.module.ModuleConfigurationBuilder;
import de.virtimo.bpc.util.StringUtil;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;

public class LogServiceModule
extends AbstractInstantiableModule {
    private static final Logger LOG = Logger.getLogger(LogServiceModule.class.getName());
    public static final String MODULE_ID = "logservice";
    public static final String CLIENT_CERTIFICATE_AUTH_MANDATORY = "clientCertificateAuthMandatory";
    public static final String MAX_RESULT_WINDOW = "es_data_view_limit";
    public static final String MAX_DATA_COUNT = "es_data_count_limit";
    private final ExecutorService loggingExecutorService = Executors.newFixedThreadPool(1, new ThreadFactoryWithNamePrefix("bpc-core-logservice"));
    private final Set<String> indicesTemporaryUnavailable = new HashSet<String>();
    private static final Object INDICES_TEMPORARY_UNAVAILABLE_LOCK = new Object();
    private BpcServicesTracker<ElasticsearchService> elasticsearchServiceTracker;
    private BpcServicesTracker<PercolatorsManager> percolatorsManagerTracker;
    private BpcServicesTracker<BackupManager> backupManagerTracker;
    private BpcServicesTracker<DatabaseManager> databaseManagerTracker;
    private final EventRegistration eventRegistration = new EventRegistration(null);

    public LogServiceModule(ModuleManager moduleManager) {
        super(moduleManager);
    }

    @Override
    public void setModuleBundle(Bundle moduleBundle) {
        super.setModuleBundle(moduleBundle);
        BundleContext bundleContext = moduleBundle.getBundleContext();
        BpcServicesTracker.stopAll(this);
        this.elasticsearchServiceTracker = new BpcServicesTracker<ElasticsearchService>(bundleContext, ElasticsearchService.class);
        this.percolatorsManagerTracker = new BpcServicesTracker<PercolatorsManager>(bundleContext, PercolatorsManager.class);
        this.backupManagerTracker = new BpcServicesTracker<BackupManager>(bundleContext, BackupManager.class);
        this.databaseManagerTracker = new BpcServicesTracker<DatabaseManager>(bundleContext, DatabaseManager.class);
        this.eventRegistration.setBundleContext(bundleContext);
        this.eventRegistration.forMaintenanceModeAcknowledgeEvents(new MaintenanceModeChangedEventHandler(bundleContext));
        this.eventRegistration.forBackendModuleLoadedEvents(MODULE_ID, new LogServiceModuleLoadedEventHandler());
        this.eventRegistration.forIndexRestoreFromBackupStartEvents(new IndexBackupRestoreStartEventHandler());
        this.eventRegistration.forIndexRestoredFromBackupDoneEvents(new IndexBackupRestoreDoneEventHandler());
    }

    @Override
    public void destroy() {
        LOG.info("destroy");
        super.destroy();
        if (this.loggingExecutorService != null) {
            this.loggingExecutorService.shutdown();
        }
        BpcServicesTracker.stopAll(this);
        this.eventRegistration.unregisterAllEventHandler();
    }

    @Override
    public ModuleConfiguration getDefaultConfiguration() {
        return ModuleConfigurationBuilder.newInstance().withModuleId(this.getModuleId()).addSortableGroupedSettingsFromFile(this.getModuleBundle(), "defaults/logservice/default_module_settings.json").build();
    }

    @Override
    public String getModuleId() {
        return MODULE_ID;
    }

    @Override
    public String getModuleName() {
        return "Log Service";
    }

    @Override
    public ModuleConfiguration getDefaultInstanceConfiguration() {
        return ModuleConfigurationBuilder.newInstance().withModuleId(this.getModuleId()).withInstanceId(null).addSortableGroupedSettingsFromFile(this.getModuleBundle(), "defaults/logservice/default_instance_settings.json").build();
    }

    @Override
    public Class<? extends ModuleInstance> getModuleInstanceClass() {
        return LogServiceModuleInstance.class;
    }

    public synchronized void stopBackupJobs() {
        LOG.info("stopBackupJobs()");
        try {
            this.backupManagerTracker.getService().stopBackupJobsWithPrefix("core:logservice:");
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to stop the log service backup jobs", ex);
        }
    }

    public synchronized void restartBackupJobs() {
        LOG.info("restartBackupJobs");
        this.stopBackupJobs();
        Map<String, ModuleInstance> logServiceModuleInstances = this.getModuleInstances();
        for (ModuleInstance moduleInstance : logServiceModuleInstances.values()) {
            LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)moduleInstance;
            try {
                LogServiceModuleInstance.Es esSettings = logServiceModuleInstance.getEsSettings();
                if (esSettings != null && esSettings.backup != null) {
                    String[] stringArray;
                    boolean childProcessingEnabled = esSettings.child != null;
                    boolean bl = esSettings.backup.enabled;
                    long l = esSettings.backup.intervalInSeconds;
                    long l2 = esSettings.backup.keepBackupsDurationInSeconds;
                    if (childProcessingEnabled) {
                        String[] stringArray2 = new String[2];
                        stringArray2[0] = esSettings.parent.index;
                        stringArray = stringArray2;
                        stringArray2[1] = esSettings.child.index;
                    } else {
                        String[] stringArray3 = new String[1];
                        stringArray = stringArray3;
                        stringArray3[0] = esSettings.parent.index;
                    }
                    BackupSetting backupSetting = new BackupSetting(bl, l, l2, stringArray);
                    this.backupManagerTracker.getService().scheduleBackupJobWithSettings("core:logservice:" + backupSetting.getIndicesToBackupNamesAsKey(), backupSetting);
                    continue;
                }
                LOG.info("No backup setting found for log service instance: " + logServiceModuleInstance);
            }
            catch (LogServiceSettingsException e) {
                LOG.log(Level.WARNING, "Ignoring log service backup exception.", e);
            }
            catch (ServiceNotFoundException ex) {
                LOG.log(Level.SEVERE, "Cannot schedule a log service backup job without the BackupManager");
            }
        }
    }

    public synchronized void restartBackupJob(LogServiceModuleInstance logServiceModuleInstance) {
        this.restartBackupJobs();
    }

    private DatabaseLogService createDatabaseLogService(LogServiceModuleInstance moduleInstance) throws LogServiceException {
        try {
            return new DatabaseLogService(this.databaseManagerTracker.getService(), moduleInstance.getDatabaseTableDataCache());
        }
        catch (ServiceNotFoundException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_MISSING_SERVICE, "The DatabaseManager service is missing.", ex);
        }
    }

    private ElasticsearchLogService createElasticsearchLogService() throws LogServiceException {
        try {
            ElasticsearchService es = this.elasticsearchServiceTracker.getService();
            Map<String, ?> defaultIndexCreationSettings = es.getDefaultIndexCreationSettings();
            List defaultDynamicTemplates = es.getDefaultDynamicTemplates();
            return new ElasticsearchLogService(es, this.percolatorsManagerTracker.getService(), defaultIndexCreationSettings, defaultDynamicTemplates);
        }
        catch (ServiceNotFoundException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_MISSING_SERVICE, "Either the Elasticsearch or the PercolatorsManager service is missing.", ex);
        }
    }

    public void deleteEntries(LogServiceModuleInstance moduleInstance, String timeZoneId, String parentQuery, String parentFilter) throws LogServiceException {
        ElasticsearchLogService logService;
        FutureTask<Exception> informClientsFutureTask;
        LOG.info("deleteEntries moduleInstance=" + moduleInstance + ", timeZoneId=" + timeZoneId + ", parentQuery=" + parentQuery + ", parentFilter=" + parentFilter);
        if (moduleInstance.isDatabaseLoggingEnabled()) {
            // empty if block
        }
        if (moduleInstance.isElasticsearchLoggingEnabled() && (informClientsFutureTask = (logService = this.createElasticsearchLogService()).deleteData(moduleInstance, timeZoneId, parentQuery, parentFilter)) != null) {
            this.loggingExecutorService.execute(informClientsFutureTask);
        }
    }

    public void deleteEntries(LogServiceModuleInstance moduleInstance, List<String> parentIDs) throws LogServiceException {
        FutureTask<Exception> informClientsFutureTask;
        LogService logService;
        LOG.info("deleteEntries moduleInstance=" + moduleInstance + ", parentIDs=" + parentIDs);
        if (moduleInstance.isDatabaseLoggingEnabled()) {
            logService = this.createDatabaseLogService(moduleInstance);
            logService.deleteData(moduleInstance, parentIDs);
        }
        if (moduleInstance.isElasticsearchLoggingEnabled() && (informClientsFutureTask = (logService = this.createElasticsearchLogService()).deleteData(moduleInstance, parentIDs)) != null) {
            this.loggingExecutorService.execute(informClientsFutureTask);
        }
    }

    public void deleteChildEntries(LogServiceModuleInstance moduleInstance, String parentId, List<String> childIDs) throws LogServiceException {
        FutureTask<Exception> informClientsFutureTask;
        LogService logService;
        LOG.info("deleteChildEntries moduleInstance=" + moduleInstance + ", parentId=" + parentId + ", childIDs=" + childIDs);
        if (moduleInstance.isDatabaseLoggingEnabled()) {
            logService = this.createDatabaseLogService(moduleInstance);
            logService.deleteChildData(moduleInstance, parentId, childIDs);
        }
        if (moduleInstance.isElasticsearchLoggingEnabled() && (informClientsFutureTask = (logService = this.createElasticsearchLogService()).deleteChildData(moduleInstance, parentId, childIDs)) != null) {
            this.loggingExecutorService.execute(informClientsFutureTask);
        }
    }

    public void log(boolean async, final LogServiceModuleInstance moduleInstance, final LogData logData) throws LogServiceException {
        LOG.info("log async=" + async + ", moduleInstance=" + moduleInstance + ", logData=...");
        if (logData == null || logData.entries == null || logData.entries.size() == 0) {
            throw new LogServiceException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "No data to log given");
        }
        if (async) {
            FutureTask<LogDataResult> logDataFutureTask = new FutureTask<LogDataResult>(new Callable<LogDataResult>(){

                @Override
                public LogDataResult call() {
                    try {
                        return LogServiceModule.this.logData(moduleInstance, logData);
                    }
                    catch (Exception ex) {
                        LOG.log(Level.SEVERE, ex.getMessage(), ex);
                        return null;
                    }
                }
            });
            this.loggingExecutorService.execute(logDataFutureTask);
        } else {
            this.logData(moduleInstance, logData);
        }
    }

    private LogDataResult logData(LogServiceModuleInstance moduleInstance, LogData logData) throws LogServiceException {
        FutureTask<Exception> informClientsFutureTask;
        LogService logService;
        LOG.info("logData moduleInstance=" + moduleInstance + ", logData=...");
        LOG.fine("ES logging enabled:" + moduleInstance.isElasticsearchLoggingEnabled());
        LOG.fine("DB logging enabled:" + moduleInstance.isDatabaseLoggingEnabled());
        ZonedDateTime currentDateTime = ZonedDateTime.now();
        if (moduleInstance.isDatabaseLoggingEnabled()) {
            logService = this.createDatabaseLogService(moduleInstance);
            logService.logData(moduleInstance, currentDateTime, logData);
        }
        if (moduleInstance.isElasticsearchLoggingEnabled() && (informClientsFutureTask = (logService = this.createElasticsearchLogService()).logData(moduleInstance, currentDateTime, logData)) != null) {
            this.loggingExecutorService.execute(informClientsFutureTask);
        }
        return new LogDataResult();
    }

    public List<LogServiceModuleInstance> getLogServicesUsingTargetIndexAliases(Set<String> aliases) throws LogServiceSettingsException {
        ArrayList<LogServiceModuleInstance> result = new ArrayList<LogServiceModuleInstance>();
        for (ModuleInstance moduleInstance : this.getModuleInstances().values()) {
            LogServiceModuleInstance.Es esSettings;
            LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)moduleInstance;
            if (!logServiceModuleInstance.isElasticsearchLoggingEnabled() || (esSettings = logServiceModuleInstance.getEsSettings()) == null) continue;
            boolean found = false;
            if (esSettings.parent != null && !StringUtil.isNullOrEmpty(esSettings.parent.index) && aliases.contains(esSettings.parent.index)) {
                found = true;
            }
            if (esSettings.child != null && !StringUtil.isNullOrEmpty(esSettings.child.index) && aliases.contains(esSettings.child.index)) {
                found = true;
            }
            if (!found) continue;
            result.add(logServiceModuleInstance);
        }
        return result;
    }

    public void updateElasticsearchIndexMappings(LogServiceModuleInstance logServiceModuleInstance) {
        LOG.info("updateElasticsearchIndexMappings logServiceModuleInstance=...");
        try {
            ElasticsearchLogService esLogService = this.createElasticsearchLogService();
            esLogService.updateElasticsearchIndexMappings(logServiceModuleInstance);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to update the Elasticsearch index mapping of the log service module instance: " + logServiceModuleInstance, ex);
        }
    }

    public LogData getLogData(LogServiceModuleInstance logServiceModuleInstance, String timeZoneId, Integer start, Integer limit, String parentQuery, String parentFilter, String parentSort, String childSort, boolean addChilds) throws LogServiceException {
        LOG.info("getLogData logServiceModuleInstance=..., timeZoneId=" + timeZoneId + ", start=" + start + ", limit=" + limit + ", parentQuery=" + parentQuery + ", parentFilter=" + parentFilter + ", parentSort=" + parentSort + ", childSort=" + childSort + ", addChilds=" + addChilds);
        if (logServiceModuleInstance.isElasticsearchLoggingEnabled()) {
            ElasticsearchLogService logService = this.createElasticsearchLogService();
            return logService.getLogData(this, logServiceModuleInstance, timeZoneId, start, limit, parentQuery, parentFilter, parentSort, childSort, addChilds);
        }
        if (logServiceModuleInstance.isDatabaseLoggingEnabled()) {
            DatabaseLogService logService = this.createDatabaseLogService(logServiceModuleInstance);
            return logService.getLogData(this, logServiceModuleInstance, timeZoneId, start, limit, parentQuery, parentFilter, parentSort, childSort, addChilds);
        }
        return null;
    }

    public LogData getLogData(LogServiceModuleInstance logServiceModuleInstance, String parentId) throws LogServiceException {
        LOG.info("getLogData logServiceModuleInstance=..., parentId=" + parentId);
        if (logServiceModuleInstance.isElasticsearchLoggingEnabled()) {
            ElasticsearchLogService logService = this.createElasticsearchLogService();
            return logService.getLogData(logServiceModuleInstance, parentId);
        }
        if (logServiceModuleInstance.isDatabaseLoggingEnabled()) {
            DatabaseLogService logService = this.createDatabaseLogService(logServiceModuleInstance);
            return logService.getLogData(logServiceModuleInstance, parentId);
        }
        return null;
    }

    public LogData getLogData(LogServiceModuleInstance logServiceModuleInstance, String parentId, String childId) throws LogServiceException {
        LOG.info("getLogData logServiceModuleInstance=..., parentId=" + parentId + ", childId=" + childId);
        if (logServiceModuleInstance.isElasticsearchLoggingEnabled()) {
            ElasticsearchLogService logService = this.createElasticsearchLogService();
            return logService.getLogData(logServiceModuleInstance, parentId, childId);
        }
        if (logServiceModuleInstance.isDatabaseLoggingEnabled()) {
            DatabaseLogService logService = this.createDatabaseLogService(logServiceModuleInstance);
            return logService.getLogData(logServiceModuleInstance, parentId, childId);
        }
        return null;
    }

    public void dropIndices(LogServiceModuleInstance moduleInstance) throws LogServiceException, ElasticsearchRelatedException {
        LOG.info("dropIndices moduleInstance=...");
        if (moduleInstance != null) {
            ElasticsearchLogService esLogService = this.createElasticsearchLogService();
            esLogService.dropIndices(moduleInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areUsedIndicesTemporaryUnavailable(LogServiceModuleInstance logServiceModuleInstance) throws LogServiceSettingsException {
        if (logServiceModuleInstance != null && logServiceModuleInstance.isElasticsearchLoggingEnabled()) {
            LogServiceModuleInstance.Es esSettings = logServiceModuleInstance.getEsSettings();
            Object object = INDICES_TEMPORARY_UNAVAILABLE_LOCK;
            synchronized (object) {
                if (esSettings.parent != null && this.indicesTemporaryUnavailable.contains(esSettings.parent.index)) {
                    return true;
                }
                if (esSettings.child != null && this.indicesTemporaryUnavailable.contains(esSettings.child.index)) {
                    return true;
                }
            }
        }
        return false;
    }

    private class MaintenanceModeChangedEventHandler
    extends AbstractMaintenanceModeAcknowledgeEventHandler {
        public MaintenanceModeChangedEventHandler(BundleContext bundleContext) {
            super(bundleContext, LogServiceModule.MODULE_ID);
        }

        @Override
        public void processNewMaintenanceMode(boolean maintenanceModeEnabled) {
            LOG.info(this.getClass().getSimpleName() + ".processNewMaintenanceMode enabled=" + maintenanceModeEnabled);
            try {
                if (maintenanceModeEnabled) {
                    LogServiceModule.this.stopBackupJobs();
                } else {
                    LogServiceModule.this.restartBackupJobs();
                }
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Failed to process the maintenance mode changed event.", ex);
            }
        }
    }

    private class LogServiceModuleLoadedEventHandler
    extends AbstractBackendModuleLoadedEventHandler {
        private LogServiceModuleLoadedEventHandler() {
        }

        @Override
        public void processLoadedModule(Module module) {
            LOG.info(this.getClass().getSimpleName() + ".processLoadedModule module=...");
            LogServiceModule.this.restartBackupJobs();
        }
    }

    private class IndexBackupRestoreStartEventHandler
    extends AbstractEventHandler {
        private IndexBackupRestoreStartEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processEvent(Event event) {
            Object aliases;
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            if (event != null && (aliases = event.getProperty("aliases")) instanceof List) {
                Object object = INDICES_TEMPORARY_UNAVAILABLE_LOCK;
                synchronized (object) {
                    LogServiceModule.this.indicesTemporaryUnavailable.addAll((List)aliases);
                }
            }
        }
    }

    private class IndexBackupRestoreDoneEventHandler
    extends AbstractEventHandler {
        private IndexBackupRestoreDoneEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processEvent(Event event) {
            Object aliases;
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            if (event != null && (aliases = event.getProperty("aliases")) instanceof List) {
                Object object = INDICES_TEMPORARY_UNAVAILABLE_LOCK;
                synchronized (object) {
                    LogServiceModule.this.indicesTemporaryUnavailable.removeAll((List)aliases);
                }
            }
        }
    }
}

