/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.logservice;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.InstantiableModule;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.LogServiceSettingsException;
import de.virtimo.bpc.core.lookupjoins.LookupJoins;
import de.virtimo.bpc.logservice.LogServiceModule;
import de.virtimo.bpc.logservice.db.DatabaseTableDataCache;
import de.virtimo.bpc.module.AbstractModuleInstance;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.beans.PropertyChangeEvent;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class LogServiceModuleInstance
extends AbstractModuleInstance {
    private static final Logger LOG = Logger.getLogger(LogServiceModuleInstance.class.getName());
    public static final String SETTING_MAINTENANCE_ENABLED = "maintenanceEnabled";
    public static final String SETTING_ES_LOGGING_ENABLED = "esLoggingEnabled";
    public static final String SETTING_ES = "es";
    public static final String SETTING_RDMS_LOGGING_ENABLED = "rdmsLoggingEnabled";
    public static final String SETTING_RDMS = "rdms";
    public static final String SETTING_KEYS = "keys";
    public static final String SETTING_FIELDS = "fields";
    public static final String SETTING_JOINS = "joins";
    private final DatabaseTableDataCache databaseTableDataCache = new DatabaseTableDataCache();
    private LookupJoins lookupJoins = null;

    public LogServiceModuleInstance(InstantiableModule pm, ModuleConfiguration mc, String instanceId) {
        super(pm, mc, instanceId);
    }

    @Override
    public void destroy() {
        LOG.info("destroy");
        super.destroy();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getSource() instanceof ModuleConfiguration) {
            LogServiceModule logServiceModule;
            if (SETTING_ES.equalsIgnoreCase(evt.getPropertyName())) {
                LOG.info(this.getModuleId() + ": 'es' setting changed: resetting prepare indices flags");
                InstantiableModule parentModule = this.getParentModule();
                if (parentModule instanceof LogServiceModule) {
                    LogServiceModule logServiceModule2 = (LogServiceModule)parentModule;
                    logServiceModule2.restartBackupJob(this);
                }
            }
            if (SETTING_RDMS.equalsIgnoreCase(evt.getPropertyName())) {
                LOG.info(this.getModuleId() + ": 'rdms' setting changed: clearing the database table datas cache");
                this.databaseTableDataCache.clear();
            }
            if (SETTING_JOINS.equalsIgnoreCase(evt.getPropertyName())) {
                LOG.info(this.getModuleId() + ": 'joins' setting changed: resetting the lookup joins");
                this.lookupJoins = null;
            }
            if (SETTING_FIELDS.equalsIgnoreCase(evt.getPropertyName())) {
                LOG.info(this.getModuleId() + ": 'fields' setting changed: updating the index mappings");
                if (!this.isMaintenanceEnabled() && this.isElasticsearchLoggingEnabled()) {
                    logServiceModule = (LogServiceModule)this.getParentModule();
                    logServiceModule.updateElasticsearchIndexMappings(this);
                }
            }
            if (SETTING_MAINTENANCE_ENABLED.equalsIgnoreCase(evt.getPropertyName())) {
                LOG.info(this.getModuleId() + ": 'maintenanceEnabled' setting changed: updating the index mappings");
                if (!this.isMaintenanceEnabled()) {
                    logServiceModule = (LogServiceModule)this.getParentModule();
                    logServiceModule.updateElasticsearchIndexMappings(this);
                }
            }
            if (SETTING_ES_LOGGING_ENABLED.equalsIgnoreCase(evt.getPropertyName())) {
                LOG.info(this.getModuleId() + ": 'esLoggingEnabled' setting changed: updating the index mappings");
                if (this.isElasticsearchLoggingEnabled()) {
                    logServiceModule = (LogServiceModule)this.getParentModule();
                    logServiceModule.updateElasticsearchIndexMappings(this);
                }
            }
        }
    }

    public DatabaseTableDataCache getDatabaseTableDataCache() {
        return this.databaseTableDataCache;
    }

    public boolean isMaintenanceEnabled() {
        return (Boolean)this.getConfiguration().getSetting(SETTING_MAINTENANCE_ENABLED).getValue();
    }

    public boolean isElasticsearchLoggingEnabled() {
        return (Boolean)this.getConfiguration().getSetting(SETTING_ES_LOGGING_ENABLED).getValue();
    }

    public boolean isDatabaseLoggingEnabled() {
        return (Boolean)this.getConfiguration().getSetting(SETTING_RDMS_LOGGING_ENABLED).getValue();
    }

    private <T> T convertJsonSetting(String settingName, Class<T> toClazz) throws LogServiceSettingsException {
        LOG.fine("convertJsonSetting setting=" + settingName + ", toClazz=" + toClazz);
        Setting setting = this.getConfiguration().getSetting(settingName);
        if (setting == null) {
            throw new LogServiceSettingsException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "Converting setting to JSON failed. The requested setting '${setting}' is null.", MapUtil.mapOf("setting", settingName));
        }
        try {
            return JsonUtil.getInstance().convertJavaContainerToPojo(setting.getValue(), toClazz);
        }
        catch (Exception ex) {
            throw new LogServiceSettingsException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "Converting setting to JSON failed. The setting '${setting}' has an invalid value.", MapUtil.mapOf("setting", setting.getName()), (Throwable)ex);
        }
    }

    public Es getEsSettings() throws LogServiceSettingsException {
        LOG.fine("getEsSettings");
        return this.convertJsonSetting(SETTING_ES, Es.class);
    }

    public Rdms getRdmsSettings() throws LogServiceSettingsException {
        LOG.fine("getRdmsSettings");
        return this.convertJsonSetting(SETTING_RDMS, Rdms.class);
    }

    public Keys getKeysSettings() throws LogServiceSettingsException {
        LOG.fine("getKeysSettings");
        return this.convertJsonSetting(SETTING_KEYS, Keys.class);
    }

    public Fields getFieldsSettings() throws LogServiceSettingsException {
        LOG.fine("getFieldsSettings");
        return this.convertJsonSetting(SETTING_FIELDS, Fields.class);
    }

    public LookupJoins getLookupJoins() {
        LOG.fine("getLookupJoins");
        if (this.lookupJoins == null) {
            this.lookupJoins = new LookupJoins(this.getConfiguration().getSetting(SETTING_JOINS));
        }
        return this.lookupJoins;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Es {
        public EsEntry parent;
        public EsEntry child;
        public EsBackup backup;

        public String toString() {
            return "Es{parent=" + this.parent + ", child=" + this.child + ", backup=" + this.backup + "}";
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class EsEntry {
            public String index;

            public void setIndex(String index) {
                this.index = index.toLowerCase();
            }

            public String toString() {
                return "EsEntry{index='" + this.index + "'}";
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class EsBackup {
            public boolean enabled = true;
            public int intervalInSeconds;
            public int keepBackupsDurationInSeconds;

            public String toString() {
                return "EsBackup{enabled=" + this.enabled + ", intervalInSeconds=" + this.intervalInSeconds + ", keepBackupsDurationInSeconds=" + this.keepBackupsDurationInSeconds + "}";
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Rdms {
        public String rdmsDataSourceName;
        public String rdmsTimeZone;
        public RdmsEntry parent;
        public RdmsEntry child;

        public ZoneId getRdmsTimeZoneAsZoneId() {
            return StringUtil.isNullOrEmpty(this.rdmsTimeZone) ? null : ZoneId.of(this.rdmsTimeZone);
        }

        public String toString() {
            return "Rdms{rdmsDataSourceName='" + this.rdmsDataSourceName + "', rdmsTimeZone='" + this.rdmsTimeZone + "', parent=" + this.parent + ", child=" + this.child + "}";
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class RdmsEntry {
            public String table;

            public String toString() {
                return "RdmsEntry{table='" + this.table + "'}";
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Keys {
        public KeysEntry parent;
        public KeysEntry child;

        public String toString() {
            return "Keys{parent=" + this.parent + ", child=" + this.child + "}";
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class KeysEntry {
            public String idColumns;

            public List<String> getIdColumnsAsList() {
                return StringUtil.explode(this.idColumns, ",");
            }

            public String toString() {
                return "KeysEntry{idColumns='" + this.idColumns + "'}";
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Fields {
        public Map<String, Field> parent;
        public Map<String, Field> child;

        public static Map<String, Object> createDataContainerWithoutFieldsToSkip(Map<String, Object> data, Set<String> fieldsToSkip) {
            if (fieldsToSkip == null || fieldsToSkip.isEmpty()) {
                return data;
            }
            HashMap<String, Object> result = new HashMap<String, Object>(data);
            for (String fieldToSkip : fieldsToSkip) {
                result.remove(fieldToSkip);
            }
            return result;
        }

        public static Map<String, Object> createDataContainerWithReplacedSysdatePlaceholders(Map<String, Object> data, Set<String> timestampFieldsInLowerCase, ZonedDateTime currentDateTime, ZoneId targetTimeZoneId) {
            if (timestampFieldsInLowerCase == null || timestampFieldsInLowerCase.isEmpty()) {
                return data;
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Map.Entry<String, Object> stringObjectEntry : data.entrySet()) {
                String key = stringObjectEntry.getKey();
                Object value = stringObjectEntry.getValue();
                if (timestampFieldsInLowerCase.contains(key.toLowerCase()) && value instanceof String && "SYSDATE".equals(value)) {
                    ZonedDateTime targetDateTime = targetTimeZoneId == null ? currentDateTime : currentDateTime.withZoneSameInstant(targetTimeZoneId);
                    result.put(key, Timestamp.valueOf(targetDateTime.toLocalDateTime()));
                    continue;
                }
                result.put(key, value);
            }
            return result;
        }

        private static Set<String> getFieldsToSkip(Map<String, Field> container, SkipFieldChecker skipFieldChecker) {
            HashSet<String> result = null;
            if (container != null) {
                for (Map.Entry<String, Field> stringFieldEntry : container.entrySet()) {
                    Field field = stringFieldEntry.getValue();
                    if (!skipFieldChecker.skipField(field)) continue;
                    if (result == null) {
                        result = new HashSet<String>();
                    }
                    result.add(stringFieldEntry.getKey());
                }
            }
            return result;
        }

        public Set<String> getEsParentFieldsToSkip() {
            return Fields.getFieldsToSkip(this.parent, new SkipEsFieldChecker());
        }

        public Set<String> getEsChildFieldsToSkip() {
            return Fields.getFieldsToSkip(this.child, new SkipEsFieldChecker());
        }

        public Set<String> getDbParentFieldsToSkip() {
            return Fields.getFieldsToSkip(this.parent, new SkipDbFieldChecker());
        }

        public Set<String> getDbChildFieldsToSkip() {
            return Fields.getFieldsToSkip(this.child, new SkipDbFieldChecker());
        }

        private static Set<String> getTimestampFieldsInLowerCase(Map<String, Field> container) {
            HashSet<String> result = null;
            if (container != null) {
                for (Map.Entry<String, Field> stringFieldEntry : container.entrySet()) {
                    Field field = stringFieldEntry.getValue();
                    if (!"timestamp".equalsIgnoreCase(field.type)) continue;
                    if (result == null) {
                        result = new HashSet<String>();
                    }
                    result.add(stringFieldEntry.getKey().toLowerCase());
                }
            }
            return result;
        }

        public Set<String> getParentTimestampFieldsInLowerCase() {
            return Fields.getTimestampFieldsInLowerCase(this.parent);
        }

        public Set<String> getChildTimestampFieldsInLowerCase() {
            return Fields.getTimestampFieldsInLowerCase(this.child);
        }

        public String toString() {
            return "Fields{parent=" + this.parent + ", child=" + this.child + "}";
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class Field {
            public String type;
            public String dbFormat;
            public boolean skipES;
            public boolean skipDB;

            public Field() {
            }

            public Field(String type) {
                this.type = type;
            }

            public String toString() {
                return "Field{type='" + this.type + "', dbFormat='" + this.dbFormat + "', skipES=" + this.skipES + ", skipDB=" + this.skipDB + "}";
            }
        }
    }

    private static class SkipDbFieldChecker
    implements SkipFieldChecker {
        private SkipDbFieldChecker() {
        }

        @Override
        public boolean skipField(Fields.Field field) {
            return field.skipDB;
        }
    }

    private static class SkipEsFieldChecker
    implements SkipFieldChecker {
        private SkipEsFieldChecker() {
        }

        @Override
        public boolean skipField(Fields.Field field) {
            return field.skipES;
        }
    }

    private static interface SkipFieldChecker {
        public boolean skipField(Fields.Field var1);
    }
}

