/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.logservice.es;

import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.Percolator;
import de.virtimo.bpc.api.PercolatorsManager;
import de.virtimo.bpc.api.es.BpcIndexCreateCallable;
import de.virtimo.bpc.api.es.BpcIndexState;
import de.virtimo.bpc.api.es.querybuilder.EsIndexMapping;
import de.virtimo.bpc.api.es.querybuilder.EsQueryBuilder;
import de.virtimo.bpc.api.es.querybuilder.EsSortBuilder;
import de.virtimo.bpc.api.exception.ElasticsearchIndexMappingNotFoundException;
import de.virtimo.bpc.api.exception.ElasticsearchIndexNotFoundException;
import de.virtimo.bpc.api.exception.ElasticsearchRelatedException;
import de.virtimo.bpc.api.exception.LogServiceException;
import de.virtimo.bpc.api.exception.LogServiceSettingsException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.lookupjoins.LookupJoin;
import de.virtimo.bpc.core.lookupjoins.LookupJoins;
import de.virtimo.bpc.core.percolators.PercolatorsProcessorImpl;
import de.virtimo.bpc.core.replicator.ElasticsearchRecordID;
import de.virtimo.bpc.logservice.LogService;
import de.virtimo.bpc.logservice.LogServiceModule;
import de.virtimo.bpc.logservice.LogServiceModuleInstance;
import de.virtimo.bpc.logservice.resource.LogData;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortBuilder;

public class ElasticsearchLogService
implements LogService {
    private static final Logger LOG = Logger.getLogger(ElasticsearchLogService.class.getName());
    private final ElasticsearchService es;
    private final PercolatorsManager percolatorsManager;
    private final Map<String, ?> defaultIndexCreationSettings;
    private final List defaultDynamicTemplates;
    private static final Object PARENT_INDEX_LOCK = new Object();
    private static final Object CHILD_INDEX_LOCK = new Object();

    public ElasticsearchLogService(ElasticsearchService es, PercolatorsManager percolatorsManager, Map<String, ?> defaultIndexCreationSettings, List defaultDynamicTemplates) {
        this.es = es;
        this.percolatorsManager = percolatorsManager;
        this.defaultIndexCreationSettings = defaultIndexCreationSettings;
        this.defaultDynamicTemplates = defaultDynamicTemplates;
    }

    private String createRecordId(List<String> idColumns, Map<String, Object> data) throws LogServiceException {
        LOG.fine("createRecordId idColumns=" + idColumns + ", data=...");
        TreeMap<String, Object> caseInsensitiveMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        caseInsensitiveMap.putAll(data);
        ArrayList<Object> idColumnValues = new ArrayList<Object>();
        for (String idColumn : idColumns) {
            Object value = caseInsensitiveMap.get(idColumn);
            if (value == null) {
                throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_FIELD_MISSING, "Did not find the key field '${keyField}' in the log data entry: ${data}", MapUtil.mapOf("keyField", idColumn, "data", "" + caseInsensitiveMap));
            }
            idColumnValues.add(value);
        }
        return ElasticsearchRecordID.create(idColumnValues);
    }

    public Map<String, Object> createDataContainerWithLookupJoinData(Map<String, Object> data, LookupJoins lookupJoins) throws ElasticsearchRelatedException {
        if (lookupJoins == null || !lookupJoins.hasEntries()) {
            return data;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(data);
        for (LookupJoin lookupJoin : lookupJoins.getEntries()) {
            Object value = result.get(lookupJoin.getKeyField());
            if (value == null) continue;
            Map<String, Object> alreadyPrefixedLookupData = lookupJoin.getAlreadyPrefixedLookupData(this.es, value);
            for (Map.Entry<String, Object> alreadyPrefixedLookupDataEntry : alreadyPrefixedLookupData.entrySet()) {
                result.put(alreadyPrefixedLookupDataEntry.getKey(), alreadyPrefixedLookupDataEntry.getValue());
            }
        }
        return result;
    }

    private Set<String> getAllChildIDsOfParent(LogServiceModuleInstance.Es esSettings, String parentKeyField, String parentId) throws ElasticsearchRelatedException {
        LOG.info("getAllChildIDsOfParent esSettings=" + esSettings + ", parentKeyField=" + parentKeyField + ", parentId=" + parentId);
        try {
            boolean childProcessingEnabled = esSettings.child != null;
            HashSet<String> result = new HashSet<String>();
            if (childProcessingEnabled) {
                RestHighLevelClient esClient = this.es.getClient();
                SearchRequest searchRequest = new SearchRequest().indices(esSettings.child.index).source(new SearchSourceBuilder().fetchSource(new String[]{parentKeyField}, null).size(100).query(QueryBuilders.constantScoreQuery(QueryBuilders.termQuery(parentKeyField, parentId)))).scroll(new TimeValue(60000L));
                SearchResponse searchResponse = esClient.search(searchRequest, RequestOptions.DEFAULT);
                do {
                    for (SearchHit hit : searchResponse.getHits().getHits()) {
                        result.add(hit.getId());
                    }
                } while ((searchResponse = esClient.scroll(new SearchScrollRequest(searchResponse.getScrollId()).scroll(new TimeValue(60000L)), RequestOptions.DEFAULT)).getHits().getHits().length != 0);
                this.es.releaseScrollId(searchResponse);
            }
            return result;
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    private List<Map<String, Object>> getAllChildDocumentsOfParent(LogServiceModuleInstance.Es esSettings, String parentKeyField, Object parentId, List<SortBuilder> childSortBuilders) throws ElasticsearchRelatedException {
        LOG.info("getAllChildDocumentsOfParent esSettings=" + esSettings + ", parentKeyField=" + parentKeyField + ", parentId=" + parentId + ", childSortBuilders=" + childSortBuilders);
        try {
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
            RestHighLevelClient esClient = this.es.getClient();
            SearchSourceBuilder ssb = new SearchSourceBuilder().size(100).query(QueryBuilders.constantScoreQuery(QueryBuilders.termQuery(parentKeyField, parentId)));
            if (childSortBuilders != null) {
                for (SortBuilder childSortBuilder : childSortBuilders) {
                    ssb.sort(childSortBuilder);
                }
            }
            SearchRequest searchRequest = new SearchRequest().indices(esSettings.child.index).source(ssb).scroll(new TimeValue(60000L));
            SearchResponse searchResponse = esClient.search(searchRequest, RequestOptions.DEFAULT);
            do {
                for (SearchHit hit : searchResponse.getHits().getHits()) {
                    result.add(hit.getSourceAsMap());
                }
            } while ((searchResponse = esClient.scroll(new SearchScrollRequest(searchResponse.getScrollId()).scroll(new TimeValue(60000L)), RequestOptions.DEFAULT)).getHits().getHits().length != 0);
            this.es.releaseScrollId(searchResponse);
            return result;
        }
        catch (IOException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
        catch (ElasticsearchException ex) {
            throw new ElasticsearchRelatedException(ex);
        }
    }

    private List<SortBuilder> createSortBuilders(String sortInstructions, List<String> keyFields, String keyFieldsDirection, EsIndexMapping indexMapping) {
        if (!StringUtil.isNullOrEmpty(sortInstructions)) {
            return EsSortBuilder.init(indexMapping).addSortFromCompactFormat(sortInstructions).build();
        }
        EsSortBuilder esSortBuilder = EsSortBuilder.init(indexMapping);
        if (keyFields != null) {
            for (String keyField : keyFields) {
                esSortBuilder.addSort(keyField, keyFieldsDirection);
            }
        }
        return esSortBuilder.build();
    }

    @Override
    public FutureTask<Exception> deleteData(LogServiceModuleInstance moduleInstance, String timeZoneId, String parentQuery, String parentFilter) throws LogServiceException {
        LOG.info("deleteData moduleInstance=..., timeZoneId=" + timeZoneId + ", parentQuery=" + parentQuery + ", parentFilter=" + parentFilter);
        try {
            RestHighLevelClient esClient = this.es.getClient();
            LogServiceModuleInstance.Es esSettings = moduleInstance.getEsSettings();
            LogServiceModuleInstance.Keys keysSettings = moduleInstance.getKeysSettings();
            String parentKeyField = keysSettings.child.getIdColumnsAsList().get(0);
            EsIndexMapping parentIndexMapping = new EsIndexMapping(this.es.getMappingMetaData(esSettings.parent.index));
            QueryBuilder fetchParentIDsQuery = new EsQueryBuilder(esSettings.parent.index).addSkipPercolatorDocumentsQuery().addStringBasedQuery(parentQuery).addQueriesForFilters(parentFilter, parentIndexMapping, timeZoneId).buildAsBoolFilterQuery();
            SearchRequest fetchParentIDsRequest = new SearchRequest().indices(esSettings.parent.index).source(new SearchSourceBuilder().fetchSource(new String[]{parentKeyField}, null).size(1000).query(fetchParentIDsQuery)).scroll(new TimeValue(60000L));
            ArrayList<String> parentIDs = new ArrayList<String>();
            SearchResponse fetchParentIDsResponse = esClient.search(fetchParentIDsRequest, RequestOptions.DEFAULT);
            do {
                for (SearchHit hit : fetchParentIDsResponse.getHits().getHits()) {
                    parentIDs.add(hit.getId());
                }
            } while ((fetchParentIDsResponse = esClient.scroll(new SearchScrollRequest(fetchParentIDsResponse.getScrollId()).scroll(new TimeValue(60000L)), RequestOptions.DEFAULT)).getHits().getHits().length != 0);
            this.es.releaseScrollId(fetchParentIDsResponse);
            return this.deleteData(moduleInstance, parentIDs);
        }
        catch (ElasticsearchIndexMappingNotFoundException | ElasticsearchIndexNotFoundException | ElasticsearchRelatedException | IOException | ElasticsearchException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_FAILURE, "Failed to delete Elasticsearch data.", ex);
        }
    }

    @Override
    public FutureTask<Exception> deleteData(LogServiceModuleInstance moduleInstance, List<String> parentIDs) throws LogServiceException {
        LOG.info("deleteData moduleInstance=" + moduleInstance + ", parentIDs=" + parentIDs);
        try {
            BulkResponse bulkResponse;
            if (parentIDs == null || parentIDs.isEmpty()) {
                return null;
            }
            RestHighLevelClient esClient = this.es.getClient();
            final LogServiceModuleInstance.Es esSettings = moduleInstance.getEsSettings();
            LogServiceModuleInstance.Keys keysSettings = moduleInstance.getKeysSettings();
            final boolean childProcessingEnabled = esSettings.child != null;
            HashSet<String> elasticsearchParentRecordIDs = new HashSet<String>();
            for (String parentId : parentIDs) {
                String parentRecordId = ElasticsearchRecordID.create(Arrays.asList(parentId));
                elasticsearchParentRecordIDs.add(parentRecordId);
            }
            HashSet<String> elasticsearchChildRecordIDs = null;
            if (childProcessingEnabled) {
                String parentKeyField = keysSettings.child.getIdColumnsAsList().get(0);
                elasticsearchChildRecordIDs = new HashSet<String>();
                for (String parentId : parentIDs) {
                    elasticsearchChildRecordIDs.addAll(this.getAllChildIDsOfParent(esSettings, parentKeyField, parentId));
                }
            }
            PercolatorsProcessorImpl parentPercolatorsProcessor = null;
            Set<Percolator> parentPercolatorsFromIndex = this.percolatorsManager.getAllValidPercolatorsFromIndex(this.es, esSettings.parent.index);
            parentPercolatorsProcessor = new PercolatorsProcessorImpl(this.es, esSettings.parent.index, parentPercolatorsFromIndex);
            parentPercolatorsProcessor.setMaxNumberOfProcessableDatabaseIDs(10000L);
            parentPercolatorsProcessor.keepDeletedDatabaseIDs(elasticsearchParentRecordIDs);
            parentPercolatorsProcessor.processForDeleted();
            PercolatorsProcessorImpl childPercolatorsProcessor = null;
            if (childProcessingEnabled) {
                Set<Percolator> childPercolatorsFromIndex = this.percolatorsManager.getAllValidPercolatorsFromIndex(this.es, esSettings.child.index);
                childPercolatorsProcessor = new PercolatorsProcessorImpl(this.es, esSettings.child.index, childPercolatorsFromIndex);
                childPercolatorsProcessor.setMaxNumberOfProcessableDatabaseIDs(10000L);
                childPercolatorsProcessor.keepDeletedDatabaseIDs(elasticsearchChildRecordIDs);
                childPercolatorsProcessor.processForDeleted();
            }
            BulkRequest bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
            for (String parentRecordId : elasticsearchParentRecordIDs) {
                bulkRequest.add(new DeleteRequest(esSettings.parent.index).id(parentRecordId));
            }
            if (childProcessingEnabled) {
                for (String childRecordId : elasticsearchChildRecordIDs) {
                    bulkRequest.add(new DeleteRequest(esSettings.child.index).id(childRecordId));
                }
            }
            if ((bulkResponse = esClient.bulk(bulkRequest, RequestOptions.DEFAULT)).hasFailures()) {
                LOG.log(Level.SEVERE, "Errors on bulk action: " + bulkResponse.buildFailureMessage());
                return null;
            }
            LOG.fine("ES call done");
            final PercolatorsProcessorImpl finalParentPercolatorsProcessor = parentPercolatorsProcessor;
            final PercolatorsProcessorImpl finalChildPercolatorsProcessor = childPercolatorsProcessor;
            return new FutureTask<Exception>(new Callable<Exception>(){

                @Override
                public Exception call() {
                    try {
                        ElasticsearchLogService.this.percolatorsManager.informClientsAboutReplicatedData(ElasticsearchLogService.this.es, esSettings.parent.index, finalParentPercolatorsProcessor);
                        if (childProcessingEnabled) {
                            ElasticsearchLogService.this.percolatorsManager.informClientsAboutReplicatedData(ElasticsearchLogService.this.es, esSettings.child.index, finalChildPercolatorsProcessor);
                        }
                        return null;
                    }
                    catch (Exception ex) {
                        LOG.log(Level.SEVERE, ex.getMessage(), ex);
                        return ex;
                    }
                }
            });
        }
        catch (ElasticsearchRelatedException | IOException | ElasticsearchException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_FAILURE, "Failed to delete Elasticsearch data.", ex);
        }
    }

    @Override
    public FutureTask<Exception> deleteChildData(LogServiceModuleInstance moduleInstance, String parentId, List<String> childIDs) throws LogServiceException {
        LOG.info("deleteChildData moduleInstance=" + moduleInstance + ", parentId=" + parentId + ", childIDs=" + childIDs);
        try {
            boolean childProcessingEnabled;
            RestHighLevelClient esClient = this.es.getClient();
            final LogServiceModuleInstance.Es esSettings = moduleInstance.getEsSettings();
            boolean bl = childProcessingEnabled = esSettings.child != null;
            if (!childProcessingEnabled) {
                return null;
            }
            HashSet<String> elasticsearchChildRecordIDs = new HashSet<String>();
            for (String childId : childIDs) {
                String childRecordId = ElasticsearchRecordID.create(Arrays.asList(parentId, childId));
                elasticsearchChildRecordIDs.add(childRecordId);
            }
            Set<Percolator> childPercolatorsFromIndex = this.percolatorsManager.getAllValidPercolatorsFromIndex(this.es, esSettings.child.index);
            final PercolatorsProcessorImpl childPercolatorsProcessor = new PercolatorsProcessorImpl(this.es, esSettings.child.index, childPercolatorsFromIndex);
            childPercolatorsProcessor.setMaxNumberOfProcessableDatabaseIDs(10000L);
            childPercolatorsProcessor.keepDeletedDatabaseIDs(elasticsearchChildRecordIDs);
            childPercolatorsProcessor.processForDeleted();
            BulkRequest bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
            for (String childRecordId : elasticsearchChildRecordIDs) {
                bulkRequest.add(new DeleteRequest(esSettings.child.index).id(childRecordId));
            }
            BulkResponse bulkResponse = esClient.bulk(bulkRequest, RequestOptions.DEFAULT);
            if (bulkResponse.hasFailures()) {
                throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_DELETE_FAILED, "Failed to delete log service data. Elasticsearch error: ${error}", MapUtil.mapOf("error", bulkResponse.buildFailureMessage()));
            }
            LOG.fine("ES call done");
            return new FutureTask<Exception>(new Callable<Exception>(){

                @Override
                public Exception call() {
                    try {
                        ElasticsearchLogService.this.percolatorsManager.informClientsAboutReplicatedData(ElasticsearchLogService.this.es, esSettings.child.index, childPercolatorsProcessor);
                        return null;
                    }
                    catch (Exception ex) {
                        LOG.log(Level.SEVERE, ex.getMessage(), ex);
                        return ex;
                    }
                }
            });
        }
        catch (ElasticsearchRelatedException | IOException | ElasticsearchException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_FAILURE, "Failed to delete Elasticsearch data.", ex);
        }
    }

    public static Map<String, Object> fieldsAsElasticsearchMappingProperties(Map<String, LogServiceModuleInstance.Fields.Field> fields) {
        LOG.fine("fieldsAsElasticsearchMappingProperties fields=" + fields);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (fields != null && !fields.isEmpty()) {
            for (String fieldName : fields.keySet()) {
                LogServiceModuleInstance.Fields.Field field = fields.get(fieldName);
                if (field.skipES) continue;
                if ("binary".equalsIgnoreCase(field.type) || "attachment".equalsIgnoreCase(field.type)) {
                    properties.put(fieldName, MapUtil.mapOf("type", "binary"));
                }
                if ("integer".equalsIgnoreCase(field.type)) {
                    properties.put(fieldName, MapUtil.mapOf("type", "integer"));
                }
                if ("long".equalsIgnoreCase(field.type)) {
                    properties.put(fieldName, MapUtil.mapOf("type", "long"));
                }
                if ("float".equalsIgnoreCase(field.type)) {
                    properties.put(fieldName, MapUtil.mapOf("type", "float"));
                }
                if ("double".equalsIgnoreCase(field.type)) {
                    properties.put(fieldName, MapUtil.mapOf("type", "double"));
                }
                if ("boolean".equalsIgnoreCase(field.type)) {
                    properties.put(fieldName, MapUtil.mapOf("type", "boolean"));
                }
                if ("timestamp".equalsIgnoreCase(field.type)) {
                    properties.put(fieldName, MapUtil.mapOf("type", "date"));
                }
                if ("date:iso8601_millis".equalsIgnoreCase(field.type)) {
                    properties.put(fieldName, MapUtil.mapOf("type", "date", "format", "strict_date_optional_time||epoch_millis"));
                }
                if (!"text".equalsIgnoreCase(field.type)) continue;
                properties.put(fieldName, MapUtil.mapOf("type", "text", "fields", MapUtil.mapOf("raw", MapUtil.mapOf("type", "keyword"), "lowercase", MapUtil.mapOf("type", "keyword", "normalizer", "lowercaseNormalizer"))));
            }
        }
        properties.put("_percolator_query", MapUtil.mapOf("type", "percolator"));
        return properties;
    }

    private Map<String, Object> fieldsAsElasticsearchMapping(ElasticsearchService es, Map<String, LogServiceModuleInstance.Fields.Field> fields) {
        Map<String, Object> properties;
        LOG.fine("fieldsAsElasticsearchMapping es=..., fields=" + fields);
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        if (this.defaultDynamicTemplates != null && !this.defaultDynamicTemplates.isEmpty()) {
            mapping.put("dynamic_templates", this.defaultDynamicTemplates);
        }
        if ((properties = ElasticsearchLogService.fieldsAsElasticsearchMappingProperties(fields)) != null && !properties.isEmpty()) {
            mapping.put("properties", properties);
        }
        return mapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FutureTask<Exception> logData(LogServiceModuleInstance moduleInstance, ZonedDateTime currentDateTime, LogData logData) throws LogServiceException {
        LOG.info("logData moduleInstance=" + moduleInstance + ", logData=...");
        try {
            final LogServiceModuleInstance.Es esSettings = moduleInstance.getEsSettings();
            LogServiceModuleInstance.Keys keysSettings = moduleInstance.getKeysSettings();
            final LogServiceModuleInstance.Fields fieldsSettings = moduleInstance.getFieldsSettings();
            LookupJoins lookupJoins = moduleInstance.getLookupJoins();
            final boolean childProcessingEnabled = esSettings.child != null;
            Object object = PARENT_INDEX_LOCK;
            synchronized (object) {
                try {
                    BpcIndexState parentIndexState = this.es.getIndexState(esSettings.parent.index);
                    parentIndexState.prepareUsing(new BpcIndexCreateCallable(){

                        @Override
                        public String createIndex(ElasticsearchService es) throws ElasticsearchRelatedException, ServiceNotFoundException, ModuleNotFoundException {
                            return es.createIndex(esSettings.parent.index, ElasticsearchLogService.this.defaultIndexCreationSettings, ElasticsearchLogService.this.fieldsAsElasticsearchMapping(ElasticsearchLogService.this.es, fieldsSettings.parent));
                        }
                    });
                    if (!this.es.existsAttachmentsPipeline(esSettings.parent.index)) {
                        this.es.prepareAttachmentsPipeline(esSettings.parent.index);
                    }
                }
                catch (Exception ex) {
                    throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_LOGGING_FAILED, "Failed to prepare the parent index: ${error}", MapUtil.mapOf("index", esSettings.parent.index, "error", ex.getLocalizedMessage()), (Throwable)ex);
                }
            }
            if (childProcessingEnabled) {
                object = CHILD_INDEX_LOCK;
                synchronized (object) {
                    try {
                        BpcIndexState childIndexState = this.es.getIndexState(esSettings.child.index);
                        childIndexState.prepareUsing(new BpcIndexCreateCallable(){

                            @Override
                            public String createIndex(ElasticsearchService es) throws ElasticsearchRelatedException, ServiceNotFoundException, ModuleNotFoundException {
                                return es.createIndex(esSettings.child.index, ElasticsearchLogService.this.defaultIndexCreationSettings, ElasticsearchLogService.this.fieldsAsElasticsearchMapping(ElasticsearchLogService.this.es, fieldsSettings.child));
                            }
                        });
                        if (!this.es.existsAttachmentsPipeline(esSettings.child.index)) {
                            this.es.prepareAttachmentsPipeline(esSettings.child.index);
                        }
                    }
                    catch (Exception ex) {
                        throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_LOGGING_FAILED, "Failed to prepare the child index: ${error}", MapUtil.mapOf("index", esSettings.child.index, "error", ex.getLocalizedMessage()), (Throwable)ex);
                    }
                }
            }
            RestHighLevelClient esClient = this.es.getClient();
            Set<String> parentFieldsToSkip = fieldsSettings.getEsParentFieldsToSkip();
            Set<String> childFieldsToSkip = fieldsSettings.getEsChildFieldsToSkip();
            Set<String> parentTimestampFieldsInLowerCase = fieldsSettings.getParentTimestampFieldsInLowerCase();
            Set<String> childTimestampFieldsInLowerCase = fieldsSettings.getChildTimestampFieldsInLowerCase();
            BulkRequest bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
            for (LogData.LogDataEntry logDataEntry : logData.entries) {
                if (logDataEntry.parent != null) {
                    Map<String, Object> parentData = this.createDataContainerWithLookupJoinData(logDataEntry.parent, lookupJoins);
                    parentData = LogServiceModuleInstance.Fields.createDataContainerWithoutFieldsToSkip(parentData, parentFieldsToSkip);
                    parentData = LogServiceModuleInstance.Fields.createDataContainerWithReplacedSysdatePlaceholders(parentData, parentTimestampFieldsInLowerCase, currentDateTime, null);
                    parentData = this.createDataContainerWithConvertedValuesLikeElasticsearchNeedsThem(parentData);
                    String parentRecordId = this.createRecordId(keysSettings.parent.getIdColumnsAsList(), parentData);
                    if (logDataEntry.partialUpdate) {
                        UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(esSettings.parent.index)).id(parentRecordId).doc(parentData, XContentType.JSON);
                        bulkRequest.add(updateRequest);
                    } else {
                        IndexRequest indexRequest = ((IndexRequest)new IndexRequest().index(esSettings.parent.index)).id(parentRecordId).source(parentData, XContentType.JSON);
                        indexRequest.setPipeline(this.es.getAttachmentsPipelineName(esSettings.parent.index));
                        bulkRequest.add(indexRequest);
                    }
                }
                if (!childProcessingEnabled || logDataEntry.childs == null) continue;
                for (Map<String, Object> childData : logDataEntry.childs) {
                    childData = this.createDataContainerWithLookupJoinData(childData, lookupJoins);
                    childData = LogServiceModuleInstance.Fields.createDataContainerWithoutFieldsToSkip(childData, childFieldsToSkip);
                    childData = LogServiceModuleInstance.Fields.createDataContainerWithReplacedSysdatePlaceholders(childData, childTimestampFieldsInLowerCase, currentDateTime, null);
                    childData = this.createDataContainerWithConvertedValuesLikeElasticsearchNeedsThem(childData);
                    String childRecordId = this.createRecordId(keysSettings.child.getIdColumnsAsList(), childData);
                    if (logDataEntry.partialUpdate) {
                        UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(esSettings.child.index)).id(childRecordId).doc(childData, XContentType.JSON);
                        bulkRequest.add(updateRequest);
                        continue;
                    }
                    IndexRequest indexRequest = ((IndexRequest)new IndexRequest().index(esSettings.child.index)).id(childRecordId).source(childData, XContentType.JSON);
                    indexRequest.setPipeline(this.es.getAttachmentsPipelineName(esSettings.child.index));
                    bulkRequest.add(indexRequest);
                }
            }
            final BulkResponse bulkResponse = esClient.bulk(bulkRequest, RequestOptions.DEFAULT);
            if (bulkResponse.hasFailures()) {
                throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_LOGGING_FAILED, "Failed to bulk index the given log service data. Elasticsearch error: ${error}", MapUtil.mapOf("error", bulkResponse.buildFailureMessage()));
            }
            LOG.fine("ES call done");
            return new FutureTask<Exception>(new Callable<Exception>(){

                @Override
                public Exception call() {
                    try {
                        ElasticsearchLogService.this.percolatorsManager.informClientsAboutReplicatedData(ElasticsearchLogService.this.es, esSettings.parent.index, bulkResponse);
                        if (childProcessingEnabled) {
                            ElasticsearchLogService.this.percolatorsManager.informClientsAboutReplicatedData(ElasticsearchLogService.this.es, esSettings.child.index, bulkResponse);
                        }
                        return null;
                    }
                    catch (Exception ex) {
                        LOG.log(Level.SEVERE, ex.getMessage(), ex);
                        return ex;
                    }
                }
            });
        }
        catch (ElasticsearchRelatedException | IOException | ElasticsearchException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_FAILURE, "Failed to log data in Elasticsearch.", ex);
        }
    }

    private Map<String, Object> createDataContainerWithConvertedValuesLikeElasticsearchNeedsThem(Map<String, Object> data) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> stringObjectEntry : data.entrySet()) {
            String key = stringObjectEntry.getKey();
            Object value = stringObjectEntry.getValue();
            if (value instanceof Date) {
                result.put(key, this.es.formatForElasticsearch((Date)value));
                continue;
            }
            if (value instanceof Timestamp) {
                result.put(key, this.es.formatForElasticsearch((Timestamp)value));
                continue;
            }
            if (value instanceof java.util.Date) {
                result.put(key, this.es.formatForElasticsearch((java.util.Date)value));
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateElasticsearchIndexMappings(LogServiceModuleInstance logServiceModuleInstance) throws LogServiceSettingsException, ElasticsearchRelatedException {
        LOG.info("updateElasticsearchIndexMappings logServiceModuleInstance=...");
        if (logServiceModuleInstance != null) {
            LogServiceModuleInstance.Es esSettings = logServiceModuleInstance.getEsSettings();
            LogServiceModuleInstance.Fields fieldsSettings = logServiceModuleInstance.getFieldsSettings();
            boolean childProcessingEnabled = esSettings.child != null;
            Object object = PARENT_INDEX_LOCK;
            synchronized (object) {
                if (this.es.existsIndex(esSettings.parent.index)) {
                    try {
                        this.es.updateIndexMapping(esSettings.parent.index, this.fieldsAsElasticsearchMapping(this.es, fieldsSettings.parent));
                    }
                    catch (Exception ex) {
                        LOG.log(Level.SEVERE, "Failed to update the parent index mapping (" + esSettings.parent.index + ") of the log service module instance: " + logServiceModuleInstance, ex);
                    }
                }
            }
            if (childProcessingEnabled) {
                object = CHILD_INDEX_LOCK;
                synchronized (object) {
                    if (this.es.existsIndex(esSettings.child.index)) {
                        try {
                            this.es.updateIndexMapping(esSettings.child.index, this.fieldsAsElasticsearchMapping(this.es, fieldsSettings.child));
                        }
                        catch (Exception ex) {
                            LOG.log(Level.SEVERE, "Failed to update the child index mapping (" + esSettings.child.index + ") of the log service module instance: " + logServiceModuleInstance, ex);
                        }
                    }
                }
            }
        }
    }

    @Override
    public LogData getLogData(LogServiceModule logServiceModule, LogServiceModuleInstance moduleInstance, String timeZoneId, Integer start, Integer limit, String parentQuery, String parentFilter, String parentSort, String childSort, boolean addChilds) throws LogServiceException {
        LOG.info("getLogData logServiceModule=..., moduleInstance=..., timeZoneId=" + timeZoneId + ", start=" + start + ", limit=" + limit + ", parentQuery=" + parentQuery + ", parentFilter=" + parentFilter + ", parentSort=" + parentSort + ", childSort=" + childSort + ", addChilds=" + addChilds);
        try {
            if (start == null || start < 0) {
                start = 0;
                LOG.finest("Not start parameter or out of range. Set start to " + start);
            }
            if (limit == null || limit < 0 || limit > 10000) {
                limit = 100;
                LOG.finest("Not limit parameter or out of range. Set limit to " + limit);
            }
            RestHighLevelClient esClient = this.es.getClient();
            LogServiceModuleInstance.Es esSettings = moduleInstance.getEsSettings();
            LogServiceModuleInstance.Keys keysSettings = moduleInstance.getKeysSettings();
            int maxResultWindowSize = (Integer)logServiceModule.getConfiguration().getSetting("es_data_view_limit").getValue();
            int maxDataCount = (Integer)logServiceModule.getConfiguration().getSetting("es_data_count_limit").getValue();
            try {
                Settings settings = Settings.builder().put("max_result_window", maxResultWindowSize).build();
                esClient.indices().putSettings(new UpdateSettingsRequest(esSettings.parent.index).settings(settings), RequestOptions.DEFAULT);
            }
            catch (Exception e) {
                LOG.warning(e.getLocalizedMessage());
            }
            if (start + limit > maxResultWindowSize) {
                throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_QUERY_RANGE_LIMIT, "Requested range ${from} - ${to} is breaking the configured limit (${settingName}) of ${maxResultWindowSize}", MapUtil.mapOf("from", start, "to", start + limit, "settingName", "es_data_view_limit", "maxResultWindowSize", maxResultWindowSize));
            }
            EsIndexMapping parentIndexMapping = new EsIndexMapping(this.es.getMappingMetaData(esSettings.parent.index));
            List<SortBuilder> parentSortBuilders = this.createSortBuilders(parentSort, keysSettings.parent.getIdColumnsAsList(), "DESC", parentIndexMapping);
            List<SortBuilder> childSortBuilders = null;
            String parentKeyFieldForChildQuery = null;
            if (addChilds) {
                boolean childProcessingEnabled;
                boolean bl = childProcessingEnabled = esSettings.child != null;
                if (childProcessingEnabled) {
                    EsIndexMapping childIndexMapping = new EsIndexMapping(this.es.getMappingMetaData(esSettings.child.index));
                    childSortBuilders = this.createSortBuilders(childSort, keysSettings.child.getIdColumnsAsList(), "ASC", childIndexMapping);
                    parentKeyFieldForChildQuery = childIndexMapping.getPreferredQueryFieldForIDs(keysSettings.child.getIdColumnsAsList().get(0));
                }
            }
            SearchSourceBuilder ssb = new SearchSourceBuilder().from(start).size(limit).trackTotalHitsUpTo(maxDataCount);
            QueryBuilder esQuery = new EsQueryBuilder(esSettings.parent.index).addSkipPercolatorDocumentsQuery().addStringBasedQuery(parentQuery).addQueriesForFilters(parentFilter, parentIndexMapping, timeZoneId).buildAsBoolFilterQuery();
            ssb.query(esQuery);
            for (SortBuilder parentSortBuilder : parentSortBuilders) {
                ssb.sort(parentSortBuilder);
            }
            SearchRequest searchRequest = new SearchRequest().indices(esSettings.parent.index).source(ssb);
            LogData logData = new LogData();
            logData.entries = new ArrayList<LogData.LogDataEntry>();
            SearchResponse searchResponse = esClient.search(searchRequest, RequestOptions.DEFAULT);
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                Map<String, Object> sourceAsMap = hit.getSourceAsMap();
                LogData.LogDataEntry logDataEntry = new LogData.LogDataEntry();
                logDataEntry.partialUpdate = false;
                logDataEntry.parent = sourceAsMap;
                logDataEntry.childs = null;
                if (addChilds) {
                    boolean childProcessingEnabled;
                    boolean bl = childProcessingEnabled = esSettings.child != null;
                    if (childProcessingEnabled) {
                        String parentId = hit.getId();
                        logDataEntry.childs = this.getAllChildDocumentsOfParent(esSettings, parentKeyFieldForChildQuery, parentId, childSortBuilders);
                    }
                }
                logData.entries.add(logDataEntry);
            }
            return logData;
        }
        catch (ElasticsearchIndexMappingNotFoundException | ElasticsearchIndexNotFoundException | ElasticsearchRelatedException | IOException | ElasticsearchException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_FAILURE, "Failed to get log data from Elasticsearch.", ex);
        }
    }

    @Override
    public LogData getLogData(LogServiceModuleInstance moduleInstance, String parentId) throws LogServiceException {
        LOG.info("getLogData moduleInstance=..., parentId=" + parentId);
        try {
            boolean childProcessingEnabled;
            RestHighLevelClient esClient = this.es.getClient();
            LogServiceModuleInstance.Es esSettings = moduleInstance.getEsSettings();
            LogServiceModuleInstance.Keys keysSettings = moduleInstance.getKeysSettings();
            String parentDocumentId = ElasticsearchRecordID.create(List.of(parentId));
            Map<String, Object> parentDocument = this.fetchDocumentFromIndexById(esClient, esSettings.parent.index, parentDocumentId);
            LogData.LogDataEntry logDataEntry = new LogData.LogDataEntry();
            logDataEntry.partialUpdate = false;
            logDataEntry.parent = parentDocument;
            logDataEntry.childs = null;
            boolean bl = childProcessingEnabled = esSettings.child != null;
            if (childProcessingEnabled) {
                EsIndexMapping childIndexMapping = new EsIndexMapping(this.es.getMappingMetaData(esSettings.child.index));
                List<SortBuilder> childSortBuilders = this.createSortBuilders(null, keysSettings.child.getIdColumnsAsList(), "ASC", childIndexMapping);
                String parentKeyField = childIndexMapping.getPreferredQueryFieldForIDs(keysSettings.child.getIdColumnsAsList().get(0));
                logDataEntry.childs = this.getAllChildDocumentsOfParent(esSettings, parentKeyField, parentId, childSortBuilders);
            }
            LogData logData = new LogData();
            logData.entries = new ArrayList<LogData.LogDataEntry>();
            logData.entries.add(logDataEntry);
            return logData;
        }
        catch (ElasticsearchIndexMappingNotFoundException | ElasticsearchIndexNotFoundException | ElasticsearchRelatedException | IOException | ElasticsearchException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_FAILURE, "Failed to get log data from Elasticsearch.", ex);
        }
    }

    @Override
    public LogData getLogData(LogServiceModuleInstance moduleInstance, String parentId, String childId) throws LogServiceException {
        LOG.info("getLogData moduleInstance=..., parentId=" + parentId + ", childId=" + childId);
        try {
            boolean childProcessingEnabled;
            RestHighLevelClient esClient = this.es.getClient();
            LogServiceModuleInstance.Es esSettings = moduleInstance.getEsSettings();
            boolean bl = childProcessingEnabled = esSettings.child != null;
            if (!childProcessingEnabled) {
                return null;
            }
            String parentDocumentId = ElasticsearchRecordID.create(List.of(parentId));
            Map<String, Object> parentDocument = this.fetchDocumentFromIndexById(esClient, esSettings.parent.index, parentDocumentId);
            String childDocumentId = ElasticsearchRecordID.create(List.of(parentId, childId));
            Map<String, Object> childDocument = this.fetchDocumentFromIndexById(esClient, esSettings.child.index, childDocumentId);
            LogData.LogDataEntry logDataEntry = new LogData.LogDataEntry();
            logDataEntry.partialUpdate = true;
            logDataEntry.parent = parentDocument;
            logDataEntry.childs = new ArrayList<Map<String, Object>>();
            logDataEntry.childs.add(childDocument);
            LogData logData = new LogData();
            logData.entries = new ArrayList<LogData.LogDataEntry>();
            logData.entries.add(logDataEntry);
            return logData;
        }
        catch (IOException | ElasticsearchException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_FAILURE, "Failed to get log data from Elasticsearch.", ex);
        }
    }

    private Map<String, Object> fetchDocumentFromIndexById(RestHighLevelClient esClient, String index, String documentId) throws IOException {
        LOG.info("fetchDocumentFromIndexById esClient=..., index=" + index + ", documentId=" + documentId);
        GetRequest getReq = ((GetRequest)new GetRequest().index(index)).id(documentId);
        GetResponse response = esClient.get(getReq, RequestOptions.DEFAULT);
        return response.getSourceAsMap();
    }

    public void dropIndices(LogServiceModuleInstance moduleInstance) throws LogServiceSettingsException, ElasticsearchRelatedException {
        LOG.info("dropIndices moduleInstance=...");
        if (moduleInstance != null) {
            Set<String> indexNames;
            LogServiceModuleInstance.Es esSettings = moduleInstance.getEsSettings();
            if (esSettings != null && esSettings.parent != null && this.es.existsIndex(esSettings.parent.index)) {
                indexNames = this.es.getIndexNamesWithAlias(esSettings.parent.index);
                for (String name : indexNames) {
                    this.es.deleteIndex(name);
                }
            }
            if (esSettings != null && esSettings.child != null && this.es.existsIndex(esSettings.child.index)) {
                indexNames = this.es.getIndexNamesWithAlias(esSettings.child.index);
                for (String name : indexNames) {
                    this.es.deleteIndex(name);
                }
            }
        }
    }
}

