/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module;

import de.virtimo.bpc.api.CustomFields;
import de.virtimo.bpc.api.InstantiableModule;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.module.AbstractInstantiableModule;
import de.virtimo.bpc.module.GlobalDefaultModuleConfigurations;
import de.virtimo.bpc.module.simple.SimpleSettingImpl;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultModuleConfigurations {
    private static final Logger LOG = Logger.getLogger(DefaultModuleConfigurations.class.getName());
    private static DefaultModuleConfigurations instance;
    private final GlobalDefaultModuleConfigurations globalDefaultModuleConfigurations = new GlobalDefaultModuleConfigurations();

    private DefaultModuleConfigurations() {
    }

    public static DefaultModuleConfigurations getInstance() {
        if (instance == null) {
            instance = new DefaultModuleConfigurations();
        }
        return instance;
    }

    public static void destroySingleton() {
        instance = null;
    }

    public ModuleConfiguration merge(ModuleConfiguration targetConfig, ModuleConfiguration defaultConfig) throws SettingException {
        LOG.finest("mergeWith targetConfig=..., defaultConfig=...");
        for (Setting defaultSetting : defaultConfig.getSettings().values()) {
            Setting targetSetting = targetConfig.getSetting(defaultSetting.getName());
            if (targetSetting == null) {
                LOG.finest("merge default setting : " + defaultSetting.getName());
                targetConfig.addSetting(defaultSetting, true);
                continue;
            }
            if ((targetSetting.getType() == null || !targetSetting.getType().equals(defaultSetting.getType())) && targetSetting instanceof SimpleSettingImpl) {
                ((SimpleSettingImpl)targetSetting).setType(defaultSetting.getType());
            }
            CustomFields defaultCustomFields = defaultSetting.getCustomFields();
            CustomFields targetCustomFields = targetSetting.getCustomFields();
            if (defaultCustomFields.isEmpty()) {
                if (!targetCustomFields.isEmpty()) {
                    targetCustomFields.clear();
                }
            } else {
                HashSet<String> noLongerExistingTargetFields = new HashSet<String>(targetCustomFields.getFieldNames());
                noLongerExistingTargetFields.removeAll(defaultCustomFields.getFieldNames());
                for (String string : noLongerExistingTargetFields) {
                    targetCustomFields.removeField(string);
                }
                HashSet<String> missingFieldsInTarget = new HashSet<String>(defaultCustomFields.getFieldNames());
                missingFieldsInTarget.removeAll(targetCustomFields.getFieldNames());
                for (String missingField : missingFieldsInTarget) {
                    targetCustomFields.setObjectValue(missingField, defaultCustomFields.getObjectValue(missingField));
                }
                HashSet<String> hashSet = new HashSet<String>(targetCustomFields.getFieldNames());
                hashSet.removeAll(missingFieldsInTarget);
                targetCustomFields.overwriteProtectedFieldsWith(defaultCustomFields, hashSet);
            }
            LOG.log(Level.FINEST, "Ignore default for setting " + targetSetting);
        }
        return targetConfig;
    }

    public ModuleConfiguration getForModule(Module module) throws SettingException {
        LOG.fine("getForModule module=" + module);
        ModuleConfiguration defaultModuleConfiguration = module instanceof AbstractInstantiableModule ? ((AbstractInstantiableModule)module).getCachedDefaultConfiguration() : module.getDefaultConfiguration();
        return this.merge(defaultModuleConfiguration, this.globalDefaultModuleConfigurations.getForModule(module));
    }

    public ModuleConfiguration getForModuleInstance(InstantiableModule instantiableModule, String instanceType) throws SettingException {
        LOG.fine("getForModuleInstance instantiableModule=" + instantiableModule + ", instanceType=" + instanceType);
        ModuleConfiguration defaultModuleConfiguration = instantiableModule instanceof AbstractInstantiableModule ? ((AbstractInstantiableModule)instantiableModule).getCachedDefaultInstanceConfiguration(instanceType) : instantiableModule.getDefaultInstanceConfiguration(instanceType);
        return this.merge(defaultModuleConfiguration, this.globalDefaultModuleConfigurations.getForModuleInstance(instantiableModule, instanceType));
    }
}

