/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module;

import de.virtimo.bpc.api.InstantiableModule;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.module.ModuleConfigurationBuilder;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class GlobalDefaultModuleConfigurations {
    private static final Logger LOG = Logger.getLogger(GlobalDefaultModuleConfigurations.class.getName());
    private final ModuleConfiguration _globalDefaultNonInstantiableModuleConfiguration;
    private final ModuleConfiguration _globalDefaultInstantiableModuleConfiguration;
    private final ModuleConfiguration _globalDefaultModuleInstanceConfiguration;

    public GlobalDefaultModuleConfigurations() {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        this._globalDefaultNonInstantiableModuleConfiguration = ModuleConfigurationBuilder.newInstance().withModuleId("---").addSortableGroupedSettingsFromFile(bundle, "defaults/global_default_noninstantiable_module_settings.json").build();
        this._globalDefaultInstantiableModuleConfiguration = ModuleConfigurationBuilder.newInstance().withModuleId("---").addSortableGroupedSettingsFromFile(bundle, "defaults/global_default_instantiable_module_settings.json").build();
        this._globalDefaultModuleInstanceConfiguration = ModuleConfigurationBuilder.newInstance().withModuleId("---").withInstanceId("---").withInstanceType("---").addSortableGroupedSettingsFromFile(bundle, "defaults/global_default_instance_settings.json").build();
    }

    public ModuleConfiguration getForModule(Module module) {
        LOG.fine("getForModule module=" + module);
        if (module instanceof InstantiableModule) {
            return ModuleConfigurationBuilder.newInstance().withModuleId(module.getModuleId()).addSettings(this._globalDefaultInstantiableModuleConfiguration.getSettings().values()).build();
        }
        return ModuleConfigurationBuilder.newInstance().withModuleId(module.getModuleId()).addSettings(this._globalDefaultNonInstantiableModuleConfiguration.getSettings().values()).build();
    }

    public ModuleConfiguration getForModuleInstance(InstantiableModule module, String instanceType) {
        LOG.fine("getForModuleInstance module=" + module + ", instanceType=" + instanceType);
        return ModuleConfigurationBuilder.newInstance().withModuleId(module.getModuleId()).withInstanceId(null).withInstanceType(instanceType).addSettings(this._globalDefaultModuleInstanceConfiguration.getSettings().values()).build();
    }
}

