/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.simple;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.SettingValue;
import de.virtimo.bpc.api.SettingsValuesAccessor;
import de.virtimo.bpc.module.simple.SimpleSettingValueImpl;
import de.virtimo.bpc.module.simple.SimpleSettingsValuesAccessorImpl;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SimpleModuleConfig
implements ModuleConfiguration {
    private static final Logger LOG = Logger.getLogger(SimpleModuleConfig.class.getName());
    private final Map<String, Setting> settings;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public SimpleModuleConfig(Map<String, Setting> configMap) {
        this.settings = configMap;
    }

    public SimpleModuleConfig(List<? extends Setting> configList) {
        this.settings = new HashMap<String, Setting>();
        for (Setting setting : configList) {
            this.settings.put(setting.getName(), setting);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        LOG.fine("destroy");
        try {
            for (PropertyChangeListener propertyChangeListener : this.propertyChangeSupport.getPropertyChangeListeners()) {
                this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to remove the property change listeners.", ex);
        }
        finally {
            this.propertyChangeSupport = null;
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.propertyChangeSupport.addPropertyChangeListener(pcl);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.propertyChangeSupport.removePropertyChangeListener(pcl);
    }

    @Override
    public void setOwnerModule(Module configurationOwner) {
        String instanceType;
        String instanceId;
        String moduleId;
        if (configurationOwner instanceof ModuleInstance) {
            moduleId = ((ModuleInstance)configurationOwner).getParentModule().getModuleId();
            instanceId = configurationOwner.getModuleId();
            instanceType = ((ModuleInstance)configurationOwner).getInstanceType();
        } else {
            moduleId = configurationOwner.getModuleId();
            instanceId = "noinstance";
            instanceType = "none";
        }
        this.setOwner(this.settings, moduleId, instanceId, instanceType);
    }

    private void setOwner(Map<String, Setting> targetSettings, String moduleId, String instanceId, String instanceType) {
        if (targetSettings != null) {
            for (Setting setting : targetSettings.values()) {
                this.setOwner(setting, moduleId, instanceId, instanceType);
            }
        }
    }

    private void setOwner(Setting targetSetting, String moduleId, String instanceId, String instanceType) {
        if (targetSetting != null) {
            targetSetting.setModuleId(moduleId);
            targetSetting.setInstanceId(instanceId);
            targetSetting.setInstanceType(instanceType);
        }
    }

    @Override
    public Map<String, Setting> getSettings() {
        return this.settings;
    }

    @Override
    public Setting addSetting(Setting newSetting, boolean silent) throws SettingException {
        Setting oldSetting = this.settings.get(newSetting.getName());
        this.settings.put(newSetting.getName(), newSetting);
        if (!silent) {
            this.propertyChangeSupport.firePropertyChange(newSetting.getName(), oldSetting, newSetting);
        }
        return newSetting;
    }

    @Override
    public Setting addSetting(Setting newSetting) throws SettingException {
        return this.addSetting(newSetting, false);
    }

    @Override
    public void removeSetting(Setting settingToRemove, boolean silent) throws SettingException {
        this.settings.remove(settingToRemove.getName());
        if (!silent) {
            this.propertyChangeSupport.firePropertyChange(settingToRemove.getName(), settingToRemove, null);
        }
    }

    @Override
    public void removeSetting(Setting settingToRemove) throws SettingException {
        this.removeSetting(settingToRemove, false);
    }

    @Override
    public Setting updateSetting(Setting newSetting, boolean silent) throws SettingException {
        return this.addSetting(newSetting, silent);
    }

    @Override
    public Setting updateSetting(Setting newSetting) throws SettingException {
        return this.updateSetting(newSetting, false);
    }

    @Override
    public SettingValue getSettingValue(String settingName) {
        return new SimpleSettingValueImpl(this.settings.get(settingName));
    }

    @Override
    public boolean hasSetting(String settingName) {
        return this.settings.containsKey(settingName);
    }

    @Override
    public Setting getSetting(String settingName) {
        return this.settings.get(settingName);
    }

    @Override
    public Collection<Setting> getSettingsByName(Set<String> settingNames) {
        ArrayList<Setting> result = new ArrayList<Setting>();
        if (this.settings != null && settingNames != null && !settingNames.isEmpty()) {
            for (String settingName : settingNames) {
                Setting setting = this.settings.get(settingName);
                if (setting == null) continue;
                result.add(setting);
            }
        }
        return result;
    }

    @Override
    public SettingsValuesAccessor settingsValues() {
        return new SimpleSettingsValuesAccessorImpl(this);
    }
}

