/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.simple;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import de.virtimo.bpc.api.CustomFields;
import de.virtimo.bpc.api.InstantiableModule;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.module.simple.SimpleSettingImpl;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;

public class SimpleSettingSerializer
extends StdSerializer<SimpleSettingImpl> {
    public static final String WRITEABLE_KEY = "_writeable";
    public static final String READABLE_KEY = "_readable";

    public SimpleSettingSerializer() {
        this(null);
    }

    public SimpleSettingSerializer(Class<SimpleSettingImpl> t) {
        super(t);
    }

    public static SerializationConfig getSerializationConfig(ObjectMapper mapper, UserSession userSession, ModuleManager moduleManager) {
        SerializationConfig serializationConfigWithInjectedValue = mapper.getSerializationConfig().with(ContextAttributes.getEmpty().withSharedAttribute((Object)UserSession.class.getName(), (Object)userSession).withSharedAttribute((Object)ModuleManager.class.getName(), (Object)moduleManager));
        return serializationConfigWithInjectedValue;
    }

    private boolean isCompactSerializationForFrontend(UserSession userSession, ModuleManager moduleManager) {
        return userSession != null && moduleManager != null;
    }

    public void serialize(SimpleSettingImpl setting, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("id", setting.getId());
        jsonGenerator.writeStringField("name", setting.getName());
        jsonGenerator.writeStringField("type", setting.getType());
        jsonGenerator.writeObjectField("value", setting.getValue());
        jsonGenerator.writeStringField("moduleId", setting.getModuleId());
        jsonGenerator.writeStringField("instanceId", setting.getInstanceId());
        jsonGenerator.writeStringField("instanceType", setting.getInstanceType());
        UserSession userSession = (UserSession)serializerProvider.getAttribute((Object)UserSession.class.getName());
        ModuleManager moduleManager = (ModuleManager)serializerProvider.getAttribute((Object)ModuleManager.class.getName());
        if (this.isCompactSerializationForFrontend(userSession, moduleManager)) {
            this.serializeCustomFields(setting, jsonGenerator, userSession, moduleManager);
        } else {
            this.serializeCustomFields(setting, jsonGenerator);
        }
        jsonGenerator.writeEndObject();
    }

    private void serializeCustomFields(SimpleSettingImpl setting, JsonGenerator jsonGenerator) throws IOException {
        CustomFields customFields = setting.getCustomFields();
        for (String fieldName : customFields.getFieldNames()) {
            jsonGenerator.writeObjectField(fieldName, customFields.getObjectValue(fieldName));
        }
    }

    private void serializeCustomFields(SimpleSettingImpl setting, JsonGenerator jsonGenerator, UserSession userSession, ModuleManager moduleManager) throws IOException {
        boolean readable;
        boolean writeable;
        CustomFields customFields = setting.getCustomFields();
        for (String fieldName : customFields.getFieldNames()) {
            if ("_writeableByRoles".equals(fieldName) || "_readableByRoles".equals(fieldName)) continue;
            jsonGenerator.writeObjectField(fieldName, customFields.getObjectValue(fieldName));
        }
        try {
            Module module = this.getModuleOrModuleInstance(setting, moduleManager);
            writeable = userSession.hasWriteAccessToSetting(module, setting);
            readable = userSession.hasReadAccessToSetting(module, setting);
        }
        catch (ModuleInstanceNotFoundException | ModuleNotFoundException ex) {
            writeable = false;
            readable = false;
        }
        jsonGenerator.writeBooleanField(WRITEABLE_KEY, writeable);
        jsonGenerator.writeBooleanField(READABLE_KEY, readable);
    }

    private Module getModuleOrModuleInstance(Setting setting, ModuleManager moduleManager) throws ModuleNotFoundException, ModuleInstanceNotFoundException {
        if (StringUtil.isNullOrEmpty(setting.getInstanceId()) || "noinstance".equalsIgnoreCase(setting.getInstanceId())) {
            return moduleManager.getModuleById(setting.getModuleId());
        }
        Module module = moduleManager.getModuleById(setting.getModuleId());
        if (module instanceof InstantiableModule) {
            InstantiableModule instantiableModule = (InstantiableModule)module;
            return instantiableModule.getModuleInstanceById(setting.getInstanceId());
        }
        return null;
    }
}

