/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.util;

import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Socket;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.http.HTTPConduit;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class BpcTrustStore {
    private static final Logger LOG = Logger.getLogger(BpcTrustStore.class.getName());
    private static BpcTrustStore INSTANCE = null;
    private static final Object TRUSTSTORE_LOCK = new Object();
    private KeyStore cachedTrustStore = null;
    private long cachedTrustStoreFileLastModified = -1L;

    private BpcTrustStore() {
    }

    public static BpcTrustStore getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BpcTrustStore();
        }
        return INSTANCE;
    }

    public static void destroySingleton() {
        INSTANCE = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore getTrustStore(BundleContext bundleContext) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        LOG.info("getTrustStore bundleContext=...");
        Object object = TRUSTSTORE_LOCK;
        synchronized (object) {
            KeyStore keyStore;
            block14: {
                ServiceReference configurationAdminServiceReference = bundleContext.getServiceReference(ConfigurationAdmin.class);
                try {
                    ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)bundleContext.getService(configurationAdminServiceReference);
                    Configuration paxWebConf = configurationAdmin.getConfiguration("org.ops4j.pax.web");
                    Object trustStorePath = paxWebConf.getProcessedProperties(null).get("org.ops4j.pax.web.ssl.truststore");
                    Object trustStorePassword = paxWebConf.getProcessedProperties(null).get("org.ops4j.pax.web.ssl.truststore.password");
                    File trustStoreFile = new File((String)trustStorePath);
                    long trustStoreFileLastModified = trustStoreFile.lastModified();
                    if (this.cachedTrustStore == null || trustStoreFileLastModified != this.cachedTrustStoreFileLastModified) {
                        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                        try (FileInputStream is = new FileInputStream(trustStoreFile);){
                            trustStore.load(is, ((String)trustStorePassword).toCharArray());
                        }
                        this.cachedTrustStore = trustStore;
                        this.cachedTrustStoreFileLastModified = trustStoreFileLastModified;
                    }
                    keyStore = this.cachedTrustStore;
                    if (configurationAdminServiceReference == null) break block14;
                }
                catch (Throwable throwable) {
                    if (configurationAdminServiceReference != null) {
                        bundleContext.ungetService(configurationAdminServiceReference);
                    }
                    throw throwable;
                }
                bundleContext.ungetService(configurationAdminServiceReference);
            }
            return keyStore;
        }
    }

    public void setTo(WebClient webClient, boolean allowUntrustedConnections) throws NoSuchAlgorithmException, KeyStoreException {
        LOG.info("setTo webClient=..., allowUntrustedConnections=" + allowUntrustedConnections);
        if (webClient != null) {
            HTTPConduit conduit = WebClient.getConfig((Object)webClient).getHttpConduit();
            TLSClientParameters params = conduit.getTlsClientParameters();
            if (params == null) {
                params = new TLSClientParameters();
                conduit.setTlsClientParameters(params);
            }
            if (allowUntrustedConnections) {
                LOG.finest("Skip remote host certificate check on https");
                X509ExtendedTrustManager trustAllCertsTrustManager = this.getExtendedTrustAllCertsTrustManager();
                params.setTrustManagers(new TrustManager[]{trustAllCertsTrustManager});
                params.setDisableCNCheck(true);
            } else {
                LOG.finest("Set custom BPC trust manager");
                X509TrustManager bpcTrustManager = this.getBpcTrustManager();
                params.setTrustManagers(new TrustManager[]{bpcTrustManager});
            }
        }
    }

    public void setTo(URLConnection conn) throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        LOG.info("setTo conn=...");
        if (conn instanceof HttpsURLConnection) {
            X509TrustManager bpcTrustManager = this.getBpcTrustManager();
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{bpcTrustManager}, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            ((HttpsURLConnection)conn).setSSLSocketFactory(sslSocketFactory);
        }
    }

    public void setTo(HTTPRequest httpRequest) throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        LOG.info("setTo httpRequest=...");
        if (httpRequest != null) {
            X509TrustManager bpcTrustManager = this.getBpcTrustManager();
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{bpcTrustManager}, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            httpRequest.setSSLSocketFactory(sslSocketFactory);
        }
    }

    public X509TrustManager getBpcTrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        LOG.fine("getBpcTrustManager");
        final X509TrustManager defaultTrustManager = this.getDefaultTrustManager();
        final X509TrustManager virtimoTrustManager = this.getVirtimoTrustManager();
        return new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return defaultTrustManager.getAcceptedIssuers();
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                try {
                    virtimoTrustManager.checkServerTrusted(chain, authType);
                }
                catch (Exception e) {
                    defaultTrustManager.checkServerTrusted(chain, authType);
                }
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                defaultTrustManager.checkClientTrusted(chain, authType);
            }
        };
    }

    private X509TrustManager getDefaultTrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        LOG.fine("getDefaultTrustManager");
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init((KeyStore)null);
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            return (X509TrustManager)tm;
        }
        return null;
    }

    private X509TrustManager getVirtimoTrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        LOG.fine("getVirtimoTrustManager");
        try {
            BundleContext bundleContext = FrameworkUtil.getBundle(BpcTrustStore.class).getBundleContext();
            KeyStore bpcTrustStore = this.getTrustStore(bundleContext);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(bpcTrustStore);
            for (TrustManager tm : tmf.getTrustManagers()) {
                if (!(tm instanceof X509TrustManager)) continue;
                return (X509TrustManager)tm;
            }
        }
        catch (NullPointerException e) {
            LOG.log(Level.WARNING, "Could not find name of trust store, 'org.ops4j.pax.web.ssl.truststore' is not set", e);
        }
        catch (FileNotFoundException e) {
            LOG.log(Level.WARNING, "Could not find virtimo trust store (virtimo_truststore.jks in [karaf]/etc/virtimo/ssl)", e);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Error while loading virtimo trust store. Password might be invalid", e);
        }
        catch (CertificateException e) {
            LOG.log(Level.WARNING, "Virtimo trust store Certificate exception", e);
        }
        return null;
    }

    public X509TrustManager getTrustAllCertsTrustManager() {
        LOG.fine("getTrustAllCertsTrustManager");
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }

    public X509ExtendedTrustManager getExtendedTrustAllCertsTrustManager() {
        LOG.fine("getExtendedTrustAllCertsTrustManager");
        return new X509ExtendedTrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        };
    }
}

