/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class StreamUtil {
    private static final Logger LOG = Logger.getLogger(StreamUtil.class.getName());

    private StreamUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] gzip(byte[] dataToCompress) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(dataToCompress.length);
             GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
            gzipOutputStream.write(dataToCompress);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] gzip(String stringToCompress) throws IOException {
        return StreamUtil.gzip(stringToCompress.getBytes("UTF-8"));
    }

    public static boolean isGZipped(InputStream inputStream) {
        if (inputStream == null) {
            return false;
        }
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        inputStream.mark(2);
        int magic = 0;
        try {
            magic = inputStream.read() & 0xFF | inputStream.read() << 8 & 0xFF00;
            inputStream.reset();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, null, e);
            return false;
        }
        return magic == 35615;
    }

    public static byte[] unzip(InputStream zippedInputStream) throws IOException {
        GZIPInputStream in = new GZIPInputStream(zippedInputStream);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int read = 0;
        byte[] data = new byte[1024];
        try {
            while ((read = in.read(data, 0, 1024)) != -1) {
                out.write(data, 0, read);
            }
            in.close();
            out.close();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, null, e);
        }
        return out.toByteArray();
    }

    public static String characterStreamAsString(Reader characterStreamReader) throws IOException {
        int b;
        StringBuilder sb = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(characterStreamReader);
        while ((b = bufferedReader.read()) != -1) {
            sb.append((char)b);
        }
        bufferedReader.close();
        return sb.toString();
    }
}

