/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

public class UUIDGenerator {
    private static final char[] hexArray = "0123456789abcdef".toCharArray();

    public static String randomUUID() {
        String uuid = UUID.randomUUID().toString();
        try {
            MessageDigest salt = MessageDigest.getInstance("SHA-256");
            salt.update(uuid.getBytes(StandardCharsets.UTF_8));
            return UUIDGenerator.bytesToHex(salt.digest());
        }
        catch (NoSuchAlgorithmException e) {
            return uuid;
        }
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }
}

