/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.document;

import java.io.IOException;
import java.util.PriorityQueue;
import org.apache.lucene.search.suggest.document.NRTSuggester;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.PairOutputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;

final class NRTSuggesterBuilder {
    public static final int PAYLOAD_SEP = 31;
    public static final int END_BYTE = 0;
    private final PairOutputs<Long, BytesRef> outputs;
    private final Builder<PairOutputs.Pair<Long, BytesRef>> builder;
    private final IntsRefBuilder scratchInts = new IntsRefBuilder();
    private final BytesRefBuilder analyzed = new BytesRefBuilder();
    private final PriorityQueue<Entry> entries;
    private final int payloadSep;
    private final int endByte;
    private int maxAnalyzedPathsPerOutput = 0;

    public NRTSuggesterBuilder() {
        this.payloadSep = 31;
        this.endByte = 0;
        this.outputs = new PairOutputs<Long, BytesRef>(PositiveIntOutputs.getSingleton(), ByteSequenceOutputs.getSingleton());
        this.entries = new PriorityQueue();
        this.builder = new Builder(FST.INPUT_TYPE.BYTE1, this.outputs);
    }

    public void startTerm(BytesRef analyzed) {
        this.analyzed.copyBytes(analyzed);
        this.analyzed.append((byte)this.endByte);
    }

    public void addEntry(int docID, BytesRef surfaceForm, long weight) throws IOException {
        BytesRef payloadRef = NRTSuggester.PayLoadProcessor.make(surfaceForm, docID, this.payloadSep);
        this.entries.add(new Entry(payloadRef, NRTSuggester.encode(weight)));
    }

    public void finishTerm() throws IOException {
        int numArcs = 0;
        int numDedupBytes = 1;
        this.analyzed.grow(this.analyzed.length() + 1);
        this.analyzed.setLength(this.analyzed.length() + 1);
        for (Entry entry : this.entries) {
            if (numArcs == NRTSuggesterBuilder.maxNumArcsForDedupByte(numDedupBytes)) {
                this.analyzed.setByteAt(this.analyzed.length() - 1, (byte)numArcs);
                this.analyzed.grow(this.analyzed.length() + 1);
                this.analyzed.setLength(this.analyzed.length() + 1);
                numArcs = 0;
                ++numDedupBytes;
            }
            this.analyzed.setByteAt(this.analyzed.length() - 1, (byte)numArcs++);
            Util.toIntsRef(this.analyzed.get(), this.scratchInts);
            this.builder.add(this.scratchInts.get(), this.outputs.newPair(entry.weight, entry.payload));
        }
        this.maxAnalyzedPathsPerOutput = Math.max(this.maxAnalyzedPathsPerOutput, this.entries.size());
        this.entries.clear();
    }

    public boolean store(DataOutput output) throws IOException {
        FST<PairOutputs.Pair<Long, BytesRef>> build = this.builder.finish();
        if (build == null) {
            return false;
        }
        build.save(output, output);
        assert (this.maxAnalyzedPathsPerOutput > 0);
        output.writeVInt(this.maxAnalyzedPathsPerOutput);
        output.writeVInt(0);
        output.writeVInt(31);
        return true;
    }

    private static int maxNumArcsForDedupByte(int currentNumDedupBytes) {
        int maxArcs = 1 + 2 * currentNumDedupBytes;
        if (currentNumDedupBytes > 5) {
            maxArcs *= currentNumDedupBytes;
        }
        return Math.min(maxArcs, 255);
    }

    private static final class Entry
    implements Comparable<Entry> {
        final BytesRef payload;
        final long weight;

        public Entry(BytesRef payload, long weight) {
            this.payload = payload;
            this.weight = weight;
        }

        @Override
        public int compareTo(Entry o) {
            return Long.compare(this.weight, o.weight);
        }
    }
}

