/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.alias;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;

public class Alias
implements Writeable,
ToXContentFragment {
    private static final ParseField FILTER = new ParseField("filter", new String[0]);
    private static final ParseField ROUTING = new ParseField("routing", new String[0]);
    private static final ParseField INDEX_ROUTING = new ParseField("index_routing", "indexRouting", "index-routing");
    private static final ParseField SEARCH_ROUTING = new ParseField("search_routing", "searchRouting", "search-routing");
    private static final ParseField IS_WRITE_INDEX = new ParseField("is_write_index", new String[0]);
    private static final ParseField IS_HIDDEN = new ParseField("is_hidden", new String[0]);
    private String name;
    @Nullable
    private String filter;
    @Nullable
    private String indexRouting;
    @Nullable
    private String searchRouting;
    @Nullable
    private Boolean writeIndex;
    @Nullable
    private Boolean isHidden;

    public Alias(StreamInput in) throws IOException {
        this.name = in.readString();
        this.filter = in.readOptionalString();
        this.indexRouting = in.readOptionalString();
        this.searchRouting = in.readOptionalString();
        this.writeIndex = in.getVersion().onOrAfter(Version.V_6_4_0) ? in.readOptionalBoolean() : null;
        this.isHidden = in.getVersion().onOrAfter(Version.V_7_7_0) ? in.readOptionalBoolean() : null;
    }

    public Alias(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public String filter() {
        return this.filter;
    }

    public Alias filter(String filter) {
        this.filter = filter;
        return this;
    }

    public Alias filter(Map<String, Object> filter) {
        if (filter == null || filter.isEmpty()) {
            this.filter = null;
            return this;
        }
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(filter);
            this.filter = Strings.toString(builder);
            return this;
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + filter + "]", e);
        }
    }

    public Alias filter(QueryBuilder filterBuilder) {
        if (filterBuilder == null) {
            this.filter = null;
            return this;
        }
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            filterBuilder.toXContent(builder, ToXContent.EMPTY_PARAMS);
            builder.close();
            this.filter = Strings.toString(builder);
            return this;
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to build json for alias request", e);
        }
    }

    public Alias routing(String routing) {
        this.indexRouting = routing;
        this.searchRouting = routing;
        return this;
    }

    public String indexRouting() {
        return this.indexRouting;
    }

    public Alias indexRouting(String indexRouting) {
        this.indexRouting = indexRouting;
        return this;
    }

    public String searchRouting() {
        return this.searchRouting;
    }

    public Alias searchRouting(String searchRouting) {
        this.searchRouting = searchRouting;
        return this;
    }

    public Boolean writeIndex() {
        return this.writeIndex;
    }

    public Alias writeIndex(@Nullable Boolean writeIndex) {
        this.writeIndex = writeIndex;
        return this;
    }

    public Boolean isHidden() {
        return this.isHidden;
    }

    public Alias isHidden(@Nullable Boolean isHidden) {
        this.isHidden = isHidden;
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeOptionalString(this.filter);
        out.writeOptionalString(this.indexRouting);
        out.writeOptionalString(this.searchRouting);
        if (out.getVersion().onOrAfter(Version.V_6_4_0)) {
            out.writeOptionalBoolean(this.writeIndex);
        }
        if (out.getVersion().onOrAfter(Version.V_7_7_0)) {
            out.writeOptionalBoolean(this.isHidden);
        }
    }

    public static Alias fromXContent(XContentParser parser) throws IOException {
        Alias alias = new Alias(parser.currentName());
        String currentFieldName = null;
        XContentParser.Token token = parser.nextToken();
        if (token == null) {
            throw new IllegalArgumentException("No alias is specified");
        }
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (!FILTER.match(currentFieldName, parser.getDeprecationHandler())) continue;
                Map<String, Object> filter = parser.mapOrdered();
                alias.filter(filter);
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (ROUTING.match(currentFieldName, parser.getDeprecationHandler())) {
                    alias.routing(parser.text());
                    continue;
                }
                if (INDEX_ROUTING.match(currentFieldName, parser.getDeprecationHandler())) {
                    alias.indexRouting(parser.text());
                    continue;
                }
                if (!SEARCH_ROUTING.match(currentFieldName, parser.getDeprecationHandler())) continue;
                alias.searchRouting(parser.text());
                continue;
            }
            if (token != XContentParser.Token.VALUE_BOOLEAN) continue;
            if (IS_WRITE_INDEX.match(currentFieldName, parser.getDeprecationHandler())) {
                alias.writeIndex(parser.booleanValue());
                continue;
            }
            if (!IS_HIDDEN.match(currentFieldName, parser.getDeprecationHandler())) continue;
            alias.isHidden(parser.booleanValue());
        }
        return alias;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        if (this.filter != null) {
            try (StreamInput stream = new BytesArray(this.filter).streamInput();){
                builder.rawField(FILTER.getPreferredName(), stream, XContentType.JSON);
            }
        }
        if (this.indexRouting != null && this.indexRouting.equals(this.searchRouting)) {
            builder.field(ROUTING.getPreferredName(), this.indexRouting);
        } else {
            if (this.indexRouting != null) {
                builder.field(INDEX_ROUTING.getPreferredName(), this.indexRouting);
            }
            if (this.searchRouting != null) {
                builder.field(SEARCH_ROUTING.getPreferredName(), this.searchRouting);
            }
        }
        builder.field(IS_WRITE_INDEX.getPreferredName(), this.writeIndex);
        if (this.isHidden != null) {
            builder.field(IS_HIDDEN.getPreferredName(), this.isHidden);
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Alias alias = (Alias)o;
        return !(this.name != null ? !this.name.equals(alias.name) : alias.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }
}

