/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.PointerByReference;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.Constants;
import org.elasticsearch.bootstrap.JNACLibrary;
import org.elasticsearch.bootstrap.JNAKernel32Library;
import org.elasticsearch.core.internal.io.IOUtils;

final class SystemCallFilter {
    private static final Logger logger = LogManager.getLogger(SystemCallFilter.class);
    private static final LinuxLibrary linux_libc;
    static final int SECCOMP_SET_MODE_FILTER = 1;
    static final int SECCOMP_FILTER_FLAG_TSYNC = 1;
    static final int PR_GET_NO_NEW_PRIVS = 39;
    static final int PR_SET_NO_NEW_PRIVS = 38;
    static final int PR_GET_SECCOMP = 21;
    static final int PR_SET_SECCOMP = 22;
    static final long SECCOMP_MODE_FILTER = 2L;
    static final int BPF_LD = 0;
    static final int BPF_W = 0;
    static final int BPF_ABS = 32;
    static final int BPF_JMP = 5;
    static final int BPF_JEQ = 16;
    static final int BPF_JGE = 48;
    static final int BPF_JGT = 32;
    static final int BPF_RET = 6;
    static final int BPF_K = 0;
    static final int SECCOMP_RET_ERRNO = 327680;
    static final int SECCOMP_RET_DATA = 65535;
    static final int SECCOMP_RET_ALLOW = 0x7FFF0000;
    static final int EACCES = 13;
    static final int EFAULT = 14;
    static final int EINVAL = 22;
    static final int ENOSYS = 38;
    static final int SECCOMP_DATA_NR_OFFSET = 0;
    static final int SECCOMP_DATA_ARCH_OFFSET = 4;
    private static final Map<String, Arch> ARCHITECTURES;
    private static final MacLibrary libc_mac;
    static final int SANDBOX_NAMED = 1;
    static final String SANDBOX_RULES = "(version 1) (allow default) (deny process-fork) (deny process-exec)";
    private static final SolarisLibrary libc_solaris;
    static final int PRIV_OFF = 1;
    static final String PRIV_ALLSETS;
    static final String PRIV_PROC_FORK = "proc_fork";
    static final String PRIV_PROC_EXEC = "proc_exec";
    static final boolean OPENBSD;
    static final int RLIMIT_NPROC = 7;

    SystemCallFilter() {
    }

    static SockFilter BPF_STMT(int code, int k) {
        return new SockFilter((short)code, 0, 0, k);
    }

    static SockFilter BPF_JUMP(int code, int k, int jt, int jf) {
        return new SockFilter((short)code, (byte)jt, (byte)jf, k);
    }

    private static int linux_prctl(int option, long arg2, long arg3, long arg4, long arg5) {
        return linux_libc.prctl(option, new NativeLong(arg2), new NativeLong(arg3), new NativeLong(arg4), new NativeLong(arg5));
    }

    private static long linux_syscall(long number, Object ... args) {
        return linux_libc.syscall(new NativeLong(number), args).longValue();
    }

    private static int linuxImpl() {
        boolean supported;
        Arch arch = ARCHITECTURES.get(Constants.OS_ARCH);
        boolean bl = supported = Constants.LINUX && arch != null;
        if (!supported) {
            throw new UnsupportedOperationException("seccomp unavailable: '" + Constants.OS_ARCH + "' architecture unsupported");
        }
        if (linux_libc == null) {
            throw new UnsupportedOperationException("seccomp unavailable: could not link methods. requires kernel 3.5+ with CONFIG_SECCOMP and CONFIG_SECCOMP_FILTER compiled in");
        }
        int bogusArg = -140219812;
        long ret = SystemCallFilter.linux_syscall(arch.seccomp, -140219812);
        if (ret != -1L) {
            throw new UnsupportedOperationException("seccomp unavailable: seccomp(BOGUS_OPERATION) returned " + ret);
        }
        int errno = Native.getLastError();
        switch (errno) {
            case 38: {
                break;
            }
            case 22: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("seccomp(BOGUS_OPERATION): " + JNACLibrary.strerror(errno));
            }
        }
        ret = SystemCallFilter.linux_syscall(arch.seccomp, 1, -140219812);
        if (ret != -1L) {
            throw new UnsupportedOperationException("seccomp unavailable: seccomp(SECCOMP_SET_MODE_FILTER, BOGUS_FLAG) returned " + ret);
        }
        errno = Native.getLastError();
        switch (errno) {
            case 38: {
                break;
            }
            case 22: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("seccomp(SECCOMP_SET_MODE_FILTER, BOGUS_FLAG): " + JNACLibrary.strerror(errno));
            }
        }
        ret = SystemCallFilter.linux_prctl(-140219812, 0L, 0L, 0L, 0L);
        if (ret != -1L) {
            throw new UnsupportedOperationException("seccomp unavailable: prctl(BOGUS_OPTION) returned " + ret);
        }
        errno = Native.getLastError();
        switch (errno) {
            case 38: {
                break;
            }
            case 22: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("prctl(BOGUS_OPTION): " + JNACLibrary.strerror(errno));
            }
        }
        switch (SystemCallFilter.linux_prctl(39, 0L, 0L, 0L, 0L)) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                errno = Native.getLastError();
                if (errno == 22) {
                    throw new UnsupportedOperationException("seccomp unavailable: requires kernel 3.5+ with CONFIG_SECCOMP and CONFIG_SECCOMP_FILTER compiled in");
                }
                throw new UnsupportedOperationException("prctl(PR_GET_NO_NEW_PRIVS): " + JNACLibrary.strerror(errno));
            }
        }
        switch (SystemCallFilter.linux_prctl(21, 0L, 0L, 0L, 0L)) {
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                errno = Native.getLastError();
                if (errno == 22) {
                    throw new UnsupportedOperationException("seccomp unavailable: CONFIG_SECCOMP not compiled into kernel, CONFIG_SECCOMP and CONFIG_SECCOMP_FILTER are needed");
                }
                throw new UnsupportedOperationException("prctl(PR_GET_SECCOMP): " + JNACLibrary.strerror(errno));
            }
        }
        if (SystemCallFilter.linux_prctl(22, 2L, 0L, 0L, 0L) != 0) {
            errno = Native.getLastError();
            switch (errno) {
                case 14: {
                    break;
                }
                case 22: {
                    throw new UnsupportedOperationException("seccomp unavailable: CONFIG_SECCOMP_FILTER not compiled into kernel, CONFIG_SECCOMP and CONFIG_SECCOMP_FILTER are needed");
                }
                default: {
                    throw new UnsupportedOperationException("prctl(PR_SET_SECCOMP): " + JNACLibrary.strerror(errno));
                }
            }
        }
        if (SystemCallFilter.linux_prctl(38, 1L, 0L, 0L, 0L) != 0) {
            throw new UnsupportedOperationException("prctl(PR_SET_NO_NEW_PRIVS): " + JNACLibrary.strerror(Native.getLastError()));
        }
        if (SystemCallFilter.linux_prctl(39, 0L, 0L, 0L, 0L) != 1) {
            throw new UnsupportedOperationException("seccomp filter did not really succeed: prctl(PR_GET_NO_NEW_PRIVS): " + JNACLibrary.strerror(Native.getLastError()));
        }
        SockFilter[] insns = new SockFilter[]{SystemCallFilter.BPF_STMT(32, 4), SystemCallFilter.BPF_JUMP(21, arch.audit, 0, 7), SystemCallFilter.BPF_STMT(32, 0), SystemCallFilter.BPF_JUMP(37, arch.limit, 5, 0), SystemCallFilter.BPF_JUMP(21, arch.fork, 4, 0), SystemCallFilter.BPF_JUMP(21, arch.vfork, 3, 0), SystemCallFilter.BPF_JUMP(21, arch.execve, 2, 0), SystemCallFilter.BPF_JUMP(21, arch.execveat, 1, 0), SystemCallFilter.BPF_STMT(6, 0x7FFF0000), SystemCallFilter.BPF_STMT(6, 327693)};
        SockFProg prog = new SockFProg(insns);
        prog.write();
        long pointer = Pointer.nativeValue((Pointer)prog.getPointer());
        int method = 1;
        if (SystemCallFilter.linux_syscall(arch.seccomp, 1, 1, new NativeLong(pointer)) != 0L) {
            method = 0;
            int errno1 = Native.getLastError();
            if (logger.isDebugEnabled()) {
                logger.debug("seccomp(SECCOMP_SET_MODE_FILTER): {}, falling back to prctl(PR_SET_SECCOMP)...", (Object)JNACLibrary.strerror(errno1));
            }
            if (SystemCallFilter.linux_prctl(22, 2L, pointer, 0L, 0L) != 0) {
                int errno2 = Native.getLastError();
                throw new UnsupportedOperationException("seccomp(SECCOMP_SET_MODE_FILTER): " + JNACLibrary.strerror(errno1) + ", prctl(PR_SET_SECCOMP): " + JNACLibrary.strerror(errno2));
            }
        }
        if (SystemCallFilter.linux_prctl(21, 0L, 0L, 0L, 0L) != 2) {
            throw new UnsupportedOperationException("seccomp filter installation did not really succeed. seccomp(PR_GET_SECCOMP): " + JNACLibrary.strerror(Native.getLastError()));
        }
        logger.debug("Linux seccomp filter installation successful, threads: [{}]", (Object)(method == 1 ? "all" : "app"));
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void macImpl(Path tmpFile) throws IOException {
        block8: {
            Path rules;
            block7: {
                boolean supported = Constants.MAC_OS_X;
                if (!supported) {
                    throw new IllegalStateException("bug: should not be trying to initialize seatbelt for an unsupported OS");
                }
                if (libc_mac == null) {
                    throw new UnsupportedOperationException("seatbelt unavailable: could not link methods. requires Leopard or above.");
                }
                rules = Files.createTempFile(tmpFile, "es", "sb", new FileAttribute[0]);
                Files.write(rules, Collections.singleton(SANDBOX_RULES), new OpenOption[0]);
                boolean success = false;
                try {
                    PointerByReference errorRef = new PointerByReference();
                    int ret = libc_mac.sandbox_init(rules.toAbsolutePath().toString(), 1L, errorRef);
                    if (ret != 0) {
                        Pointer errorBuf = errorRef.getValue();
                        UnsupportedOperationException e = new UnsupportedOperationException("sandbox_init(): " + errorBuf.getString(0L));
                        libc_mac.sandbox_free_error(errorBuf);
                        throw e;
                    }
                    logger.debug("OS X seatbelt initialization successful");
                    success = true;
                    if (!success) break block7;
                }
                catch (Throwable throwable) {
                    if (success) {
                        Files.delete(rules);
                    } else {
                        IOUtils.deleteFilesIgnoringExceptions(rules);
                    }
                    throw throwable;
                }
                Files.delete(rules);
                break block8;
            }
            IOUtils.deleteFilesIgnoringExceptions(rules);
        }
    }

    static void solarisImpl() {
        boolean supported = Constants.SUN_OS;
        if (!supported) {
            throw new IllegalStateException("bug: should not be trying to initialize priv_set for an unsupported OS");
        }
        if (libc_solaris == null) {
            throw new UnsupportedOperationException("priv_set unavailable: could not link methods. requires Solaris 10+");
        }
        if (libc_solaris.priv_set(1, PRIV_ALLSETS, PRIV_PROC_FORK, PRIV_PROC_EXEC, null) != 0) {
            throw new UnsupportedOperationException("priv_set unavailable: priv_set(): " + JNACLibrary.strerror(Native.getLastError()));
        }
        logger.debug("Solaris priv_set initialization successful");
    }

    static void bsdImpl() {
        boolean supported;
        boolean bl = supported = Constants.FREE_BSD || OPENBSD || Constants.MAC_OS_X;
        if (!supported) {
            throw new IllegalStateException("bug: should not be trying to initialize RLIMIT_NPROC for an unsupported OS");
        }
        JNACLibrary.Rlimit limit = new JNACLibrary.Rlimit();
        limit.rlim_cur.setValue(0L);
        limit.rlim_max.setValue(0L);
        if (JNACLibrary.setrlimit(7, limit) != 0) {
            throw new UnsupportedOperationException("RLIMIT_NPROC unavailable: " + JNACLibrary.strerror(Native.getLastError()));
        }
        logger.debug("BSD RLIMIT_NPROC initialization successful");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void windowsImpl() {
        if (!Constants.WINDOWS) {
            throw new IllegalStateException("bug: should not be trying to initialize ActiveProcessLimit for an unsupported OS");
        }
        JNAKernel32Library lib = JNAKernel32Library.getInstance();
        Pointer job = lib.CreateJobObjectW(null, null);
        if (job == null) {
            throw new UnsupportedOperationException("CreateJobObject: " + Native.getLastError());
        }
        try {
            int clazz = 2;
            JNAKernel32Library.JOBOBJECT_BASIC_LIMIT_INFORMATION limits = new JNAKernel32Library.JOBOBJECT_BASIC_LIMIT_INFORMATION();
            limits.write();
            if (!lib.QueryInformationJobObject(job, clazz, limits.getPointer(), limits.size(), null)) {
                throw new UnsupportedOperationException("QueryInformationJobObject: " + Native.getLastError());
            }
            limits.read();
            limits.ActiveProcessLimit = 1;
            limits.LimitFlags = 8;
            limits.write();
            if (!lib.SetInformationJobObject(job, clazz, limits.getPointer(), limits.size())) {
                throw new UnsupportedOperationException("SetInformationJobObject: " + Native.getLastError());
            }
            if (!lib.AssignProcessToJobObject(job, lib.GetCurrentProcess())) {
                throw new UnsupportedOperationException("AssignProcessToJobObject: " + Native.getLastError());
            }
        }
        finally {
            lib.CloseHandle(job);
        }
        logger.debug("Windows ActiveProcessLimit initialization successful");
    }

    static int init(Path tmpFile) throws Exception {
        if (Constants.LINUX) {
            return SystemCallFilter.linuxImpl();
        }
        if (Constants.MAC_OS_X) {
            SystemCallFilter.bsdImpl();
            SystemCallFilter.macImpl(tmpFile);
            return 1;
        }
        if (Constants.SUN_OS) {
            SystemCallFilter.solarisImpl();
            return 1;
        }
        if (Constants.FREE_BSD || OPENBSD) {
            SystemCallFilter.bsdImpl();
            return 1;
        }
        if (Constants.WINDOWS) {
            SystemCallFilter.windowsImpl();
            return 1;
        }
        throw new UnsupportedOperationException("syscall filtering not supported for OS: '" + Constants.OS_NAME + "'");
    }

    static {
        Object lib = null;
        if (Constants.LINUX) {
            try {
                lib = (LinuxLibrary)Native.loadLibrary((String)"c", LinuxLibrary.class);
            }
            catch (UnsatisfiedLinkError e) {
                logger.warn("unable to link C library. native methods (seccomp) will be disabled.", (Throwable)e);
            }
        }
        linux_libc = lib;
        HashMap<String, Arch> m = new HashMap<String, Arch>();
        m.put("amd64", new Arch(-1073741762, 0x3FFFFFFF, 57, 58, 59, 322, 317));
        m.put("aarch64", new Arch(-1073741641, -1, 1079, 1071, 221, 281, 277));
        ARCHITECTURES = Collections.unmodifiableMap(m);
        lib = null;
        if (Constants.MAC_OS_X) {
            try {
                lib = (MacLibrary)Native.loadLibrary((String)"c", MacLibrary.class);
            }
            catch (UnsatisfiedLinkError e) {
                logger.warn("unable to link C library. native methods (seatbelt) will be disabled.", (Throwable)e);
            }
        }
        libc_mac = lib;
        lib = null;
        if (Constants.SUN_OS) {
            try {
                lib = (SolarisLibrary)Native.loadLibrary((String)"c", SolarisLibrary.class);
            }
            catch (UnsatisfiedLinkError e) {
                logger.warn("unable to link C library. native methods (priv_set) will be disabled.", (Throwable)e);
            }
        }
        libc_solaris = lib;
        PRIV_ALLSETS = null;
        OPENBSD = Constants.OS_NAME.startsWith("OpenBSD");
    }

    static final class SockFilter {
        short code;
        byte jt;
        byte jf;
        int k;

        SockFilter(short code, byte jt, byte jf, int k) {
            this.code = code;
            this.jt = jt;
            this.jf = jf;
            this.k = k;
        }
    }

    static interface LinuxLibrary
    extends Library {
        public int prctl(int var1, NativeLong var2, NativeLong var3, NativeLong var4, NativeLong var5);

        public NativeLong syscall(NativeLong var1, Object ... var2);
    }

    static class Arch {
        final int audit;
        final int limit;
        final int fork;
        final int vfork;
        final int execve;
        final int execveat;
        final int seccomp;

        Arch(int audit, int limit, int fork, int vfork, int execve, int execveat, int seccomp) {
            this.audit = audit;
            this.limit = limit;
            this.fork = fork;
            this.vfork = vfork;
            this.execve = execve;
            this.execveat = execveat;
            this.seccomp = seccomp;
        }
    }

    public static final class SockFProg
    extends Structure
    implements Structure.ByReference {
        public short len;
        public Pointer filter;

        SockFProg(SockFilter[] filters) {
            this.len = (short)filters.length;
            Memory filter = new Memory((long)(this.len * 8));
            ByteBuffer bbuf = filter.getByteBuffer(0L, (long)(this.len * 8));
            bbuf.order(ByteOrder.nativeOrder());
            for (SockFilter f : filters) {
                bbuf.putShort(f.code);
                bbuf.put(f.jt);
                bbuf.put(f.jf);
                bbuf.putInt(f.k);
            }
            this.filter = filter;
        }

        protected List<String> getFieldOrder() {
            return Arrays.asList("len", "filter");
        }
    }

    static interface MacLibrary
    extends Library {
        public int sandbox_init(String var1, long var2, PointerByReference var4);

        public void sandbox_free_error(Pointer var1);
    }

    static interface SolarisLibrary
    extends Library {
        public int priv_set(int var1, String var2, String ... var3);
    }
}

