/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Cancellable;
import org.elasticsearch.client.EqlRequestConverters;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.eql.EqlSearchRequest;
import org.elasticsearch.client.eql.EqlSearchResponse;
import org.elasticsearch.client.eql.EqlStatsRequest;
import org.elasticsearch.client.eql.EqlStatsResponse;

public final class EqlClient {
    private final RestHighLevelClient restHighLevelClient;

    EqlClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public EqlSearchResponse search(EqlSearchRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, EqlRequestConverters::search, options, EqlSearchResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable searchAsync(EqlSearchRequest request, RequestOptions options, ActionListener<EqlSearchResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, EqlRequestConverters::search, options, EqlSearchResponse::fromXContent, listener, Collections.emptySet());
    }

    public EqlStatsResponse stats(EqlStatsRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, EqlRequestConverters::stats, options, EqlStatsResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable statsAsync(EqlStatsRequest request, RequestOptions options, ActionListener<EqlStatsResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, EqlRequestConverters::stats, options, EqlStatsResponse::fromXContent, listener, Collections.emptySet());
    }
}

