/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Cancellable;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.RollupRequestConverters;
import org.elasticsearch.client.core.AcknowledgedResponse;
import org.elasticsearch.client.rollup.DeleteRollupJobRequest;
import org.elasticsearch.client.rollup.GetRollupCapsRequest;
import org.elasticsearch.client.rollup.GetRollupCapsResponse;
import org.elasticsearch.client.rollup.GetRollupIndexCapsRequest;
import org.elasticsearch.client.rollup.GetRollupIndexCapsResponse;
import org.elasticsearch.client.rollup.GetRollupJobRequest;
import org.elasticsearch.client.rollup.GetRollupJobResponse;
import org.elasticsearch.client.rollup.PutRollupJobRequest;
import org.elasticsearch.client.rollup.StartRollupJobRequest;
import org.elasticsearch.client.rollup.StartRollupJobResponse;
import org.elasticsearch.client.rollup.StopRollupJobRequest;
import org.elasticsearch.client.rollup.StopRollupJobResponse;

public class RollupClient {
    private final RestHighLevelClient restHighLevelClient;

    RollupClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public AcknowledgedResponse putRollupJob(PutRollupJobRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, RollupRequestConverters::putJob, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable putRollupJobAsync(PutRollupJobRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RollupRequestConverters::putJob, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public StartRollupJobResponse startRollupJob(StartRollupJobRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, RollupRequestConverters::startJob, options, StartRollupJobResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable startRollupJobAsync(StartRollupJobRequest request, RequestOptions options, ActionListener<StartRollupJobResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RollupRequestConverters::startJob, options, StartRollupJobResponse::fromXContent, listener, Collections.emptySet());
    }

    public StopRollupJobResponse stopRollupJob(StopRollupJobRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, RollupRequestConverters::stopJob, options, StopRollupJobResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable stopRollupJobAsync(StopRollupJobRequest request, RequestOptions options, ActionListener<StopRollupJobResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RollupRequestConverters::stopJob, options, StopRollupJobResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse deleteRollupJob(DeleteRollupJobRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, RollupRequestConverters::deleteJob, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable deleteRollupJobAsync(DeleteRollupJobRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RollupRequestConverters::deleteJob, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetRollupJobResponse getRollupJob(GetRollupJobRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, RollupRequestConverters::getJob, options, GetRollupJobResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable getRollupJobAsync(GetRollupJobRequest request, RequestOptions options, ActionListener<GetRollupJobResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RollupRequestConverters::getJob, options, GetRollupJobResponse::fromXContent, listener, Collections.emptySet());
    }

    public SearchResponse search(SearchRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, RollupRequestConverters::search, options, SearchResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable searchAsync(SearchRequest request, RequestOptions options, ActionListener<SearchResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RollupRequestConverters::search, options, SearchResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetRollupCapsResponse getRollupCapabilities(GetRollupCapsRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, RollupRequestConverters::getRollupCaps, options, GetRollupCapsResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable getRollupCapabilitiesAsync(GetRollupCapsRequest request, RequestOptions options, ActionListener<GetRollupCapsResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RollupRequestConverters::getRollupCaps, options, GetRollupCapsResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetRollupIndexCapsResponse getRollupIndexCapabilities(GetRollupIndexCapsRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, RollupRequestConverters::getRollupIndexCaps, options, GetRollupIndexCapsResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable getRollupIndexCapabilitiesAsync(GetRollupIndexCapsRequest request, RequestOptions options, ActionListener<GetRollupIndexCapsResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RollupRequestConverters::getRollupIndexCaps, options, GetRollupIndexCapsResponse::fromXContent, listener, Collections.emptySet());
    }
}

