/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.analytics;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.elasticsearch.client.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.AbstractPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class InferencePipelineAggregationBuilder
extends AbstractPipelineAggregationBuilder<InferencePipelineAggregationBuilder> {
    public static String NAME = "inference";
    public static final ParseField MODEL_ID = new ParseField("model_id", new String[0]);
    private static final ParseField INFERENCE_CONFIG = new ParseField("inference_config", new String[0]);
    private static final ConstructingObjectParser<InferencePipelineAggregationBuilder, String> PARSER = new ConstructingObjectParser<InferencePipelineAggregationBuilder, String>(NAME, false, (args, name) -> new InferencePipelineAggregationBuilder((String)name, (String)args[0], (Map)args[1]));
    private final Map<String, String> bucketPathMap;
    private final String modelId;
    private InferenceConfig inferenceConfig;

    public static InferencePipelineAggregationBuilder parse(String pipelineAggregatorName, XContentParser parser) {
        return PARSER.apply(parser, pipelineAggregatorName);
    }

    public InferencePipelineAggregationBuilder(String name, String modelId, Map<String, String> bucketsPath) {
        super(name, NAME, new TreeMap<String, String>(bucketsPath).values().toArray(new String[0]));
        this.modelId = modelId;
        this.bucketPathMap = bucketsPath;
    }

    public void setInferenceConfig(InferenceConfig inferenceConfig) {
        this.inferenceConfig = inferenceConfig;
    }

    @Override
    protected void validate(PipelineAggregationBuilder.ValidationContext context) {
    }

    @Override
    protected void doWriteTo(StreamOutput out) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected PipelineAggregator createInternal(Map<String, Object> metaData) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean overrideBucketsPath() {
        return true;
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(MODEL_ID.getPreferredName(), this.modelId);
        builder.field(BUCKETS_PATH_FIELD.getPreferredName(), this.bucketPathMap);
        if (this.inferenceConfig != null) {
            builder.startObject(INFERENCE_CONFIG.getPreferredName());
            builder.field(this.inferenceConfig.getName(), this.inferenceConfig);
            builder.endObject();
        }
        return builder;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.bucketPathMap, this.modelId, this.inferenceConfig);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InferencePipelineAggregationBuilder other = (InferencePipelineAggregationBuilder)obj;
        return Objects.equals(this.bucketPathMap, other.bucketPathMap) && Objects.equals(this.modelId, other.modelId) && Objects.equals(this.inferenceConfig, other.inferenceConfig);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), MODEL_ID);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.mapStrings(), BUCKETS_PATH_FIELD);
        PARSER.declareNamedObject(InferencePipelineAggregationBuilder::setInferenceConfig, (p, c, n) -> p.namedObject(InferenceConfig.class, n, c), INFERENCE_CONFIG);
    }
}

