/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.asyncsearch;

import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.ValidationException;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class SubmitAsyncSearchRequest
implements Validatable {
    public static long MIN_KEEP_ALIVE = TimeValue.timeValueMinutes(1L).millis();
    private TimeValue waitForCompletionTimeout;
    private Boolean keepOnCompletion;
    private TimeValue keepAlive;
    private final SearchRequest searchRequest;
    private Integer batchedReduceSize;

    public SubmitAsyncSearchRequest(SearchSourceBuilder source, String ... indices) {
        this.searchRequest = new SearchRequest(indices, source);
    }

    public String[] getIndices() {
        return this.searchRequest.indices();
    }

    public TimeValue getWaitForCompletionTimeout() {
        return this.waitForCompletionTimeout;
    }

    public void setWaitForCompletionTimeout(TimeValue waitForCompletionTimeout) {
        this.waitForCompletionTimeout = waitForCompletionTimeout;
    }

    public Boolean isKeepOnCompletion() {
        return this.keepOnCompletion;
    }

    public void setKeepOnCompletion(boolean keepOnCompletion) {
        this.keepOnCompletion = keepOnCompletion;
    }

    public TimeValue getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(TimeValue keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void setRouting(String routing) {
        this.searchRequest.routing(routing);
    }

    public void setRoutings(String ... routings) {
        this.searchRequest.routing(routings);
    }

    public String getRouting() {
        return this.searchRequest.routing();
    }

    public void setPreference(String preference) {
        this.searchRequest.preference(preference);
    }

    public String getPreference() {
        return this.searchRequest.preference();
    }

    public void setIndicesOptions(IndicesOptions indicesOptions) {
        this.searchRequest.indicesOptions(indicesOptions);
    }

    public IndicesOptions getIndicesOptions() {
        return this.searchRequest.indicesOptions();
    }

    public void setSearchType(SearchType searchType) {
        this.searchRequest.searchType(searchType);
    }

    public SearchType getSearchType() {
        return this.searchRequest.searchType();
    }

    public void setAllowPartialSearchResults(boolean allowPartialSearchResults) {
        this.searchRequest.allowPartialSearchResults(allowPartialSearchResults);
    }

    public Boolean getAllowPartialSearchResults() {
        return this.searchRequest.allowPartialSearchResults();
    }

    public void setBatchedReduceSize(int batchedReduceSize) {
        this.batchedReduceSize = batchedReduceSize;
    }

    public Integer getBatchedReduceSize() {
        return this.batchedReduceSize;
    }

    public void setRequestCache(Boolean requestCache) {
        this.searchRequest.requestCache(requestCache);
    }

    public Boolean getRequestCache() {
        return this.searchRequest.requestCache();
    }

    public int getMaxConcurrentShardRequests() {
        return this.searchRequest.getMaxConcurrentShardRequests();
    }

    public void setMaxConcurrentShardRequests(int maxConcurrentShardRequests) {
        this.searchRequest.setMaxConcurrentShardRequests(maxConcurrentShardRequests);
    }

    public SearchSourceBuilder getSearchSource() {
        return this.searchRequest.source();
    }

    @Override
    public Optional<ValidationException> validate() {
        ValidationException validationException = new ValidationException();
        if (this.searchRequest.isSuggestOnly()) {
            validationException.addValidationError("suggest-only queries are not supported");
        }
        if (this.keepAlive != null && this.keepAlive.getMillis() < MIN_KEEP_ALIVE) {
            validationException.addValidationError("[keep_alive] must be greater than 1 minute, got: " + this.keepAlive.toString());
        }
        if (validationException.validationErrors().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(validationException);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubmitAsyncSearchRequest request = (SubmitAsyncSearchRequest)o;
        return Objects.equals(this.searchRequest, request.searchRequest) && Objects.equals(this.getKeepAlive(), request.getKeepAlive()) && Objects.equals(this.getWaitForCompletionTimeout(), request.getWaitForCompletionTimeout()) && Objects.equals(this.isKeepOnCompletion(), request.isKeepOnCompletion());
    }

    public int hashCode() {
        return Objects.hash(this.searchRequest, this.getKeepAlive(), this.getWaitForCompletionTimeout(), this.isKeepOnCompletion());
    }
}

