/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.core;

import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public class MainResponse {
    private static final ConstructingObjectParser<MainResponse, Void> PARSER = new ConstructingObjectParser(MainResponse.class.getName(), true, args -> new MainResponse((String)args[0], (Version)args[1], (String)args[2], (String)args[3], (String)args[4]));
    private final String nodeName;
    private final Version version;
    private final String clusterName;
    private final String clusterUuid;
    private final String tagline;

    public MainResponse(String nodeName, Version version, String clusterName, String clusterUuid, String tagline) {
        this.nodeName = nodeName;
        this.version = version;
        this.clusterName = clusterName;
        this.clusterUuid = clusterUuid;
        this.tagline = tagline;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getClusterUuid() {
        return this.clusterUuid;
    }

    public String getTagline() {
        return this.tagline;
    }

    public static MainResponse fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MainResponse that = (MainResponse)o;
        return this.nodeName.equals(that.nodeName) && this.version.equals(that.version) && this.clusterName.equals(that.clusterName) && this.clusterUuid.equals(that.clusterUuid) && this.tagline.equals(that.tagline);
    }

    public int hashCode() {
        return Objects.hash(this.nodeName, this.version, this.clusterName, this.clusterUuid, this.tagline);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), Version.PARSER, new ParseField("version", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("cluster_name", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("cluster_uuid", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("tagline", new String[0]));
    }

    public static class Version {
        private static final ConstructingObjectParser<Version, Void> PARSER = new ConstructingObjectParser(Version.class.getName(), true, args -> new Version((String)args[0], (String)args[1], (String)args[2], (String)args[3], (String)args[4], (Boolean)args[5], (String)args[6], (String)args[7], (String)args[8]));
        private final String number;
        private final String buildFlavor;
        private final String buildType;
        private final String buildHash;
        private final String buildDate;
        private final boolean isSnapshot;
        private final String luceneVersion;
        private final String minimumWireCompatibilityVersion;
        private final String minimumIndexCompatibilityVersion;

        public Version(String number, String buildFlavor, String buildType, String buildHash, String buildDate, boolean isSnapshot, String luceneVersion, String minimumWireCompatibilityVersion, String minimumIndexCompatibilityVersion) {
            this.number = number;
            this.buildFlavor = buildFlavor;
            this.buildType = buildType;
            this.buildHash = buildHash;
            this.buildDate = buildDate;
            this.isSnapshot = isSnapshot;
            this.luceneVersion = luceneVersion;
            this.minimumWireCompatibilityVersion = minimumWireCompatibilityVersion;
            this.minimumIndexCompatibilityVersion = minimumIndexCompatibilityVersion;
        }

        public String getNumber() {
            return this.number;
        }

        public String getBuildFlavor() {
            return this.buildFlavor;
        }

        public String getBuildType() {
            return this.buildType;
        }

        public String getBuildHash() {
            return this.buildHash;
        }

        public String getBuildDate() {
            return this.buildDate;
        }

        public boolean isSnapshot() {
            return this.isSnapshot;
        }

        public String getLuceneVersion() {
            return this.luceneVersion;
        }

        public String getMinimumWireCompatibilityVersion() {
            return this.minimumWireCompatibilityVersion;
        }

        public String getMinimumIndexCompatibilityVersion() {
            return this.minimumIndexCompatibilityVersion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Version version = (Version)o;
            return this.isSnapshot == version.isSnapshot && this.number.equals(version.number) && Objects.equals(this.buildFlavor, version.buildFlavor) && Objects.equals(this.buildType, version.buildType) && this.buildHash.equals(version.buildHash) && this.buildDate.equals(version.buildDate) && this.luceneVersion.equals(version.luceneVersion) && this.minimumWireCompatibilityVersion.equals(version.minimumWireCompatibilityVersion) && this.minimumIndexCompatibilityVersion.equals(version.minimumIndexCompatibilityVersion);
        }

        public int hashCode() {
            return Objects.hash(this.number, this.buildFlavor, this.buildType, this.buildHash, this.buildDate, this.isSnapshot, this.luceneVersion, this.minimumWireCompatibilityVersion, this.minimumIndexCompatibilityVersion);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("number", new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("build_flavor", new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("build_type", new String[0]));
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("build_hash", new String[0]));
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("build_date", new String[0]));
            PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField("build_snapshot", new String[0]));
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("lucene_version", new String[0]));
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("minimum_wire_compatibility_version", new String[0]));
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("minimum_index_compatibility_version", new String[0]));
        }
    }
}

