/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.indices;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public class GetComponentTemplatesResponse {
    public static final ParseField NAME = new ParseField("name", new String[0]);
    public static final ParseField COMPONENT_TEMPLATES = new ParseField("component_templates", new String[0]);
    public static final ParseField COMPONENT_TEMPLATE = new ParseField("component_template", new String[0]);
    private static final ConstructingObjectParser<Map<String, ComponentTemplate>, Void> PARSER = new ConstructingObjectParser("component_templates", false, a -> ((List)a[0]).stream().collect(Collectors.toMap(n -> n.name, n -> n.componentTemplate, (n1, n2) -> n1, LinkedHashMap::new)));
    private static final ConstructingObjectParser<NamedComponentTemplate, Void> INNER_PARSER = new ConstructingObjectParser("named_component_template", false, a -> new NamedComponentTemplate((String)a[0], (ComponentTemplate)a[1]));
    private final Map<String, ComponentTemplate> componentTemplates;

    public String toString() {
        return "GetIndexTemplatesResponse [indexTemplates=" + this.componentTemplates + "]";
    }

    GetComponentTemplatesResponse(Map<String, ComponentTemplate> componentTemplates) {
        this.componentTemplates = Collections.unmodifiableMap(new LinkedHashMap<String, ComponentTemplate>(componentTemplates));
    }

    public Map<String, ComponentTemplate> getComponentTemplates() {
        return this.componentTemplates;
    }

    public static GetComponentTemplatesResponse fromXContent(XContentParser parser) throws IOException {
        return new GetComponentTemplatesResponse(PARSER.apply(parser, null));
    }

    public int hashCode() {
        return Objects.hash(this.componentTemplates);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetComponentTemplatesResponse other = (GetComponentTemplatesResponse)obj;
        return Objects.equals(this.componentTemplates, other.componentTemplates);
    }

    static {
        INNER_PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME);
        INNER_PARSER.declareObject(ConstructingObjectParser.constructorArg(), ComponentTemplate.PARSER, COMPONENT_TEMPLATE);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), INNER_PARSER, COMPONENT_TEMPLATES);
    }

    private static class NamedComponentTemplate {
        String name;
        ComponentTemplate componentTemplate;

        private NamedComponentTemplate(String name, ComponentTemplate componentTemplate) {
            this.name = name;
            this.componentTemplate = componentTemplate;
        }
    }
}

