/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.indices;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;

public class GetMappingsResponse {
    static final ParseField MAPPINGS = new ParseField("mappings", new String[0]);
    private Map<String, MappingMetadata> mappings;

    public GetMappingsResponse(Map<String, MappingMetadata> mappings) {
        this.mappings = mappings;
    }

    public Map<String, MappingMetadata> mappings() {
        return this.mappings;
    }

    public static GetMappingsResponse fromXContent(XContentParser parser) throws IOException {
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        XContentParserUtils.ensureExpectedToken(parser.currentToken(), XContentParser.Token.START_OBJECT, parser);
        Map<String, Object> parts = parser.map();
        HashMap<String, MappingMetadata> mappings = new HashMap<String, MappingMetadata>();
        for (Map.Entry<String, Object> entry : parts.entrySet()) {
            String indexName = entry.getKey();
            assert (entry.getValue() instanceof Map) : "expected a map as type mapping, but got: " + entry.getValue().getClass();
            Map fieldMappings = (Map)((Map)entry.getValue()).get(MAPPINGS.getPreferredName());
            mappings.put(indexName, new MappingMetadata("_doc", fieldMappings));
        }
        return new GetMappingsResponse(mappings);
    }
}

