/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.ValidationException;
import org.elasticsearch.client.ml.job.config.AnalysisConfig;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class EstimateModelMemoryRequest
implements Validatable,
ToXContentObject {
    public static final String ANALYSIS_CONFIG = "analysis_config";
    public static final String OVERALL_CARDINALITY = "overall_cardinality";
    public static final String MAX_BUCKET_CARDINALITY = "max_bucket_cardinality";
    private final AnalysisConfig analysisConfig;
    private Map<String, Long> overallCardinality = Collections.emptyMap();
    private Map<String, Long> maxBucketCardinality = Collections.emptyMap();

    @Override
    public Optional<ValidationException> validate() {
        return Optional.empty();
    }

    public EstimateModelMemoryRequest(AnalysisConfig analysisConfig) {
        this.analysisConfig = Objects.requireNonNull(analysisConfig);
    }

    public AnalysisConfig getAnalysisConfig() {
        return this.analysisConfig;
    }

    public Map<String, Long> getOverallCardinality() {
        return this.overallCardinality;
    }

    public void setOverallCardinality(Map<String, Long> overallCardinality) {
        this.overallCardinality = Collections.unmodifiableMap(overallCardinality);
    }

    public Map<String, Long> getMaxBucketCardinality() {
        return this.maxBucketCardinality;
    }

    public void setMaxBucketCardinality(Map<String, Long> maxBucketCardinality) {
        this.maxBucketCardinality = Collections.unmodifiableMap(maxBucketCardinality);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ANALYSIS_CONFIG, this.analysisConfig);
        if (!this.overallCardinality.isEmpty()) {
            builder.field(OVERALL_CARDINALITY, this.overallCardinality);
        }
        if (!this.maxBucketCardinality.isEmpty()) {
            builder.field(MAX_BUCKET_CARDINALITY, this.maxBucketCardinality);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.analysisConfig, this.overallCardinality, this.maxBucketCardinality);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        EstimateModelMemoryRequest that = (EstimateModelMemoryRequest)other;
        return Objects.equals(this.analysisConfig, that.analysisConfig) && Objects.equals(this.overallCardinality, that.overallCardinality) && Objects.equals(this.maxBucketCardinality, that.maxBucketCardinality);
    }
}

