/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class OpenJobResponse
implements ToXContentObject {
    private static final ParseField OPENED = new ParseField("opened", new String[0]);
    private static final ParseField NODE = new ParseField("node", new String[0]);
    public static final ConstructingObjectParser<OpenJobResponse, Void> PARSER = new ConstructingObjectParser("open_job_response", true, a -> new OpenJobResponse((Boolean)a[0], (String)a[1]));
    private final boolean opened;
    private final String node;

    OpenJobResponse(boolean opened, String node) {
        this.opened = opened;
        this.node = node;
    }

    public static OpenJobResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public boolean isOpened() {
        return this.opened;
    }

    public String getNode() {
        return this.node;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        OpenJobResponse that = (OpenJobResponse)other;
        return this.opened == that.opened && Objects.equals(this.node, that.node);
    }

    public int hashCode() {
        return Objects.hash(this.opened, this.node);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(OPENED.getPreferredName(), this.opened);
        if (this.node != null) {
            builder.field(NODE.getPreferredName(), this.node);
        }
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), OPENED);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), NODE);
    }
}

