/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.calendars;

import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import org.elasticsearch.client.common.TimeUtil;
import org.elasticsearch.client.ml.calendars.Calendar;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class ScheduledEvent
implements ToXContentObject {
    public static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
    public static final ParseField START_TIME = new ParseField("start_time", new String[0]);
    public static final ParseField END_TIME = new ParseField("end_time", new String[0]);
    public static final ParseField EVENT_ID = new ParseField("event_id", new String[0]);
    public static final String SCHEDULED_EVENT_TYPE = "scheduled_event";
    public static final ConstructingObjectParser<ScheduledEvent, Void> PARSER = new ConstructingObjectParser("scheduled_event", true, a -> new ScheduledEvent((String)a[0], (Date)a[1], (Date)a[2], (String)a[3], (String)a[4]));
    private final String description;
    private final Date startTime;
    private final Date endTime;
    private final String calendarId;
    private final String eventId;

    ScheduledEvent(String description, Date startTime, Date endTime, String calendarId, @Nullable String eventId) {
        this.description = Objects.requireNonNull(description);
        this.startTime = Objects.requireNonNull(startTime);
        this.endTime = Objects.requireNonNull(endTime);
        this.calendarId = Objects.requireNonNull(calendarId);
        this.eventId = eventId;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getCalendarId() {
        return this.calendarId;
    }

    public String getEventId() {
        return this.eventId;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DESCRIPTION.getPreferredName(), this.description);
        builder.timeField(START_TIME.getPreferredName(), START_TIME.getPreferredName() + "_string", this.startTime.getTime());
        builder.timeField(END_TIME.getPreferredName(), END_TIME.getPreferredName() + "_string", this.endTime.getTime());
        builder.field(Calendar.ID.getPreferredName(), this.calendarId);
        if (this.eventId != null) {
            builder.field(EVENT_ID.getPreferredName(), this.eventId);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ScheduledEvent other = (ScheduledEvent)obj;
        return Objects.equals(this.description, other.description) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.calendarId, other.calendarId);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.startTime, this.endTime, this.calendarId);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), DESCRIPTION);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> TimeUtil.parseTimeField(p, START_TIME.getPreferredName()), START_TIME, ObjectParser.ValueType.VALUE);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> TimeUtil.parseTimeField(p, END_TIME.getPreferredName()), END_TIME, ObjectParser.ValueType.VALUE);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Calendar.ID);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), EVENT_ID);
    }
}

