/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.dataframe.evaluation.classification;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.ml.dataframe.evaluation.EvaluationMetric;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class AucRocMetric
implements EvaluationMetric {
    public static final String NAME = "auc_roc";
    public static final ParseField CLASS_NAME = new ParseField("class_name", new String[0]);
    public static final ParseField INCLUDE_CURVE = new ParseField("include_curve", new String[0]);
    public static final ConstructingObjectParser<AucRocMetric, Void> PARSER = new ConstructingObjectParser("auc_roc", true, args -> new AucRocMetric((String)args[0], (Boolean)args[1]));
    private final String className;
    private final Boolean includeCurve;

    public static AucRocMetric fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public static AucRocMetric forClass(String className) {
        return new AucRocMetric(className, false);
    }

    public static AucRocMetric forClassWithCurve(String className) {
        return new AucRocMetric(className, true);
    }

    public AucRocMetric(String className, Boolean includeCurve) {
        this.className = Objects.requireNonNull(className);
        this.includeCurve = includeCurve;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(CLASS_NAME.getPreferredName(), this.className);
        if (this.includeCurve != null) {
            builder.field(INCLUDE_CURVE.getPreferredName(), this.includeCurve);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AucRocMetric that = (AucRocMetric)o;
        return Objects.equals(this.className, that.className) && Objects.equals(this.includeCurve, that.includeCurve);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.includeCurve);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), CLASS_NAME);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), INCLUDE_CURVE);
    }

    public static final class AucRocPoint
    implements ToXContentObject {
        private static final ParseField TPR = new ParseField("tpr", new String[0]);
        private static final ParseField FPR = new ParseField("fpr", new String[0]);
        private static final ParseField THRESHOLD = new ParseField("threshold", new String[0]);
        private static final ConstructingObjectParser<AucRocPoint, Void> PARSER = new ConstructingObjectParser("auc_roc_point", true, args -> new AucRocPoint((Double)args[0], (Double)args[1], (Double)args[2]));
        private final double tpr;
        private final double fpr;
        private final double threshold;

        public static AucRocPoint fromXContent(XContentParser parser) {
            return PARSER.apply(parser, null);
        }

        public AucRocPoint(double tpr, double fpr, double threshold) {
            this.tpr = tpr;
            this.fpr = fpr;
            this.threshold = threshold;
        }

        public double getTruePositiveRate() {
            return this.tpr;
        }

        public double getFalsePositiveRate() {
            return this.fpr;
        }

        public double getThreshold() {
            return this.threshold;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field(TPR.getPreferredName(), this.tpr).field(FPR.getPreferredName(), this.fpr).field(THRESHOLD.getPreferredName(), this.threshold).endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AucRocPoint that = (AucRocPoint)o;
            return this.tpr == that.tpr && this.fpr == that.fpr && this.threshold == that.threshold;
        }

        public int hashCode() {
            return Objects.hash(this.tpr, this.fpr, this.threshold);
        }

        public String toString() {
            return Strings.toString(this);
        }

        static {
            PARSER.declareDouble(ConstructingObjectParser.constructorArg(), TPR);
            PARSER.declareDouble(ConstructingObjectParser.constructorArg(), FPR);
            PARSER.declareDouble(ConstructingObjectParser.constructorArg(), THRESHOLD);
        }
    }

    public static class Result
    implements EvaluationMetric.Result {
        private static final ParseField SCORE = new ParseField("score", new String[0]);
        private static final ParseField CURVE = new ParseField("curve", new String[0]);
        private static final ConstructingObjectParser<Result, Void> PARSER = new ConstructingObjectParser("auc_roc_result", true, args -> new Result((Double)args[0], (List)args[1]));
        private final double score;
        private final List<AucRocPoint> curve;

        public static Result fromXContent(XContentParser parser) {
            return PARSER.apply(parser, null);
        }

        public Result(double score, @Nullable List<AucRocPoint> curve) {
            this.score = score;
            this.curve = curve;
        }

        @Override
        public String getMetricName() {
            return AucRocMetric.NAME;
        }

        public double getScore() {
            return this.score;
        }

        public List<AucRocPoint> getCurve() {
            return this.curve == null ? null : Collections.unmodifiableList(this.curve);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(SCORE.getPreferredName(), this.score);
            if (this.curve != null && !this.curve.isEmpty()) {
                builder.field(CURVE.getPreferredName(), this.curve);
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result that = (Result)o;
            return this.score == that.score && Objects.equals(this.curve, that.curve);
        }

        public int hashCode() {
            return Objects.hash(this.score, this.curve);
        }

        public String toString() {
            return Strings.toString(this);
        }

        static {
            PARSER.declareDouble(ConstructingObjectParser.constructorArg(), SCORE);
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> AucRocPoint.fromXContent(p), CURVE);
        }
    }
}

