/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.inference.preprocessing;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.ml.inference.preprocessing.PreProcessor;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class NGram
implements PreProcessor {
    public static final String NAME = "n_gram_encoding";
    public static final ParseField FIELD = new ParseField("field", new String[0]);
    public static final ParseField FEATURE_PREFIX = new ParseField("feature_prefix", new String[0]);
    public static final ParseField NGRAMS = new ParseField("n_grams", new String[0]);
    public static final ParseField START = new ParseField("start", new String[0]);
    public static final ParseField LENGTH = new ParseField("length", new String[0]);
    public static final ParseField CUSTOM = new ParseField("custom", new String[0]);
    private static final ConstructingObjectParser<NGram, Void> PARSER = new ConstructingObjectParser("n_gram_encoding", true, a -> new NGram((String)a[0], (List)a[1], (Integer)a[2], (Integer)a[3], (Boolean)a[4], (String)a[5]));
    private final String field;
    private final String featurePrefix;
    private final List<Integer> nGrams;
    private final Integer start;
    private final Integer length;
    private final Boolean custom;

    public static NGram fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    NGram(String field, List<Integer> nGrams, Integer start, Integer length, Boolean custom, String featurePrefix) {
        this.field = field;
        this.featurePrefix = featurePrefix;
        this.nGrams = nGrams;
        this.start = start;
        this.length = length;
        this.custom = custom;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.field != null) {
            builder.field(FIELD.getPreferredName(), this.field);
        }
        if (this.featurePrefix != null) {
            builder.field(FEATURE_PREFIX.getPreferredName(), this.featurePrefix);
        }
        if (this.nGrams != null) {
            builder.field(NGRAMS.getPreferredName(), this.nGrams);
        }
        if (this.start != null) {
            builder.field(START.getPreferredName(), this.start);
        }
        if (this.length != null) {
            builder.field(LENGTH.getPreferredName(), this.length);
        }
        if (this.custom != null) {
            builder.field(CUSTOM.getPreferredName(), this.custom);
        }
        builder.endObject();
        return builder;
    }

    public String getField() {
        return this.field;
    }

    public String getFeaturePrefix() {
        return this.featurePrefix;
    }

    public List<Integer> getnGrams() {
        return this.nGrams;
    }

    public Integer getStart() {
        return this.start;
    }

    public Integer getLength() {
        return this.length;
    }

    public Boolean getCustom() {
        return this.custom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NGram nGram = (NGram)o;
        return Objects.equals(this.field, nGram.field) && Objects.equals(this.featurePrefix, nGram.featurePrefix) && Objects.equals(this.nGrams, nGram.nGrams) && Objects.equals(this.start, nGram.start) && Objects.equals(this.length, nGram.length) && Objects.equals(this.custom, nGram.custom);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.featurePrefix, this.start, this.length, this.custom, this.nGrams);
    }

    public static Builder builder(String field) {
        return new Builder(field);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FIELD);
        PARSER.declareIntArray(ConstructingObjectParser.constructorArg(), NGRAMS);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), START);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), LENGTH);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), CUSTOM);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), FEATURE_PREFIX);
    }

    public static class Builder {
        private String field;
        private String featurePrefix;
        private List<Integer> nGrams;
        private Integer start;
        private Integer length;
        private Boolean custom;

        public Builder(String field) {
            this.field = field;
        }

        public Builder setField(String field) {
            this.field = field;
            return this;
        }

        public Builder setCustom(boolean custom) {
            this.custom = custom;
            return this;
        }

        public Builder setFeaturePrefix(String featurePrefix) {
            this.featurePrefix = featurePrefix;
            return this;
        }

        public Builder setnGrams(List<Integer> nGrams) {
            this.nGrams = nGrams;
            return this;
        }

        public Builder setStart(Integer start) {
            this.start = start;
            return this;
        }

        public Builder setLength(Integer length) {
            this.length = length;
            return this;
        }

        public Builder setCustom(Boolean custom) {
            this.custom = custom;
            return this;
        }

        public NGram build() {
            return new NGram(this.field, this.nGrams, this.start, this.length, this.custom, this.featurePrefix);
        }
    }
}

