/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.inference.trainedmodel.langident;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.ml.inference.trainedmodel.TrainedModel;
import org.elasticsearch.client.ml.inference.trainedmodel.langident.LangNetLayer;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class LangIdentNeuralNetwork
implements TrainedModel {
    public static final String NAME = "lang_ident_neural_network";
    public static final ParseField EMBEDDED_VECTOR_FEATURE_NAME = new ParseField("embedded_vector_feature_name", new String[0]);
    public static final ParseField HIDDEN_LAYER = new ParseField("hidden_layer", new String[0]);
    public static final ParseField SOFTMAX_LAYER = new ParseField("softmax_layer", new String[0]);
    public static final ConstructingObjectParser<LangIdentNeuralNetwork, Void> PARSER = new ConstructingObjectParser("lang_ident_neural_network", true, a -> new LangIdentNeuralNetwork((String)a[0], (LangNetLayer)a[1], (LangNetLayer)a[2]));
    private final LangNetLayer hiddenLayer;
    private final LangNetLayer softmaxLayer;
    private final String embeddedVectorFeatureName;

    public static LangIdentNeuralNetwork fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    LangIdentNeuralNetwork(String embeddedVectorFeatureName, LangNetLayer hiddenLayer, LangNetLayer softmaxLayer) {
        this.embeddedVectorFeatureName = embeddedVectorFeatureName;
        this.hiddenLayer = hiddenLayer;
        this.softmaxLayer = softmaxLayer;
    }

    @Override
    public List<String> getFeatureNames() {
        return Collections.singletonList(this.embeddedVectorFeatureName);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(EMBEDDED_VECTOR_FEATURE_NAME.getPreferredName(), this.embeddedVectorFeatureName);
        builder.field(HIDDEN_LAYER.getPreferredName(), this.hiddenLayer);
        builder.field(SOFTMAX_LAYER.getPreferredName(), this.softmaxLayer);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LangIdentNeuralNetwork that = (LangIdentNeuralNetwork)o;
        return Objects.equals(this.embeddedVectorFeatureName, that.embeddedVectorFeatureName) && Objects.equals(this.hiddenLayer, that.hiddenLayer) && Objects.equals(this.softmaxLayer, that.softmaxLayer);
    }

    public int hashCode() {
        return Objects.hash(this.embeddedVectorFeatureName, this.hiddenLayer, this.softmaxLayer);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), EMBEDDED_VECTOR_FEATURE_NAME);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), LangNetLayer.PARSER::apply, HIDDEN_LAYER);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), LangNetLayer.PARSER::apply, SOFTMAX_LAYER);
    }
}

