/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.rollup;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.client.core.IndexerJobStats;
import org.elasticsearch.client.core.IndexerState;
import org.elasticsearch.client.rollup.job.config.RollupJobConfig;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public class GetRollupJobResponse {
    static final ParseField JOBS = new ParseField("jobs", new String[0]);
    static final ParseField CONFIG = new ParseField("config", new String[0]);
    static final ParseField STATS = new ParseField("stats", new String[0]);
    static final ParseField STATUS = new ParseField("status", new String[0]);
    static final ParseField STATE = new ParseField("job_state", new String[0]);
    static final ParseField CURRENT_POSITION = new ParseField("current_position", new String[0]);
    static final ParseField ROLLUPS_INDEXED = new ParseField("rollups_indexed", new String[0]);
    static final ParseField UPGRADED_DOC_ID = new ParseField("upgraded_doc_id", new String[0]);
    private List<JobWrapper> jobs;
    private static final ConstructingObjectParser<GetRollupJobResponse, Void> PARSER = new ConstructingObjectParser("get_rollup_job_response", true, args -> {
        List jobs = (List)args[0];
        return new GetRollupJobResponse(Collections.unmodifiableList(jobs));
    });

    GetRollupJobResponse(List<JobWrapper> jobs) {
        this.jobs = Objects.requireNonNull(jobs, "jobs is required");
    }

    public List<JobWrapper> getJobs() {
        return this.jobs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetRollupJobResponse that = (GetRollupJobResponse)o;
        return this.jobs.equals(that.jobs);
    }

    public int hashCode() {
        return Objects.hash(this.jobs);
    }

    public static GetRollupJobResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public final String toString() {
        return "{jobs=" + this.jobs.stream().map(Object::toString).collect(Collectors.joining("\n")) + "\n}";
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), JobWrapper.PARSER::apply, JOBS);
    }

    public static class JobWrapper {
        private final RollupJobConfig job;
        private final RollupIndexerJobStats stats;
        private final RollupJobStatus status;
        private static final ConstructingObjectParser<JobWrapper, Void> PARSER = new ConstructingObjectParser("job", true, a -> new JobWrapper((RollupJobConfig)a[0], (RollupIndexerJobStats)a[1], (RollupJobStatus)a[2]));

        JobWrapper(RollupJobConfig job, RollupIndexerJobStats stats, RollupJobStatus status) {
            this.job = job;
            this.stats = stats;
            this.status = status;
        }

        public RollupJobConfig getJob() {
            return this.job;
        }

        public RollupIndexerJobStats getStats() {
            return this.stats;
        }

        public RollupJobStatus getStatus() {
            return this.status;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JobWrapper other = (JobWrapper)obj;
            return Objects.equals(this.job, other.job) && Objects.equals(this.stats, other.stats) && Objects.equals(this.status, other.status);
        }

        public int hashCode() {
            return Objects.hash(this.job, this.stats, this.status);
        }

        public final String toString() {
            return "{job=" + this.job + ", stats=" + this.stats + ", status=" + this.status + "}";
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> RollupJobConfig.fromXContent(p, null), CONFIG);
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), RollupIndexerJobStats.PARSER::apply, STATS);
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), RollupJobStatus.PARSER::apply, STATUS);
        }
    }

    public static class RollupJobStatus {
        private final IndexerState state;
        private final Map<String, Object> currentPosition;
        private final boolean upgradedDocumentId;
        private static final ConstructingObjectParser<RollupJobStatus, Void> PARSER = new ConstructingObjectParser(STATUS.getPreferredName(), true, args -> {
            IndexerState state = (IndexerState)((Object)((Object)args[0]));
            Map currentPosition = (Map)args[1];
            Boolean upgradedDocumentId = (Boolean)args[2];
            return new RollupJobStatus(state, currentPosition, upgradedDocumentId == null ? false : upgradedDocumentId);
        });

        RollupJobStatus(IndexerState state, Map<String, Object> position, boolean upgradedDocumentId) {
            this.state = state;
            this.currentPosition = position;
            this.upgradedDocumentId = upgradedDocumentId;
        }

        public IndexerState getState() {
            return this.state;
        }

        public Map<String, Object> getCurrentPosition() {
            return this.currentPosition;
        }

        public boolean getUpgradedDocumentId() {
            return this.upgradedDocumentId;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            RollupJobStatus that = (RollupJobStatus)other;
            return Objects.equals((Object)this.state, (Object)that.state) && Objects.equals(this.currentPosition, that.currentPosition) && this.upgradedDocumentId == that.upgradedDocumentId;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.state, this.currentPosition, this.upgradedDocumentId});
        }

        public final String toString() {
            return "{stats=" + (Object)((Object)this.state) + ", currentPosition=" + this.currentPosition + ", upgradedDocumentId=" + this.upgradedDocumentId + "}";
        }

        static {
            PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> IndexerState.fromString(p.text()), STATE, ObjectParser.ValueType.STRING);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> {
                if (p.currentToken() == XContentParser.Token.START_OBJECT) {
                    return p.map();
                }
                if (p.currentToken() == XContentParser.Token.VALUE_NULL) {
                    return null;
                }
                throw new IllegalArgumentException("Unsupported token [" + (Object)((Object)p.currentToken()) + "]");
            }, CURRENT_POSITION, ObjectParser.ValueType.VALUE_OBJECT_ARRAY);
            PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), UPGRADED_DOC_ID);
        }
    }

    public static class RollupIndexerJobStats
    extends IndexerJobStats {
        private static final ConstructingObjectParser<RollupIndexerJobStats, Void> PARSER = new ConstructingObjectParser(STATS.getPreferredName(), true, args -> new RollupIndexerJobStats((Long)args[0], (Long)args[1], (Long)args[2], (Long)args[3], (Long)args[4], (Long)args[5], (Long)args[6], (Long)args[7], (Long)args[8], (Long)args[9], (Long)args[10], (Long)args[11]));

        RollupIndexerJobStats(long numPages, long numInputDocuments, long numOuputDocuments, long numInvocations, long indexTime, long indexTotal, long searchTime, long searchTotal, long processingTime, long processingTotal, long indexFailures, long searchFailures) {
            super(numPages, numInputDocuments, numOuputDocuments, numInvocations, indexTime, searchTime, processingTime, indexTotal, searchTotal, processingTotal, indexFailures, searchFailures);
        }

        static {
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUM_PAGES);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUM_INPUT_DOCUMENTS);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), ROLLUPS_INDEXED);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUM_INVOCATIONS);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), INDEX_TIME_IN_MS);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), INDEX_TOTAL);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), SEARCH_TIME_IN_MS);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), SEARCH_TOTAL);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), PROCESSING_TIME_IN_MS);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), PROCESSING_TOTAL);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), INDEX_FAILURES);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), SEARCH_FAILURES);
        }
    }
}

