/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import com.carrotsearch.hppc.ObjectHashSet;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.cluster.DiskUsage;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.StoreStats;

public class ClusterInfo
implements ToXContentFragment,
Writeable {
    private final ImmutableOpenMap<String, DiskUsage> leastAvailableSpaceUsage;
    private final ImmutableOpenMap<String, DiskUsage> mostAvailableSpaceUsage;
    final ImmutableOpenMap<String, Long> shardSizes;
    public static final ClusterInfo EMPTY = new ClusterInfo();
    final ImmutableOpenMap<ShardRouting, String> routingToDataPath;
    final ImmutableOpenMap<NodeAndPath, ReservedSpace> reservedSpace;

    protected ClusterInfo() {
        this(ImmutableOpenMap.of(), ImmutableOpenMap.of(), ImmutableOpenMap.of(), ImmutableOpenMap.of(), ImmutableOpenMap.of());
    }

    public ClusterInfo(ImmutableOpenMap<String, DiskUsage> leastAvailableSpaceUsage, ImmutableOpenMap<String, DiskUsage> mostAvailableSpaceUsage, ImmutableOpenMap<String, Long> shardSizes, ImmutableOpenMap<ShardRouting, String> routingToDataPath, ImmutableOpenMap<NodeAndPath, ReservedSpace> reservedSpace) {
        this.leastAvailableSpaceUsage = leastAvailableSpaceUsage;
        this.shardSizes = shardSizes;
        this.mostAvailableSpaceUsage = mostAvailableSpaceUsage;
        this.routingToDataPath = routingToDataPath;
        this.reservedSpace = reservedSpace;
    }

    public ClusterInfo(StreamInput in) throws IOException {
        Map<String, DiskUsage> leastMap = in.readMap(StreamInput::readString, DiskUsage::new);
        Map<String, DiskUsage> mostMap = in.readMap(StreamInput::readString, DiskUsage::new);
        Map<String, Long> sizeMap = in.readMap(StreamInput::readString, StreamInput::readLong);
        Map<ShardRouting, String> routingMap = in.readMap(ShardRouting::new, StreamInput::readString);
        Map<Object, Object> reservedSpaceMap = in.getVersion().onOrAfter(StoreStats.RESERVED_BYTES_VERSION) ? in.readMap(NodeAndPath::new, ReservedSpace::new) : org.elasticsearch.common.collect.Map.of();
        ImmutableOpenMap.Builder<String, DiskUsage> leastBuilder = ImmutableOpenMap.builder();
        this.leastAvailableSpaceUsage = leastBuilder.putAll(leastMap).build();
        ImmutableOpenMap.Builder<String, DiskUsage> mostBuilder = ImmutableOpenMap.builder();
        this.mostAvailableSpaceUsage = mostBuilder.putAll(mostMap).build();
        ImmutableOpenMap.Builder<String, Long> sizeBuilder = ImmutableOpenMap.builder();
        this.shardSizes = sizeBuilder.putAll(sizeMap).build();
        ImmutableOpenMap.Builder<ShardRouting, String> routingBuilder = ImmutableOpenMap.builder();
        this.routingToDataPath = routingBuilder.putAll(routingMap).build();
        ImmutableOpenMap.Builder reservedSpaceBuilder = ImmutableOpenMap.builder();
        this.reservedSpace = reservedSpaceBuilder.putAll(reservedSpaceMap).build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.leastAvailableSpaceUsage.size());
        for (ObjectObjectCursor<String, DiskUsage> objectObjectCursor : this.leastAvailableSpaceUsage) {
            out.writeString((String)objectObjectCursor.key);
            ((DiskUsage)objectObjectCursor.value).writeTo(out);
        }
        out.writeMap(this.mostAvailableSpaceUsage, StreamOutput::writeString, (o, v) -> v.writeTo(o));
        out.writeMap(this.shardSizes, StreamOutput::writeString, (o, v) -> out.writeLong(v == null ? -1L : v));
        out.writeMap(this.routingToDataPath, (o, k) -> k.writeTo(o), StreamOutput::writeString);
        if (out.getVersion().onOrAfter(StoreStats.RESERVED_BYTES_VERSION)) {
            out.writeMap(this.reservedSpace);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("nodes");
        for (ObjectObjectCursor<String, DiskUsage> objectObjectCursor : this.leastAvailableSpaceUsage) {
            builder.startObject((String)objectObjectCursor.key);
            builder.field("node_name", ((DiskUsage)objectObjectCursor.value).getNodeName());
            builder.startObject("least_available");
            ((DiskUsage)objectObjectCursor.value).toShortXContent(builder);
            builder.endObject();
            builder.startObject("most_available");
            DiskUsage most = this.mostAvailableSpaceUsage.get((String)objectObjectCursor.key);
            if (most != null) {
                most.toShortXContent(builder);
            }
            builder.endObject();
            builder.endObject();
        }
        builder.endObject();
        builder.startObject("shard_sizes");
        for (ObjectObjectCursor<String, Object> objectObjectCursor : this.shardSizes) {
            builder.humanReadableField((String)objectObjectCursor.key + "_bytes", (String)objectObjectCursor.key, new ByteSizeValue((Long)objectObjectCursor.value));
        }
        builder.endObject();
        builder.startObject("shard_paths");
        for (ObjectObjectCursor<Object, Object> objectObjectCursor : this.routingToDataPath) {
            builder.field(((ShardRouting)objectObjectCursor.key).toString(), (String)objectObjectCursor.value);
        }
        builder.endObject();
        builder.startArray("reserved_sizes");
        for (ObjectObjectCursor<Object, Object> objectObjectCursor : this.reservedSpace) {
            builder.startObject();
            builder.field("node_id", ((NodeAndPath)objectObjectCursor.key).nodeId);
            builder.field("path", ((NodeAndPath)objectObjectCursor.key).path);
            ((ReservedSpace)objectObjectCursor.value).toXContent(builder, params);
            builder.endObject();
        }
        builder.endArray();
        return builder;
    }

    public ImmutableOpenMap<String, DiskUsage> getNodeLeastAvailableDiskUsages() {
        return this.leastAvailableSpaceUsage;
    }

    public ImmutableOpenMap<String, DiskUsage> getNodeMostAvailableDiskUsages() {
        return this.mostAvailableSpaceUsage;
    }

    public Long getShardSize(ShardRouting shardRouting) {
        return this.shardSizes.get(ClusterInfo.shardIdentifierFromRouting(shardRouting));
    }

    public String getDataPath(ShardRouting shardRouting) {
        return this.routingToDataPath.get(shardRouting);
    }

    public long getShardSize(ShardRouting shardRouting, long defaultValue) {
        Long shardSize = this.getShardSize(shardRouting);
        return shardSize == null ? defaultValue : shardSize;
    }

    public ReservedSpace getReservedSpace(String nodeId, String dataPath) {
        ReservedSpace result = this.reservedSpace.get(new NodeAndPath(nodeId, dataPath));
        return result == null ? ReservedSpace.EMPTY : result;
    }

    static String shardIdentifierFromRouting(ShardRouting shardRouting) {
        return shardRouting.shardId().toString() + "[" + (shardRouting.primary() ? "p" : "r") + "]";
    }

    public static class NodeAndPath
    implements Writeable {
        public final String nodeId;
        public final String path;

        public NodeAndPath(String nodeId, String path) {
            this.nodeId = Objects.requireNonNull(nodeId);
            this.path = Objects.requireNonNull(path);
        }

        public NodeAndPath(StreamInput in) throws IOException {
            this.nodeId = in.readString();
            this.path = in.readString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeAndPath that = (NodeAndPath)o;
            return this.nodeId.equals(that.nodeId) && this.path.equals(that.path);
        }

        public int hashCode() {
            return Objects.hash(this.nodeId, this.path);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.nodeId);
            out.writeString(this.path);
        }
    }

    public static class ReservedSpace
    implements Writeable {
        public static final ReservedSpace EMPTY = new ReservedSpace(0L, new ObjectHashSet<ShardId>());
        private final long total;
        private final ObjectHashSet<ShardId> shardIds;

        private ReservedSpace(long total, ObjectHashSet<ShardId> shardIds) {
            this.total = total;
            this.shardIds = shardIds;
        }

        ReservedSpace(StreamInput in) throws IOException {
            this.total = in.readVLong();
            int shardIdCount = in.readVInt();
            this.shardIds = new ObjectHashSet(shardIdCount);
            for (int i = 0; i < shardIdCount; ++i) {
                this.shardIds.add(new ShardId(in));
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.total);
            out.writeVInt(this.shardIds.size());
            for (ObjectCursor<ShardId> objectCursor : this.shardIds) {
                ((ShardId)objectCursor.value).writeTo(out);
            }
        }

        public long getTotal() {
            return this.total;
        }

        public boolean containsShardId(ShardId shardId) {
            return this.shardIds.contains(shardId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReservedSpace that = (ReservedSpace)o;
            return this.total == that.total && this.shardIds.equals(that.shardIds);
        }

        public int hashCode() {
            return Objects.hash(this.total, this.shardIds);
        }

        void toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("total", this.total);
            builder.startArray("shards");
            for (ObjectCursor<ShardId> objectCursor : this.shardIds) {
                ((ShardId)objectCursor.value).toXContent(builder, params);
            }
            builder.endArray();
        }

        public static class Builder {
            private long total;
            private ObjectHashSet<ShardId> shardIds = new ObjectHashSet();

            public ReservedSpace build() {
                assert (this.shardIds != null) : "already built";
                ReservedSpace reservedSpace = new ReservedSpace(this.total, this.shardIds);
                this.shardIds = null;
                return reservedSpace;
            }

            public Builder add(ShardId shardId, long reservedBytes) {
                assert (this.shardIds != null) : "already built";
                assert (reservedBytes >= 0L) : reservedBytes;
                this.shardIds.add(shardId);
                this.total += reservedBytes;
                return this;
            }
        }
    }
}

