/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.node;

import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectHashSet;
import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.set.Sets;

public class DiscoveryNodes
extends AbstractDiffable<DiscoveryNodes>
implements Iterable<DiscoveryNode> {
    public static final DiscoveryNodes EMPTY_NODES = DiscoveryNodes.builder().build();
    private final ImmutableOpenMap<String, DiscoveryNode> nodes;
    private final ImmutableOpenMap<String, DiscoveryNode> dataNodes;
    private final ImmutableOpenMap<String, DiscoveryNode> masterNodes;
    private final ImmutableOpenMap<String, DiscoveryNode> ingestNodes;
    private final String masterNodeId;
    private final String localNodeId;
    private final Version minNonClientNodeVersion;
    private final Version maxNonClientNodeVersion;
    private final Version maxNodeVersion;
    private final Version minNodeVersion;

    private DiscoveryNodes(ImmutableOpenMap<String, DiscoveryNode> nodes, ImmutableOpenMap<String, DiscoveryNode> dataNodes, ImmutableOpenMap<String, DiscoveryNode> masterNodes, ImmutableOpenMap<String, DiscoveryNode> ingestNodes, String masterNodeId, String localNodeId, Version minNonClientNodeVersion, Version maxNonClientNodeVersion, Version maxNodeVersion, Version minNodeVersion) {
        this.nodes = nodes;
        this.dataNodes = dataNodes;
        this.masterNodes = masterNodes;
        this.ingestNodes = ingestNodes;
        this.masterNodeId = masterNodeId;
        this.localNodeId = localNodeId;
        this.minNonClientNodeVersion = minNonClientNodeVersion;
        this.maxNonClientNodeVersion = maxNonClientNodeVersion;
        this.minNodeVersion = minNodeVersion;
        this.maxNodeVersion = maxNodeVersion;
    }

    @Override
    public Iterator<DiscoveryNode> iterator() {
        return this.nodes.valuesIt();
    }

    public boolean isLocalNodeElectedMaster() {
        if (this.localNodeId == null) {
            return false;
        }
        return this.localNodeId.equals(this.masterNodeId);
    }

    public int getSize() {
        return this.nodes.size();
    }

    public ImmutableOpenMap<String, DiscoveryNode> getNodes() {
        return this.nodes;
    }

    public ImmutableOpenMap<String, DiscoveryNode> getDataNodes() {
        return this.dataNodes;
    }

    public ImmutableOpenMap<String, DiscoveryNode> getMasterNodes() {
        return this.masterNodes;
    }

    public ImmutableOpenMap<String, DiscoveryNode> getIngestNodes() {
        return this.ingestNodes;
    }

    public ImmutableOpenMap<String, DiscoveryNode> getMasterAndDataNodes() {
        ImmutableOpenMap.Builder<String, DiscoveryNode> nodes = ImmutableOpenMap.builder(this.dataNodes);
        nodes.putAll(this.masterNodes);
        return nodes.build();
    }

    public ImmutableOpenMap<String, DiscoveryNode> getCoordinatingOnlyNodes() {
        ImmutableOpenMap.Builder<String, DiscoveryNode> nodes = ImmutableOpenMap.builder(this.nodes);
        nodes.removeAll(this.masterNodes.keys());
        nodes.removeAll(this.dataNodes.keys());
        nodes.removeAll(this.ingestNodes.keys());
        return nodes.build();
    }

    public Stream<DiscoveryNode> mastersFirstStream() {
        return Stream.concat(StreamSupport.stream(this.masterNodes.spliterator(), false).map(cur -> (DiscoveryNode)cur.value), StreamSupport.stream(this.spliterator(), false).filter(n -> !n.isMasterNode()));
    }

    public DiscoveryNode get(String nodeId) {
        return this.nodes.get(nodeId);
    }

    public boolean nodeExists(String nodeId) {
        return this.nodes.containsKey(nodeId);
    }

    public boolean nodeExists(DiscoveryNode node) {
        DiscoveryNode existing = this.nodes.get(node.getId());
        return existing != null && existing.equals(node);
    }

    public boolean nodeExistsWithSameRoles(DiscoveryNode discoveryNode) {
        DiscoveryNode existing = this.nodes.get(discoveryNode.getId());
        return existing != null && existing.equals(discoveryNode) && existing.getRoles().equals(discoveryNode.getRoles());
    }

    public String getMasterNodeId() {
        return this.masterNodeId;
    }

    public String getLocalNodeId() {
        return this.localNodeId;
    }

    public DiscoveryNode getLocalNode() {
        return this.nodes.get(this.localNodeId);
    }

    @Nullable
    public DiscoveryNode getMasterNode() {
        if (this.masterNodeId != null) {
            return this.nodes.get(this.masterNodeId);
        }
        return null;
    }

    public DiscoveryNode findByAddress(TransportAddress address) {
        for (ObjectCursor<DiscoveryNode> objectCursor : this.nodes.values()) {
            DiscoveryNode node = (DiscoveryNode)objectCursor.value;
            if (!node.getAddress().equals(address)) continue;
            return node;
        }
        return null;
    }

    public Version getSmallestNonClientNodeVersion() {
        return this.minNonClientNodeVersion;
    }

    public Version getLargestNonClientNodeVersion() {
        return this.maxNonClientNodeVersion;
    }

    public Version getMinNodeVersion() {
        return this.minNodeVersion;
    }

    public Version getMaxNodeVersion() {
        return this.maxNodeVersion;
    }

    public DiscoveryNode resolveNode(String node) {
        String[] resolvedNodeIds = this.resolveNodes(node);
        if (resolvedNodeIds.length > 1) {
            throw new IllegalArgumentException("resolved [" + node + "] into [" + resolvedNodeIds.length + "] nodes, where expected to be resolved to a single node");
        }
        if (resolvedNodeIds.length == 0) {
            throw new IllegalArgumentException("failed to resolve [" + node + "], no matching nodes");
        }
        return this.nodes.get(resolvedNodeIds[0]);
    }

    public String[] resolveNodes(String ... nodes) {
        if (nodes == null || nodes.length == 0) {
            return (String[])StreamSupport.stream(this.spliterator(), false).map(DiscoveryNode::getId).toArray(String[]::new);
        }
        ObjectHashSet<String> resolvedNodesIds = new ObjectHashSet<String>(nodes.length);
        for (String nodeId : nodes) {
            if (nodeId == null) {
                assert (nodeId != null) : "nodeId should not be null";
                continue;
            }
            if (nodeId.equals("_local")) {
                String localNodeId = this.getLocalNodeId();
                if (localNodeId == null) continue;
                resolvedNodesIds.add(localNodeId);
                continue;
            }
            if (nodeId.equals("_master")) {
                String masterNodeId = this.getMasterNodeId();
                if (masterNodeId == null) continue;
                resolvedNodesIds.add(masterNodeId);
                continue;
            }
            if (this.nodeExists(nodeId)) {
                resolvedNodesIds.add(nodeId);
                continue;
            }
            for (DiscoveryNode node : this) {
                if (!"_all".equals(nodeId) && !Regex.simpleMatch(nodeId, node.getName()) && !Regex.simpleMatch(nodeId, node.getHostAddress()) && !Regex.simpleMatch(nodeId, node.getHostName())) continue;
                resolvedNodesIds.add(node.getId());
            }
            int index = nodeId.indexOf(58);
            if (index == -1) continue;
            String matchAttrName = nodeId.substring(0, index);
            String matchAttrValue = nodeId.substring(index + 1);
            if (DiscoveryNodeRole.DATA_ROLE.roleName().equals(matchAttrName)) {
                if (Booleans.parseBoolean(matchAttrValue, true)) {
                    resolvedNodesIds.addAll((ObjectContainer<String>)this.dataNodes.keys());
                    continue;
                }
                resolvedNodesIds.removeAll((ObjectLookupContainer)this.dataNodes.keys());
                continue;
            }
            if (DiscoveryNodeRole.MASTER_ROLE.roleName().equals(matchAttrName)) {
                if (Booleans.parseBoolean(matchAttrValue, true)) {
                    resolvedNodesIds.addAll((ObjectContainer<String>)this.masterNodes.keys());
                    continue;
                }
                resolvedNodesIds.removeAll((ObjectLookupContainer)this.masterNodes.keys());
                continue;
            }
            if (DiscoveryNodeRole.INGEST_ROLE.roleName().equals(matchAttrName)) {
                if (Booleans.parseBoolean(matchAttrValue, true)) {
                    resolvedNodesIds.addAll((ObjectContainer<String>)this.ingestNodes.keys());
                    continue;
                }
                resolvedNodesIds.removeAll((ObjectLookupContainer)this.ingestNodes.keys());
                continue;
            }
            if ("coordinating_only".equals(matchAttrName)) {
                if (Booleans.parseBoolean(matchAttrValue, true)) {
                    resolvedNodesIds.addAll((ObjectContainer<String>)this.getCoordinatingOnlyNodes().keys());
                    continue;
                }
                resolvedNodesIds.removeAll((ObjectLookupContainer)this.getCoordinatingOnlyNodes().keys());
                continue;
            }
            for (DiscoveryNode node : this) {
                for (DiscoveryNodeRole discoveryNodeRole : Sets.difference(node.getRoles(), DiscoveryNodeRole.BUILT_IN_ROLES)) {
                    if (!discoveryNodeRole.roleName().equals(matchAttrName)) continue;
                    if (Booleans.parseBoolean(matchAttrValue, true)) {
                        resolvedNodesIds.add(node.getId());
                        continue;
                    }
                    resolvedNodesIds.remove(node.getId());
                }
            }
            for (DiscoveryNode node : this) {
                for (Map.Entry entry : node.getAttributes().entrySet()) {
                    String attrName = (String)entry.getKey();
                    String attrValue = (String)entry.getValue();
                    if (!Regex.simpleMatch(matchAttrName, attrName) || !Regex.simpleMatch(matchAttrValue, attrValue)) continue;
                    resolvedNodesIds.add(node.getId());
                }
            }
        }
        return (String[])resolvedNodesIds.toArray(String.class);
    }

    public DiscoveryNodes newNode(DiscoveryNode node) {
        return new Builder(this).add(node).build();
    }

    public Delta delta(DiscoveryNodes other) {
        ArrayList<DiscoveryNode> removed = new ArrayList<DiscoveryNode>();
        ArrayList<DiscoveryNode> added = new ArrayList<DiscoveryNode>();
        for (DiscoveryNode node : other) {
            if (this.nodeExists(node)) continue;
            removed.add(node);
        }
        for (DiscoveryNode node : this) {
            if (other.nodeExists(node)) continue;
            added.add(node);
        }
        return new Delta(other.getMasterNode(), this.getMasterNode(), this.localNodeId, Collections.unmodifiableList(removed), Collections.unmodifiableList(added));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("nodes: \n");
        for (DiscoveryNode node : this) {
            sb.append("   ").append(node);
            if (node == this.getLocalNode()) {
                sb.append(", local");
            }
            if (node == this.getMasterNode()) {
                sb.append(", master");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.masterNodeId == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeString(this.masterNodeId);
        }
        out.writeVInt(this.nodes.size());
        for (DiscoveryNode node : this) {
            node.writeTo(out);
        }
    }

    public static DiscoveryNodes readFrom(StreamInput in, DiscoveryNode localNode) throws IOException {
        Builder builder = new Builder();
        if (in.readBoolean()) {
            builder.masterNodeId(in.readString());
        }
        if (localNode != null) {
            builder.localNodeId(localNode.getId());
        }
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            DiscoveryNode node = new DiscoveryNode(in);
            if (localNode != null && node.getId().equals(localNode.getId())) {
                node = localNode;
            }
            assert (builder.validateAdd(node) == null) : "building disco nodes from network doesn't pass preflight: " + Builder.access$100(builder, node);
            builder.putUnsafe(node);
        }
        return builder.build();
    }

    public static Diff<DiscoveryNodes> readDiffFrom(StreamInput in, DiscoveryNode localNode) throws IOException {
        return AbstractDiffable.readDiffFrom((StreamInput in1) -> DiscoveryNodes.readFrom(in1, localNode), in);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DiscoveryNodes nodes) {
        return new Builder(nodes);
    }

    public static class Builder {
        private final ImmutableOpenMap.Builder<String, DiscoveryNode> nodes;
        private String masterNodeId;
        private String localNodeId;

        public Builder() {
            this.nodes = ImmutableOpenMap.builder();
        }

        public Builder(DiscoveryNodes nodes) {
            this.masterNodeId = nodes.getMasterNodeId();
            this.localNodeId = nodes.getLocalNodeId();
            this.nodes = ImmutableOpenMap.builder(nodes.getNodes());
        }

        public Builder add(DiscoveryNode node) {
            String preflight = this.validateAdd(node);
            if (preflight != null) {
                throw new IllegalArgumentException(preflight);
            }
            this.putUnsafe(node);
            return this;
        }

        @Nullable
        public DiscoveryNode get(String nodeId) {
            return this.nodes.get(nodeId);
        }

        private void putUnsafe(DiscoveryNode node) {
            this.nodes.put(node.getId(), node);
        }

        public Builder remove(String nodeId) {
            this.nodes.remove(nodeId);
            return this;
        }

        public Builder remove(DiscoveryNode node) {
            if (node.equals(this.nodes.get(node.getId()))) {
                this.nodes.remove(node.getId());
            }
            return this;
        }

        public Builder masterNodeId(String masterNodeId) {
            this.masterNodeId = masterNodeId;
            return this;
        }

        public Builder localNodeId(String localNodeId) {
            this.localNodeId = localNodeId;
            return this;
        }

        private String validateAdd(DiscoveryNode node) {
            for (ObjectCursor<DiscoveryNode> objectCursor : this.nodes.values()) {
                DiscoveryNode existingNode = (DiscoveryNode)objectCursor.value;
                if (node.getAddress().equals(existingNode.getAddress()) && !node.getId().equals(existingNode.getId())) {
                    return "can't add node " + node + ", found existing node " + existingNode + " with same address";
                }
                if (!node.getId().equals(existingNode.getId()) || node.equals(existingNode)) continue;
                return "can't add node " + node + ", found existing node " + existingNode + " with the same id but is a different node instance";
            }
            return null;
        }

        public DiscoveryNodes build() {
            ImmutableOpenMap.Builder<String, DiscoveryNode> dataNodesBuilder = ImmutableOpenMap.builder();
            ImmutableOpenMap.Builder<String, DiscoveryNode> masterNodesBuilder = ImmutableOpenMap.builder();
            ImmutableOpenMap.Builder<String, DiscoveryNode> ingestNodesBuilder = ImmutableOpenMap.builder();
            Version minNodeVersion = null;
            Version maxNodeVersion = null;
            Version minNonClientNodeVersion = null;
            Version maxNonClientNodeVersion = null;
            for (ObjectObjectCursor<String, DiscoveryNode> objectObjectCursor : this.nodes) {
                if (((DiscoveryNode)objectObjectCursor.value).isDataNode()) {
                    dataNodesBuilder.put((String)objectObjectCursor.key, (DiscoveryNode)objectObjectCursor.value);
                }
                if (((DiscoveryNode)objectObjectCursor.value).isMasterNode()) {
                    masterNodesBuilder.put((String)objectObjectCursor.key, (DiscoveryNode)objectObjectCursor.value);
                }
                Version version = ((DiscoveryNode)objectObjectCursor.value).getVersion();
                if (((DiscoveryNode)objectObjectCursor.value).isDataNode() || ((DiscoveryNode)objectObjectCursor.value).isMasterNode()) {
                    if (minNonClientNodeVersion == null) {
                        minNonClientNodeVersion = version;
                        maxNonClientNodeVersion = version;
                    } else {
                        minNonClientNodeVersion = Version.min(minNonClientNodeVersion, version);
                        maxNonClientNodeVersion = Version.max(maxNonClientNodeVersion, version);
                    }
                }
                if (((DiscoveryNode)objectObjectCursor.value).isIngestNode()) {
                    ingestNodesBuilder.put((String)objectObjectCursor.key, (DiscoveryNode)objectObjectCursor.value);
                }
                minNodeVersion = minNodeVersion == null ? version : Version.min(minNodeVersion, version);
                maxNodeVersion = maxNodeVersion == null ? version : Version.max(maxNodeVersion, version);
            }
            return new DiscoveryNodes(this.nodes.build(), dataNodesBuilder.build(), masterNodesBuilder.build(), ingestNodesBuilder.build(), this.masterNodeId, this.localNodeId, minNonClientNodeVersion == null ? Version.CURRENT : minNonClientNodeVersion, maxNonClientNodeVersion == null ? Version.CURRENT : maxNonClientNodeVersion, maxNodeVersion == null ? Version.CURRENT : maxNodeVersion, minNodeVersion == null ? Version.CURRENT : minNodeVersion);
        }

        public boolean isLocalNodeElectedMaster() {
            return this.masterNodeId != null && this.masterNodeId.equals(this.localNodeId);
        }
    }

    public static class Delta {
        private final String localNodeId;
        @Nullable
        private final DiscoveryNode previousMasterNode;
        @Nullable
        private final DiscoveryNode newMasterNode;
        private final List<DiscoveryNode> removed;
        private final List<DiscoveryNode> added;

        private Delta(@Nullable DiscoveryNode previousMasterNode, @Nullable DiscoveryNode newMasterNode, String localNodeId, List<DiscoveryNode> removed, List<DiscoveryNode> added) {
            this.previousMasterNode = previousMasterNode;
            this.newMasterNode = newMasterNode;
            this.localNodeId = localNodeId;
            this.removed = removed;
            this.added = added;
        }

        public boolean hasChanges() {
            return this.masterNodeChanged() || !this.removed.isEmpty() || !this.added.isEmpty();
        }

        public boolean masterNodeChanged() {
            return !Objects.equals(this.newMasterNode, this.previousMasterNode);
        }

        @Nullable
        public DiscoveryNode previousMasterNode() {
            return this.previousMasterNode;
        }

        @Nullable
        public DiscoveryNode newMasterNode() {
            return this.newMasterNode;
        }

        public boolean removed() {
            return !this.removed.isEmpty();
        }

        public List<DiscoveryNode> removedNodes() {
            return this.removed;
        }

        public boolean added() {
            return !this.added.isEmpty();
        }

        public List<DiscoveryNode> addedNodes() {
            return this.added;
        }

        public String shortSummary() {
            String addedNodesExceptLocalNode;
            StringBuilder summary = new StringBuilder();
            if (this.masterNodeChanged()) {
                summary.append("master node changed {previous [");
                if (this.previousMasterNode() != null) {
                    summary.append(this.previousMasterNode());
                }
                summary.append("], current [");
                if (this.newMasterNode() != null) {
                    summary.append(this.newMasterNode());
                }
                summary.append("]}");
            }
            if (this.removed()) {
                if (summary.length() > 0) {
                    summary.append(", ");
                }
                summary.append("removed {").append(Strings.collectionToCommaDelimitedString(this.removedNodes())).append('}');
            }
            if (this.added() && (addedNodesExceptLocalNode = this.addedNodes().stream().filter(node -> !node.getId().equals(this.localNodeId)).map(DiscoveryNode::toString).collect(Collectors.joining(","))).length() > 0) {
                if (summary.length() > 0) {
                    summary.append(", ");
                }
                summary.append("added {").append(addedNodesExceptLocalNode).append('}');
            }
            return summary.toString();
        }
    }
}

