/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParametrizedFieldMapper;
import org.elasticsearch.index.mapper.RankFeatureFieldMapper;
import org.elasticsearch.index.mapper.RankFeatureMetaFieldMapper;
import org.elasticsearch.index.mapper.RankFeaturesFieldMapper;
import org.elasticsearch.index.mapper.ScaledFloatFieldMapper;
import org.elasticsearch.index.mapper.SearchAsYouTypeFieldMapper;
import org.elasticsearch.index.mapper.TokenCountFieldMapper;
import org.elasticsearch.index.query.RankFeatureQueryBuilder;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SearchPlugin;

public class MapperExtrasPlugin
extends Plugin
implements MapperPlugin,
SearchPlugin {
    @Override
    public Map<String, Mapper.TypeParser> getMappers() {
        LinkedHashMap<String, ParametrizedFieldMapper.TypeParser> mappers = new LinkedHashMap<String, ParametrizedFieldMapper.TypeParser>();
        mappers.put("scaled_float", ScaledFloatFieldMapper.PARSER);
        mappers.put("token_count", TokenCountFieldMapper.PARSER);
        mappers.put("rank_feature", RankFeatureFieldMapper.PARSER);
        mappers.put("rank_features", RankFeaturesFieldMapper.PARSER);
        mappers.put("search_as_you_type", SearchAsYouTypeFieldMapper.PARSER);
        return Collections.unmodifiableMap(mappers);
    }

    @Override
    public Map<String, MetadataFieldMapper.TypeParser> getMetadataMappers() {
        return Collections.singletonMap("_feature", RankFeatureMetaFieldMapper.PARSER);
    }

    @Override
    public List<SearchPlugin.QuerySpec<?>> getQueries() {
        return Collections.singletonList(new SearchPlugin.QuerySpec<RankFeatureQueryBuilder>("rank_feature", RankFeatureQueryBuilder::new, p -> RankFeatureQueryBuilder.PARSER.parse(p, null)));
    }
}

