/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collections;
import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableFieldType;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParametrizedFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.search.lookup.SearchLookup;

public class RoutingFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_routing";
    public static final String CONTENT_TYPE = "_routing";
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.ConfigurableTypeParser(c -> new RoutingFieldMapper(false), c -> new Builder());
    private final boolean required;

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder().init(this);
    }

    private static RoutingFieldMapper toType(FieldMapper in) {
        return (RoutingFieldMapper)in;
    }

    private RoutingFieldMapper(boolean required) {
        super(RoutingFieldType.INSTANCE);
        this.required = required;
    }

    public boolean required() {
        return this.required;
    }

    @Override
    public void preParse(ParseContext context) {
        String routing = context.sourceToParse().routing();
        if (routing != null) {
            context.doc().add(new Field(this.fieldType().name(), routing, (IndexableFieldType)Defaults.FIELD_TYPE));
            this.createFieldNamesField(context);
        }
    }

    @Override
    protected String contentType() {
        return "_routing";
    }

    public static class Builder
    extends MetadataFieldMapper.Builder {
        final ParametrizedFieldMapper.Parameter<Boolean> required = ParametrizedFieldMapper.Parameter.boolParam("required", false, m -> RoutingFieldMapper.access$200(RoutingFieldMapper.toType(m)), false);

        protected Builder() {
            super("_routing");
        }

        @Override
        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Collections.singletonList(this.required);
        }

        @Override
        public RoutingFieldMapper build(Mapper.BuilderContext context) {
            return new RoutingFieldMapper(this.required.getValue());
        }
    }

    static final class RoutingFieldType
    extends StringFieldType {
        static RoutingFieldType INSTANCE = new RoutingFieldType();

        private RoutingFieldType() {
            super("_routing", true, true, false, TextSearchInfo.SIMPLE_MATCH_ONLY, Collections.emptyMap());
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
        }

        @Override
        public String typeName() {
            return "_routing";
        }

        @Override
        public ValueFetcher valueFetcher(MapperService mapperService, SearchLookup lookup, String format) {
            throw new UnsupportedOperationException("Cannot fetch values for internal field [" + this.name() + "].");
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();
        public static final boolean REQUIRED = false;

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }
}

