/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.LatLonShape;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.Version;
import org.elasticsearch.common.geo.GeoLineDecomposer;
import org.elasticsearch.common.geo.GeoPolygonDecomposer;
import org.elasticsearch.common.geo.GeoShapeUtils;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.geometry.GeometryVisitor;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiLine;
import org.elasticsearch.geometry.MultiPoint;
import org.elasticsearch.geometry.MultiPolygon;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Polygon;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;

public class VectorGeoShapeQueryProcessor {
    public Query geoShapeQuery(Geometry shape, String fieldName, ShapeRelation relation, QueryShardContext context) {
        if (relation == ShapeRelation.CONTAINS && context.indexVersionCreated().before(Version.V_7_5_0)) {
            throw new QueryShardException(context, ShapeRelation.CONTAINS + " query relation not supported for Field [" + fieldName + "].", new Object[0]);
        }
        return this.getVectorQueryFromShape(shape, fieldName, relation, context);
    }

    private Query getVectorQueryFromShape(Geometry queryShape, String fieldName, ShapeRelation relation, QueryShardContext context) {
        LuceneGeometryCollector visitor = new LuceneGeometryCollector(fieldName, context);
        queryShape.visit(visitor);
        List<LatLonGeometry> geometries = visitor.geometries();
        if (geometries.size() == 0) {
            return new MatchNoDocsQuery();
        }
        return LatLonShape.newGeometryQuery(fieldName, relation.getLuceneRelation(), geometries.toArray(new LatLonGeometry[geometries.size()]));
    }

    private static class LuceneGeometryCollector
    implements GeometryVisitor<Void, RuntimeException> {
        private final List<LatLonGeometry> geometries = new ArrayList<LatLonGeometry>();
        private final String name;
        private final QueryShardContext context;

        private LuceneGeometryCollector(String name, QueryShardContext context) {
            this.name = name;
            this.context = context;
        }

        List<LatLonGeometry> geometries() {
            return this.geometries;
        }

        @Override
        public Void visit(Circle circle) {
            if (!circle.isEmpty()) {
                this.geometries.add(GeoShapeUtils.toLuceneCircle(circle));
            }
            return null;
        }

        @Override
        public Void visit(GeometryCollection<?> collection) {
            for (Geometry shape : collection) {
                shape.visit(this);
            }
            return null;
        }

        @Override
        public Void visit(Line line) {
            if (!line.isEmpty()) {
                ArrayList<Line> collector = new ArrayList<Line>();
                GeoLineDecomposer.decomposeLine(line, collector);
                this.collectLines(collector);
            }
            return null;
        }

        @Override
        public Void visit(LinearRing ring) {
            throw new QueryShardException(this.context, "Field [" + this.name + "] found and unsupported shape LinearRing", new Object[0]);
        }

        @Override
        public Void visit(MultiLine multiLine) {
            ArrayList<Line> collector = new ArrayList<Line>();
            GeoLineDecomposer.decomposeMultiLine(multiLine, collector);
            this.collectLines(collector);
            return null;
        }

        @Override
        public Void visit(MultiPoint multiPoint) {
            for (Point point : multiPoint) {
                this.visit(point);
            }
            return null;
        }

        @Override
        public Void visit(MultiPolygon multiPolygon) {
            if (!multiPolygon.isEmpty()) {
                ArrayList<Polygon> collector = new ArrayList<Polygon>();
                GeoPolygonDecomposer.decomposeMultiPolygon(multiPolygon, true, collector);
                this.collectPolygons(collector);
            }
            return null;
        }

        @Override
        public Void visit(Point point) {
            if (!point.isEmpty()) {
                this.geometries.add(GeoShapeUtils.toLucenePoint(point));
            }
            return null;
        }

        @Override
        public Void visit(Polygon polygon) {
            if (!polygon.isEmpty()) {
                ArrayList<Polygon> collector = new ArrayList<Polygon>();
                GeoPolygonDecomposer.decomposePolygon(polygon, true, collector);
                this.collectPolygons(collector);
            }
            return null;
        }

        @Override
        public Void visit(Rectangle r) {
            if (!r.isEmpty()) {
                this.geometries.add(GeoShapeUtils.toLuceneRectangle(r));
            }
            return null;
        }

        private void collectLines(List<Line> geometryLines) {
            for (Line line : geometryLines) {
                this.geometries.add(GeoShapeUtils.toLuceneLine(line));
            }
        }

        private void collectPolygons(List<Polygon> geometryPolygons) {
            for (Polygon polygon : geometryPolygons) {
                this.geometries.add(GeoShapeUtils.toLucenePolygon(polygon));
            }
        }
    }
}

