/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.IndexMetaDataGenerations;
import org.elasticsearch.repositories.ShardGenerations;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotState;
import org.elasticsearch.snapshots.SnapshotsService;

public final class RepositoryData {
    public static final long EMPTY_REPO_GEN = -1L;
    public static final long UNKNOWN_REPO_GEN = -2L;
    public static final long CORRUPTED_REPO_GEN = -3L;
    public static final RepositoryData EMPTY = new RepositoryData(-1L, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), ShardGenerations.EMPTY, IndexMetaDataGenerations.EMPTY);
    private final long genId;
    private final Map<String, SnapshotId> snapshotIds;
    private final Map<String, SnapshotState> snapshotStates;
    private final Map<String, IndexId> indices;
    private final Map<IndexId, List<SnapshotId>> indexSnapshots;
    private final Map<String, Version> snapshotVersions;
    private final IndexMetaDataGenerations indexMetaDataGenerations;
    private final ShardGenerations shardGenerations;
    private static final String SHARD_GENERATIONS = "shard_generations";
    private static final String INDEX_METADATA_IDENTIFIERS = "index_metadata_identifiers";
    private static final String INDEX_METADATA_LOOKUP = "index_metadata_lookup";
    private static final String SNAPSHOTS = "snapshots";
    private static final String INDICES = "indices";
    private static final String INDEX_ID = "id";
    private static final String NAME = "name";
    private static final String UUID = "uuid";
    private static final String STATE = "state";
    private static final String VERSION = "version";
    private static final String MIN_VERSION = "min_version";

    public RepositoryData(long genId, Map<String, SnapshotId> snapshotIds, Map<String, SnapshotState> snapshotStates, Map<String, Version> snapshotVersions, Map<IndexId, List<SnapshotId>> indexSnapshots, ShardGenerations shardGenerations, IndexMetaDataGenerations indexMetaDataGenerations) {
        this(genId, Collections.unmodifiableMap(snapshotIds), Collections.unmodifiableMap(snapshotStates), Collections.unmodifiableMap(snapshotVersions), Collections.unmodifiableMap(indexSnapshots.keySet().stream().collect(Collectors.toMap(IndexId::getName, Function.identity()))), Collections.unmodifiableMap(indexSnapshots), shardGenerations, indexMetaDataGenerations);
    }

    private RepositoryData(long genId, Map<String, SnapshotId> snapshotIds, Map<String, SnapshotState> snapshotStates, Map<String, Version> snapshotVersions, Map<String, IndexId> indices, Map<IndexId, List<SnapshotId>> indexSnapshots, ShardGenerations shardGenerations, IndexMetaDataGenerations indexMetaDataGenerations) {
        this.genId = genId;
        this.snapshotIds = snapshotIds;
        this.snapshotStates = snapshotStates;
        this.indices = indices;
        this.indexSnapshots = indexSnapshots;
        this.shardGenerations = shardGenerations;
        this.indexMetaDataGenerations = indexMetaDataGenerations;
        this.snapshotVersions = snapshotVersions;
        assert (indices.values().containsAll(shardGenerations.indices())) : "ShardGenerations contained indices " + shardGenerations.indices() + " but snapshots only reference indices " + indices.values();
        assert (indexSnapshots.values().stream().noneMatch(snapshotIdList -> new HashSet(snapshotIdList).size() != snapshotIdList.size())) : "Found duplicate snapshot ids per index in [" + indexSnapshots + "]";
    }

    protected RepositoryData copy() {
        return new RepositoryData(this.genId, this.snapshotIds, this.snapshotStates, this.snapshotVersions, this.indexSnapshots, this.shardGenerations, this.indexMetaDataGenerations);
    }

    public RepositoryData withVersions(Map<SnapshotId, Version> versions) {
        if (versions.isEmpty()) {
            return this;
        }
        HashMap<String, Version> newVersions = new HashMap<String, Version>(this.snapshotVersions);
        versions.forEach((id, version) -> newVersions.put(id.getUUID(), (Version)version));
        return new RepositoryData(this.genId, this.snapshotIds, this.snapshotStates, newVersions, this.indexSnapshots, this.shardGenerations, this.indexMetaDataGenerations);
    }

    public ShardGenerations shardGenerations() {
        return this.shardGenerations;
    }

    public long getGenId() {
        return this.genId;
    }

    public Collection<SnapshotId> getSnapshotIds() {
        return this.snapshotIds.values();
    }

    @Nullable
    public SnapshotState getSnapshotState(SnapshotId snapshotId) {
        return this.snapshotStates.get(snapshotId.getUUID());
    }

    @Nullable
    public Version getVersion(SnapshotId snapshotId) {
        return this.snapshotVersions.get(snapshotId.getUUID());
    }

    public Map<String, IndexId> getIndices() {
        return this.indices;
    }

    public List<IndexId> indicesToUpdateAfterRemovingSnapshot(Collection<SnapshotId> snapshotIds) {
        return this.indexSnapshots.entrySet().stream().filter(entry -> {
            Collection existingIds = (Collection)entry.getValue();
            if (snapshotIds.containsAll(existingIds)) {
                return existingIds.size() > snapshotIds.size();
            }
            for (SnapshotId snapshotId : snapshotIds) {
                if (!((List)entry.getValue()).contains(snapshotId)) continue;
                return true;
            }
            return false;
        }).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public Map<IndexId, Collection<String>> indexMetaDataToRemoveAfterRemovingSnapshots(Collection<SnapshotId> snapshotIds) {
        List<IndexId> indicesForSnapshot = this.indicesToUpdateAfterRemovingSnapshot(snapshotIds);
        Set allRemainingIdentifiers = this.indexMetaDataGenerations.lookup.entrySet().stream().filter(e -> !snapshotIds.contains(e.getKey())).flatMap(e -> ((Map)e.getValue()).values().stream()).map(this.indexMetaDataGenerations::getIndexMetaBlobId).collect(Collectors.toSet());
        HashMap<IndexId, Collection<String>> toRemove = new HashMap<IndexId, Collection<String>>();
        for (IndexId indexId : indicesForSnapshot) {
            for (SnapshotId snapshotId : snapshotIds) {
                String identifier = this.indexMetaDataGenerations.indexMetaBlobId(snapshotId, indexId);
                if (allRemainingIdentifiers.contains(identifier)) continue;
                toRemove.computeIfAbsent(indexId, k -> new HashSet()).add(identifier);
            }
        }
        return toRemove;
    }

    public RepositoryData addSnapshot(SnapshotId snapshotId, SnapshotState snapshotState, Version version, ShardGenerations shardGenerations, @Nullable Map<IndexId, String> indexMetaBlobs, @Nullable Map<String, String> newIdentifiers) {
        IndexMetaDataGenerations newIndexMetaGenerations;
        if (this.snapshotIds.containsKey(snapshotId.getUUID())) {
            return this;
        }
        HashMap<String, SnapshotId> snapshots = new HashMap<String, SnapshotId>(this.snapshotIds);
        snapshots.put(snapshotId.getUUID(), snapshotId);
        HashMap<String, SnapshotState> newSnapshotStates = new HashMap<String, SnapshotState>(this.snapshotStates);
        newSnapshotStates.put(snapshotId.getUUID(), snapshotState);
        HashMap<String, Version> newSnapshotVersions = new HashMap<String, Version>(this.snapshotVersions);
        newSnapshotVersions.put(snapshotId.getUUID(), version);
        HashMap<IndexId, List<SnapshotId>> allIndexSnapshots = new HashMap<IndexId, List<SnapshotId>>(this.indexSnapshots);
        for (IndexId indexId : shardGenerations.indices()) {
            List snapshotIds = (List)allIndexSnapshots.get(indexId);
            if (snapshotIds == null) {
                allIndexSnapshots.put(indexId, Collections.singletonList(snapshotId));
                continue;
            }
            ArrayList<SnapshotId> copy = new ArrayList<SnapshotId>(snapshotIds.size() + 1);
            copy.addAll(snapshotIds);
            copy.add(snapshotId);
            allIndexSnapshots.put(indexId, Collections.unmodifiableList(copy));
        }
        if (indexMetaBlobs == null) {
            assert (newIdentifiers == null) : "Non-null new identifiers [" + newIdentifiers + "] for null lookup";
            assert (this.indexMetaDataGenerations.lookup.isEmpty()) : "Index meta generations should have been empty but was [" + this.indexMetaDataGenerations + "]";
            newIndexMetaGenerations = IndexMetaDataGenerations.EMPTY;
        } else {
            assert (indexMetaBlobs.isEmpty() || shardGenerations.indices().equals(indexMetaBlobs.keySet())) : "Shard generations contained indices " + shardGenerations.indices() + " but indexMetaData was given for " + indexMetaBlobs.keySet();
            newIndexMetaGenerations = this.indexMetaDataGenerations.withAddedSnapshot(snapshotId, indexMetaBlobs, newIdentifiers);
        }
        return new RepositoryData(this.genId, snapshots, newSnapshotStates, newSnapshotVersions, allIndexSnapshots, ShardGenerations.builder().putAll(this.shardGenerations).putAll(shardGenerations).build(), newIndexMetaGenerations);
    }

    public RepositoryData withGenId(long newGeneration) {
        if (newGeneration == this.genId) {
            return this;
        }
        return new RepositoryData(newGeneration, this.snapshotIds, this.snapshotStates, this.snapshotVersions, this.indices, this.indexSnapshots, this.shardGenerations, this.indexMetaDataGenerations);
    }

    public RepositoryData removeSnapshots(Collection<SnapshotId> snapshots, ShardGenerations updatedShardGenerations) {
        Map<String, SnapshotId> newSnapshotIds = this.snapshotIds.values().stream().filter(sn -> !snapshots.contains(sn)).collect(Collectors.toMap(SnapshotId::getUUID, Function.identity()));
        if (newSnapshotIds.size() != this.snapshotIds.size() - snapshots.size()) {
            HashSet<SnapshotId> notFound = new HashSet<SnapshotId>(snapshots);
            notFound.removeAll(this.snapshotIds.values());
            throw new ResourceNotFoundException("Attempting to remove non-existent snapshots {} from repository data", notFound);
        }
        HashMap<String, SnapshotState> newSnapshotStates = new HashMap<String, SnapshotState>(this.snapshotStates);
        HashMap<String, Version> newSnapshotVersions = new HashMap<String, Version>(this.snapshotVersions);
        for (SnapshotId snapshotId : snapshots) {
            newSnapshotStates.remove(snapshotId.getUUID());
            newSnapshotVersions.remove(snapshotId.getUUID());
        }
        HashMap<IndexId, List<SnapshotId>> indexSnapshots = new HashMap<IndexId, List<SnapshotId>>();
        for (IndexId indexId : this.indices.values()) {
            List<SnapshotId> snapshotIds = this.indexSnapshots.get(indexId);
            assert (snapshotIds != null);
            List<SnapshotId> remaining = new ArrayList<SnapshotId>(snapshotIds);
            remaining = remaining.removeAll(snapshots) ? Collections.unmodifiableList(remaining) : snapshotIds;
            if (remaining.isEmpty()) continue;
            indexSnapshots.put(indexId, remaining);
        }
        return new RepositoryData(this.genId, newSnapshotIds, newSnapshotStates, newSnapshotVersions, indexSnapshots, ShardGenerations.builder().putAll(this.shardGenerations).putAll(updatedShardGenerations).retainIndicesAndPruneDeletes(indexSnapshots.keySet()).build(), this.indexMetaDataGenerations.withRemovedSnapshots(snapshots));
    }

    public List<SnapshotId> getSnapshots(IndexId indexId) {
        List<SnapshotId> snapshotIds = this.indexSnapshots.get(indexId);
        if (snapshotIds == null) {
            throw new IllegalArgumentException("unknown snapshot index " + indexId);
        }
        return snapshotIds;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RepositoryData that = (RepositoryData)obj;
        return this.snapshotIds.equals(that.snapshotIds) && this.snapshotStates.equals(that.snapshotStates) && this.snapshotVersions.equals(that.snapshotVersions) && this.indices.equals(that.indices) && this.indexSnapshots.equals(that.indexSnapshots) && this.shardGenerations.equals(that.shardGenerations) && this.indexMetaDataGenerations.equals(that.indexMetaDataGenerations);
    }

    public int hashCode() {
        return Objects.hash(this.snapshotIds, this.snapshotStates, this.snapshotVersions, this.indices, this.indexSnapshots, this.shardGenerations, this.indexMetaDataGenerations);
    }

    public IndexId resolveIndexId(String indexName) {
        return Objects.requireNonNull(this.indices.get(indexName), () -> "Tried to resolve unknown index [" + indexName + "]");
    }

    public List<IndexId> resolveIndices(List<String> indices) {
        ArrayList<IndexId> resolvedIndices = new ArrayList<IndexId>(indices.size());
        for (String indexName : indices) {
            resolvedIndices.add(this.resolveIndexId(indexName));
        }
        return resolvedIndices;
    }

    public List<IndexId> resolveNewIndices(List<String> indicesToResolve, Map<String, IndexId> inFlightIds) {
        ArrayList<IndexId> snapshotIndices = new ArrayList<IndexId>();
        for (String index : indicesToResolve) {
            IndexId indexId = this.indices.get(index);
            if (indexId == null) {
                indexId = inFlightIds.get(index);
            }
            if (indexId == null) {
                indexId = new IndexId(index, UUIDs.randomBase64UUID());
            }
            snapshotIndices.add(indexId);
        }
        return snapshotIndices;
    }

    public XContentBuilder snapshotsToXContent(XContentBuilder builder, Version repoMetaVersion) throws IOException {
        builder.startObject();
        builder.startArray(SNAPSHOTS);
        boolean shouldWriteIndexGens = SnapshotsService.useIndexGenerations(repoMetaVersion);
        boolean shouldWriteShardGens = SnapshotsService.useShardGenerations(repoMetaVersion);
        for (SnapshotId snapshot : this.getSnapshotIds()) {
            Version version;
            builder.startObject();
            builder.field(NAME, snapshot.getName());
            String snapshotUUID = snapshot.getUUID();
            builder.field(UUID, snapshotUUID);
            SnapshotState state = this.snapshotStates.get(snapshotUUID);
            if (state != null) {
                builder.field(STATE, state.value());
            }
            if (shouldWriteIndexGens) {
                builder.startObject(INDEX_METADATA_LOOKUP);
                for (Map.Entry entry : this.indexMetaDataGenerations.lookup.getOrDefault(snapshot, Collections.emptyMap()).entrySet()) {
                    builder.field(((IndexId)entry.getKey()).getId(), (String)entry.getValue());
                }
                builder.endObject();
            }
            if ((version = this.snapshotVersions.get(snapshotUUID)) != null) {
                builder.field(VERSION, version.toString());
            }
            builder.endObject();
        }
        builder.endArray();
        builder.startObject(INDICES);
        for (IndexId indexId : this.getIndices().values()) {
            builder.startObject(indexId.getName());
            builder.field(INDEX_ID, indexId.getId());
            builder.startArray(SNAPSHOTS);
            List<SnapshotId> snapshotIds = this.indexSnapshots.get(indexId);
            assert (snapshotIds != null);
            for (SnapshotId snapshotId : snapshotIds) {
                builder.value(snapshotId.getUUID());
            }
            builder.endArray();
            if (shouldWriteShardGens) {
                builder.startArray(SHARD_GENERATIONS);
                for (String gen : this.shardGenerations.getGens(indexId)) {
                    builder.value(gen);
                }
                builder.endArray();
            }
            builder.endObject();
        }
        builder.endObject();
        if (shouldWriteIndexGens) {
            builder.field(MIN_VERSION, SnapshotsService.INDEX_GEN_IN_REPO_DATA_VERSION.toString());
            builder.field(INDEX_METADATA_IDENTIFIERS, this.indexMetaDataGenerations.identifiers);
        } else if (shouldWriteShardGens) {
            builder.field(MIN_VERSION, SnapshotsService.SHARD_GEN_IN_REPO_DATA_VERSION.toString());
        }
        builder.endObject();
        return builder;
    }

    public IndexMetaDataGenerations indexMetaDataGenerations() {
        return this.indexMetaDataGenerations;
    }

    public static RepositoryData snapshotsFromXContent(XContentParser parser, long genId, boolean fixBrokenShardGens) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
        HashMap<String, SnapshotId> snapshots = new HashMap<String, SnapshotId>();
        HashMap<String, SnapshotState> snapshotStates = new HashMap<String, SnapshotState>();
        HashMap<String, Version> snapshotVersions = new HashMap<String, Version>();
        HashMap<IndexId, List<SnapshotId>> indexSnapshots = new HashMap<IndexId, List<SnapshotId>>();
        HashMap<String, IndexId> indexLookup = new HashMap<String, IndexId>();
        ShardGenerations.Builder shardGenerations = ShardGenerations.builder();
        HashMap<SnapshotId, Map<String, String>> indexMetaLookup = new HashMap<SnapshotId, Map<String, String>>();
        Map<String, String> indexMetaIdentifiers = null;
        block12: while (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
            String field;
            switch (field = parser.currentName()) {
                case "snapshots": {
                    RepositoryData.parseSnapshots(parser, snapshots, snapshotStates, snapshotVersions, indexMetaLookup);
                    continue block12;
                }
                case "indices": {
                    RepositoryData.parseIndices(parser, fixBrokenShardGens, snapshots, indexSnapshots, indexLookup, shardGenerations);
                    continue block12;
                }
                case "index_metadata_identifiers": {
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
                    indexMetaIdentifiers = parser.mapStrings();
                    continue block12;
                }
                case "min_version": {
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_STRING, parser.nextToken(), parser);
                    Version version = Version.fromString(parser.text());
                    assert (SnapshotsService.useShardGenerations(version));
                    continue block12;
                }
            }
            XContentParserUtils.throwUnknownField(field, parser.getTokenLocation());
        }
        return new RepositoryData(genId, snapshots, snapshotStates, snapshotVersions, indexSnapshots, shardGenerations.build(), RepositoryData.buildIndexMetaGenerations(indexMetaLookup, indexLookup, indexMetaIdentifiers));
    }

    private static IndexMetaDataGenerations buildIndexMetaGenerations(Map<SnapshotId, Map<String, String>> indexMetaLookup, Map<String, IndexId> indexLookup, Map<String, String> indexMetaIdentifiers) {
        if (indexMetaLookup.isEmpty()) {
            return IndexMetaDataGenerations.EMPTY;
        }
        HashMap<SnapshotId, Map<IndexId, String>> indexGenerations = new HashMap<SnapshotId, Map<IndexId, String>>(indexMetaLookup.size());
        for (Map.Entry<SnapshotId, Map<String, String>> snapshotIdMapEntry : indexMetaLookup.entrySet()) {
            Map<String, String> val = snapshotIdMapEntry.getValue();
            HashMap<IndexId, String> forSnapshot = new HashMap<IndexId, String>(val.size());
            for (Map.Entry<String, String> generationEntry : val.entrySet()) {
                forSnapshot.put(indexLookup.get(generationEntry.getKey()), generationEntry.getValue());
            }
            indexGenerations.put(snapshotIdMapEntry.getKey(), forSnapshot);
        }
        return new IndexMetaDataGenerations(indexGenerations, indexMetaIdentifiers);
    }

    private static void parseSnapshots(XContentParser parser, Map<String, SnapshotId> snapshots, Map<String, SnapshotState> snapshotStates, Map<String, Version> snapshotVersions, Map<SnapshotId, Map<String, String>> indexMetaLookup) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, parser.nextToken(), parser);
        HashMap stringDeduplicator = new HashMap();
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            String name = null;
            String uuid = null;
            SnapshotState state = null;
            Map<String, String> metaGenerations = null;
            Version version = null;
            while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                String currentFieldName = parser.currentName();
                parser.nextToken();
                switch (currentFieldName) {
                    case "name": {
                        name = parser.text();
                        break;
                    }
                    case "uuid": {
                        uuid = parser.text();
                        break;
                    }
                    case "state": {
                        state = SnapshotState.fromValue((byte)parser.intValue());
                        break;
                    }
                    case "index_metadata_lookup": {
                        metaGenerations = parser.map(HashMap::new, p -> (String)stringDeduplicator.computeIfAbsent(p.text(), Function.identity()));
                        break;
                    }
                    case "version": {
                        version = Version.fromString(parser.text());
                    }
                }
            }
            SnapshotId snapshotId = new SnapshotId(name, uuid);
            if (state != null) {
                snapshotStates.put(uuid, state);
            }
            if (version != null) {
                snapshotVersions.put(uuid, version);
            }
            snapshots.put(uuid, snapshotId);
            if (metaGenerations == null || metaGenerations.isEmpty()) continue;
            indexMetaLookup.put(snapshotId, metaGenerations);
        }
    }

    private static void parseIndices(XContentParser parser, boolean fixBrokenShardGens, Map<String, SnapshotId> snapshots, Map<IndexId, List<SnapshotId>> indexSnapshots, Map<String, IndexId> indexLookup, ShardGenerations.Builder shardGenerations) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String indexName = parser.currentName();
            ArrayList<SnapshotId> snapshotIds = new ArrayList<SnapshotId>();
            ArrayList<String> gens = new ArrayList<String>();
            IndexId indexId = null;
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
            while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                String indexMetaFieldName = parser.currentName();
                XContentParser.Token currentToken = parser.nextToken();
                switch (indexMetaFieldName) {
                    case "id": {
                        indexId = new IndexId(indexName, parser.text());
                        break;
                    }
                    case "snapshots": {
                        XContentParser.Token currToken;
                        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, currentToken, parser);
                        while ((currToken = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            String uuid = currToken == XContentParser.Token.START_OBJECT ? RepositoryData.parseLegacySnapshotUUID(parser) : parser.text();
                            SnapshotId snapshotId = snapshots.get(uuid);
                            if (snapshotId == null) {
                                throw new ElasticsearchParseException("Detected a corrupted repository, index " + indexId + " references an unknown snapshot uuid [" + uuid + "]", new Object[0]);
                            }
                            snapshotIds.add(snapshotId);
                        }
                        break;
                    }
                    case "shard_generations": {
                        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, currentToken, parser);
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            gens.add(parser.textOrNull());
                        }
                        break;
                    }
                }
            }
            assert (indexId != null);
            indexSnapshots.put(indexId, Collections.unmodifiableList(snapshotIds));
            indexLookup.put(indexId.getId(), indexId);
            for (int i = 0; i < gens.size(); ++i) {
                String parsedGen = (String)gens.get(i);
                if (fixBrokenShardGens) {
                    parsedGen = ShardGenerations.fixShardGeneration(parsedGen);
                }
                if (parsedGen == null) continue;
                shardGenerations.put(indexId, i, parsedGen);
            }
        }
    }

    private static String parseLegacySnapshotUUID(XContentParser parser) throws IOException {
        String uuid = null;
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String currentFieldName = parser.currentName();
            parser.nextToken();
            if (!UUID.equals(currentFieldName)) continue;
            uuid = parser.text();
        }
        return uuid;
    }
}

