/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationFactory;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeKey;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceConfig;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceParserHelper;
import org.elasticsearch.search.aggregations.bucket.composite.DateHistogramValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.GeoTileGridValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.HistogramValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.nested.NestedAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;

public class CompositeAggregationBuilder
extends AbstractAggregationBuilder<CompositeAggregationBuilder> {
    public static final String NAME = "composite";
    public static final ParseField AFTER_FIELD_NAME = new ParseField("after", new String[0]);
    public static final ParseField SIZE_FIELD_NAME = new ParseField("size", new String[0]);
    public static final ParseField SOURCES_FIELD_NAME = new ParseField("sources", new String[0]);
    public static final ConstructingObjectParser<CompositeAggregationBuilder, String> PARSER = new ConstructingObjectParser<CompositeAggregationBuilder, String>("composite", false, (args, name) -> {
        List sources = (List)args[0];
        return new CompositeAggregationBuilder((String)name, sources);
    });
    private List<CompositeValuesSourceBuilder<?>> sources;
    private Map<String, Object> after;
    private int size = 10;

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        DateHistogramValuesSourceBuilder.register(builder);
        HistogramValuesSourceBuilder.register(builder);
        GeoTileGridValuesSourceBuilder.register(builder);
        TermsValuesSourceBuilder.register(builder);
        builder.registerUsage(NAME);
    }

    public CompositeAggregationBuilder(String name, List<CompositeValuesSourceBuilder<?>> sources) {
        super(name);
        CompositeAggregationBuilder.validateSources(sources);
        this.sources = sources;
    }

    protected CompositeAggregationBuilder(CompositeAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
        this.sources = new ArrayList(clone.sources);
        this.after = clone.after;
        this.size = clone.size;
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new CompositeAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public CompositeAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        int num = in.readVInt();
        this.sources = new ArrayList(num);
        for (int i = 0; i < num; ++i) {
            CompositeValuesSourceBuilder<?> builder = CompositeValuesSourceParserHelper.readFrom(in);
            this.sources.add(builder);
        }
        this.size = in.readVInt();
        if (in.readBoolean()) {
            this.after = in.readMap();
        }
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.sources.size());
        for (CompositeValuesSourceBuilder<?> builder : this.sources) {
            CompositeValuesSourceParserHelper.writeTo(builder, out);
        }
        out.writeVInt(this.size);
        out.writeBoolean(this.after != null);
        if (this.after != null) {
            out.writeMap(this.after);
        }
    }

    @Override
    public String getType() {
        return NAME;
    }

    public List<CompositeValuesSourceBuilder<?>> sources() {
        return this.sources;
    }

    public CompositeAggregationBuilder aggregateAfter(Map<String, Object> afterKey) {
        this.after = afterKey;
        return this;
    }

    public CompositeAggregationBuilder size(int size) {
        this.size = size;
        return this;
    }

    public int size() {
        return this.size;
    }

    @Override
    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.NONE;
    }

    private AggregatorFactory checkParentIsNullOrNested(AggregatorFactory factory) {
        if (factory == null) {
            return null;
        }
        if (factory instanceof NestedAggregatorFactory) {
            return this.checkParentIsNullOrNested(factory.getParent());
        }
        return factory;
    }

    private static void validateSources(List<CompositeValuesSourceBuilder<?>> sources) {
        if (sources == null || sources.isEmpty()) {
            throw new IllegalArgumentException("Composite [" + SOURCES_FIELD_NAME.getPreferredName() + "] cannot be null or empty");
        }
        HashSet names = new HashSet();
        HashSet duplicates = new HashSet();
        sources.forEach(source -> {
            if (source == null) {
                throw new IllegalArgumentException("Composite source cannot be null");
            }
            boolean unique = names.add(source.name());
            if (!unique) {
                duplicates.add(source.name());
            }
        });
        if (duplicates.size() > 0) {
            throw new IllegalArgumentException("Composite source names must be unique, found duplicates: " + duplicates);
        }
    }

    @Override
    protected AggregatorFactory doBuild(QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subfactoriesBuilder) throws IOException {
        CompositeKey afterKey;
        AggregatorFactory invalid = this.checkParentIsNullOrNested(parent);
        if (invalid != null) {
            throw new IllegalArgumentException("[composite] aggregation cannot be used with a parent aggregation of type: [" + invalid.getClass().getSimpleName() + "]");
        }
        CompositeValuesSourceConfig[] configs = new CompositeValuesSourceConfig[this.sources.size()];
        for (int i = 0; i < configs.length; ++i) {
            configs[i] = this.sources.get(i).build(queryShardContext);
            if (!configs[i].valuesSource().needsScores()) continue;
            throw new IllegalArgumentException("[sources] cannot access _score");
        }
        if (this.after != null) {
            if (this.after.size() != configs.length) {
                throw new IllegalArgumentException("[after] has " + this.after.size() + " value(s) but [sources] has " + this.sources.size());
            }
            Comparable[] values = new Comparable[this.sources.size()];
            for (int i = 0; i < this.sources.size(); ++i) {
                String sourceName = this.sources.get(i).name();
                if (!this.after.containsKey(sourceName)) {
                    throw new IllegalArgumentException("Missing value for [after." + this.sources.get(i).name() + "]");
                }
                Object obj = this.after.get(sourceName);
                if (configs[i].missingBucket() && obj == null) {
                    values[i] = null;
                    continue;
                }
                if (obj instanceof Comparable) {
                    values[i] = (Comparable)obj;
                    continue;
                }
                throw new IllegalArgumentException("Invalid value for [after." + this.sources.get(i).name() + "], expected comparable, got [" + (obj == null ? "null" : obj.getClass().getSimpleName()) + "]");
            }
            afterKey = new CompositeKey(values);
        } else {
            afterKey = null;
        }
        return new CompositeAggregationFactory(this.name, queryShardContext, parent, subfactoriesBuilder, this.metadata, this.size, configs, afterKey);
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(SIZE_FIELD_NAME.getPreferredName(), this.size);
        builder.startArray(SOURCES_FIELD_NAME.getPreferredName());
        for (CompositeValuesSourceBuilder<?> source : this.sources) {
            CompositeValuesSourceParserHelper.toXContent(source, builder, params);
        }
        builder.endArray();
        if (this.after != null) {
            CompositeAggregation.buildCompositeMap(AFTER_FIELD_NAME.getPreferredName(), this.after, builder);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sources, this.size, this.after);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        CompositeAggregationBuilder other = (CompositeAggregationBuilder)obj;
        return this.size == other.size && Objects.equals(this.sources, other.sources) && Objects.equals(this.after, other.after);
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> CompositeValuesSourceParserHelper.fromXContent(p), SOURCES_FIELD_NAME);
        PARSER.declareInt(CompositeAggregationBuilder::size, SIZE_FIELD_NAME);
        PARSER.declareObject(CompositeAggregationBuilder::aggregateAfter, (p, context) -> p.map(), AFTER_FIELD_NAME);
    }
}

