/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoryShardId;
import org.elasticsearch.repositories.ShardGenerations;

public final class InFlightShardSnapshotStates {
    private final Map<String, Map<Integer, String>> generations;
    private final Map<String, Set<Integer>> activeShardIds;

    public static InFlightShardSnapshotStates forRepo(String repoName, List<SnapshotsInProgress.Entry> snapshots) {
        HashMap<String, Map<Integer, String>> generations = new HashMap<String, Map<Integer, String>>();
        HashMap<String, Set<Integer>> busyIds = new HashMap<String, Set<Integer>>();
        for (SnapshotsInProgress.Entry runningSnapshot : snapshots) {
            if (!runningSnapshot.repository().equals(repoName)) continue;
            if (runningSnapshot.isClone()) {
                for (ObjectObjectCursor<Writeable, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : runningSnapshot.clones()) {
                    RepositoryShardId repoShardId = (RepositoryShardId)objectObjectCursor.key;
                    InFlightShardSnapshotStates.addStateInformation(generations, busyIds, (SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value, repoShardId.shardId(), repoShardId.indexName());
                }
                continue;
            }
            for (ObjectObjectCursor<Writeable, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : runningSnapshot.shards()) {
                ShardId sid = (ShardId)objectObjectCursor.key;
                InFlightShardSnapshotStates.addStateInformation(generations, busyIds, (SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value, sid.id(), sid.getIndexName());
            }
        }
        return new InFlightShardSnapshotStates(generations, busyIds);
    }

    private static void addStateInformation(Map<String, Map<Integer, String>> generations, Map<String, Set<Integer>> busyIds, SnapshotsInProgress.ShardSnapshotStatus shardState, int shardId, String indexName) {
        if (shardState.isActive()) {
            busyIds.computeIfAbsent(indexName, k -> new HashSet()).add(shardId);
            assert (InFlightShardSnapshotStates.assertGenerationConsistency(generations, indexName, shardId, shardState.generation()));
        } else if (shardState.state() == SnapshotsInProgress.ShardState.SUCCESS) {
            assert (!busyIds.getOrDefault(indexName, Collections.emptySet()).contains(shardId)) : "Can't have a successful operation queued after an in-progress operation";
            generations.computeIfAbsent(indexName, k -> new HashMap()).put(shardId, shardState.generation());
        }
    }

    private InFlightShardSnapshotStates(Map<String, Map<Integer, String>> generations, Map<String, Set<Integer>> activeShardIds) {
        this.generations = generations;
        this.activeShardIds = activeShardIds;
    }

    private static boolean assertGenerationConsistency(Map<String, Map<Integer, String>> generations, String indexName, int shardId, @Nullable String activeGeneration) {
        String bestGeneration = (String)generations.getOrDefault(indexName, Collections.emptyMap()).get(shardId);
        assert (bestGeneration == null || activeGeneration == null || activeGeneration.equals(bestGeneration));
        return true;
    }

    boolean isActive(String indexName, int shardId) {
        return this.activeShardIds.getOrDefault(indexName, Collections.emptySet()).contains(shardId);
    }

    @Nullable
    String generationForShard(IndexId indexId, int shardId, ShardGenerations shardGenerations) {
        String inFlightBest = (String)this.generations.getOrDefault(indexId.getName(), Collections.emptyMap()).get(shardId);
        if (inFlightBest != null) {
            return inFlightBest;
        }
        return shardGenerations.getShardGen(indexId, shardId);
    }
}

