/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.logback.internal;

import ch.qos.logback.classic.BasicConfigurator;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.LogbackServiceProvider;
import ch.qos.logback.core.joran.GenericXMLConfigurator;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.WarnStatus;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.LogManager;
import org.ops4j.pax.logging.EventAdminPoster;
import org.ops4j.pax.logging.PaxContext;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingService;
import org.ops4j.pax.logging.logback.internal.PaxLoggerImpl;
import org.ops4j.pax.logging.logback.internal.Slf4jLogbackMDCAdapter;
import org.ops4j.pax.logging.spi.support.BackendSupport;
import org.ops4j.pax.logging.spi.support.ConfigurationNotifier;
import org.ops4j.pax.logging.spi.support.LogEntryImpl;
import org.ops4j.pax.logging.spi.support.LogReaderServiceImpl;
import org.ops4j.pax.logging.spi.support.OsgiUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.FormatterLogger;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogLevel;

public class PaxLoggingServiceImpl
implements PaxLoggingService,
ServiceFactory<Object> {
    public static final String LOGGER_CONTEXT_BUNDLECONTEXT_KEY = "org.ops4j.pax.logging.logback.bundlecontext";
    private static LogbackServiceProvider logbackServiceProvider;
    private final BundleContext m_bundleContext;
    private volatile ReadWriteLock m_configLock;
    private final LogReaderServiceImpl m_logReader;
    private final PaxContext m_paxContext;
    private final EventAdminPoster m_eventAdmin;
    private final ConfigurationNotifier m_configNotifier;
    private LogLevel m_r7LogLevel = LogLevel.DEBUG;
    private final boolean m_useStaticContext;
    private final LoggerContext m_logbackContext;
    private final String m_staticConfigFile;
    private final AtomicBoolean emptyConfiguration = new AtomicBoolean(false);
    private final PaxLogger logLog;
    private final String fqcn = this.getClass().getName();
    private Dictionary<String, String> defaultConfiguration = null;

    public PaxLoggingServiceImpl(BundleContext bundleContext, LogReaderServiceImpl logReader, EventAdminPoster eventAdmin, ConfigurationNotifier configNotifier, PaxLogger logLog) {
        if (bundleContext == null) {
            throw new IllegalArgumentException("bundleContext cannot be null");
        }
        this.m_bundleContext = bundleContext;
        this.m_logReader = logReader;
        this.m_eventAdmin = eventAdmin;
        this.m_configNotifier = configNotifier;
        this.logLog = logLog;
        this.m_paxContext = new PaxContext();
        String useLocks = OsgiUtil.systemOrContextProperty(bundleContext, "org.ops4j.pax.logging.useLocks");
        if (!"false".equalsIgnoreCase(useLocks)) {
            this.m_configLock = new ReentrantReadWriteLock();
        }
        this.m_useStaticContext = Boolean.parseBoolean(bundleContext.getProperty("org.ops4j.pax.logging.StaticLogbackContext"));
        if (this.m_useStaticContext) {
            if (logbackServiceProvider == null) {
                logbackServiceProvider = new LogbackServiceProvider();
                logbackServiceProvider.initialize();
            }
            this.m_logbackContext = (LoggerContext)logbackServiceProvider.getLoggerFactory();
        } else {
            this.m_logbackContext = new LoggerContext();
            this.m_logbackContext.setMDCAdapter(new Slf4jLogbackMDCAdapter());
            this.m_logbackContext.start();
        }
        this.m_staticConfigFile = OsgiUtil.systemOrContextProperty(bundleContext, "org.ops4j.pax.logging.StaticLogbackFile");
    }

    public void shutdown() {
        this.m_logbackContext.removeObject(LOGGER_CONTEXT_BUNDLECONTEXT_KEY);
        if (!this.m_useStaticContext) {
            this.m_logbackContext.stop();
        } else {
            this.m_logbackContext.reset();
            this.m_logbackContext.getStatusManager().add(this::logLogbackStatus);
        }
    }

    void lock(boolean useWriteLock) {
        ReadWriteLock lock = this.m_configLock;
        if (lock != null) {
            if (useWriteLock) {
                lock.writeLock().lock();
            } else {
                lock.readLock().lock();
            }
        }
    }

    void unlock(boolean useWriteLock) {
        ReadWriteLock lock = this.m_configLock;
        if (lock != null) {
            if (useWriteLock) {
                lock.writeLock().unlock();
            } else {
                lock.readLock().unlock();
            }
        }
    }

    public PaxLogger getLogger(Bundle bundle, String category, String fqcn) {
        return this.getLogger(bundle, category, fqcn, false);
    }

    public LogLevel getLogLevel() {
        return this.m_r7LogLevel;
    }

    public void log(int level, String message) {
        this.logImpl(null, level, message, null, this.fqcn);
    }

    public void log(int level, String message, Throwable exception) {
        this.logImpl(null, level, message, exception, this.fqcn);
    }

    public void log(ServiceReference sr, int level, String message) {
        this.logImpl(sr == null ? null : sr.getBundle(), level, message, null, this.fqcn);
    }

    public void log(ServiceReference sr, int level, String message, Throwable exception) {
        this.logImpl(sr == null ? null : sr.getBundle(), level, message, exception, this.fqcn);
    }

    public PaxContext getPaxContext() {
        return this.m_paxContext;
    }

    public org.osgi.service.log.Logger getLogger(String name) {
        return this.getLogger(null, name, PaxLoggerImpl.FQCN);
    }

    public org.osgi.service.log.Logger getLogger(Class<?> clazz) {
        return this.getLogger(null, clazz.getName(), PaxLoggerImpl.FQCN);
    }

    public <L extends org.osgi.service.log.Logger> L getLogger(String name, Class<L> loggerType) {
        return this.getLogger(null, name, loggerType);
    }

    public <L extends org.osgi.service.log.Logger> L getLogger(Class<?> clazz, Class<L> loggerType) {
        return this.getLogger(null, clazz.getName(), loggerType);
    }

    public <L extends org.osgi.service.log.Logger> L getLogger(Bundle bundle, String name, Class<L> loggerType) {
        return this.getLogger(bundle, name, loggerType, PaxLoggerImpl.FQCN);
    }

    private <L extends org.osgi.service.log.Logger> L getLogger(Bundle bundle, String name, Class<L> loggerType, String fqcn) {
        if (loggerType == org.osgi.service.log.Logger.class) {
            return (L)((org.osgi.service.log.Logger)loggerType.cast(this.getLogger(bundle, name, fqcn, false)));
        }
        if (loggerType == FormatterLogger.class) {
            return (L)((org.osgi.service.log.Logger)loggerType.cast(this.getLogger(bundle, name, fqcn, true)));
        }
        throw new IllegalArgumentException("Can't obtain logger with type " + loggerType);
    }

    private PaxLogger getLogger(Bundle bundle, String category, String fqcn, boolean printfFormatting) {
        Logger logbackLogger = category == null ? this.m_logbackContext.getLogger("ROOT") : this.m_logbackContext.getLogger(category);
        return new PaxLoggerImpl(bundle, logbackLogger, fqcn, this, printfFormatting);
    }

    public void setDefaultConfiguration(Dictionary<String, String> config) {
        this.defaultConfiguration = config;
    }

    public void updated(Dictionary<String, ?> configuration) {
        Object useLocks;
        if (configuration == null && this.defaultConfiguration == null) {
            if (this.m_staticConfigFile == null) {
                this.configureDefaults();
            }
            return;
        }
        if (configuration == null) {
            configuration = this.defaultConfiguration;
        }
        if (!"false".equalsIgnoreCase(String.valueOf(useLocks = configuration.get("org.ops4j.pax.logging.useLocks")))) {
            if (this.m_configLock == null) {
                this.m_configLock = new ReentrantReadWriteLock();
            }
        } else {
            this.m_configLock = null;
        }
        Object configfile = configuration.get("org.ops4j.pax.logging.logback.config.file");
        if (this.m_staticConfigFile != null && (configfile == null || this.m_staticConfigFile.equals(configfile))) {
            return;
        }
        this.configureLogback(configfile instanceof String ? (String)configfile : null);
        this.configurePax(configuration);
    }

    private void logImpl(Bundle bundle, int level, String message, Throwable exception, String fqcn) {
        String category = BackendSupport.category(bundle);
        try {
            PaxLogger logger = this.getLogger(bundle, category, fqcn);
            if (exception != null) {
                if (level < 1) {
                    logger.audit(message, (Object)exception);
                } else {
                    switch (level) {
                        case 1: {
                            logger.error(message, (Object)exception);
                            break;
                        }
                        case 2: {
                            logger.warn(message, (Object)exception);
                            break;
                        }
                        case 3: {
                            logger.info(message, (Object)exception);
                            break;
                        }
                        case 4: {
                            logger.debug(message, (Object)exception);
                            break;
                        }
                        default: {
                            logger.trace(message, (Object)exception);
                            break;
                        }
                    }
                }
            } else if (level < 1) {
                logger.audit(message);
            } else {
                switch (level) {
                    case 1: {
                        logger.error(message);
                        break;
                    }
                    case 2: {
                        logger.warn(message);
                        break;
                    }
                    case 3: {
                        logger.info(message);
                        break;
                    }
                    case 4: {
                        logger.debug(message);
                        break;
                    }
                    default: {
                        logger.trace(message);
                    }
                }
            }
        }
        catch (RuntimeException e) {
            this.m_logbackContext.getStatusManager().add(new WarnStatus("Runtime logging failure", this.m_logbackContext, e));
        }
    }

    void handleEvents(String name, Bundle bundle, ServiceReference<?> sr, LogLevel level, String message, Throwable exception) {
        LogEntryImpl entry;
        LogEntryImpl logEntryImpl = entry = this.m_logReader != null || this.m_eventAdmin != null ? new LogEntryImpl(name, bundle, sr, level, message, exception) : null;
        if (this.m_logReader != null) {
            this.m_logReader.fireEvent(entry);
        }
        if (this.m_eventAdmin != null) {
            this.m_eventAdmin.postEvent(bundle, level, (LogEntry)entry, message, exception, sr, this.getPaxContext().getContext());
        }
    }

    void configureDefaults() {
        String levelName = BackendSupport.defaultLogLevel(this.m_bundleContext);
        java.util.logging.Level julLevel = BackendSupport.toJULLevel(levelName);
        this.m_r7LogLevel = BackendSupport.convertR7LogLevel(levelName, LogLevel.DEBUG);
        java.util.logging.Logger rootLogger = java.util.logging.Logger.getLogger("");
        rootLogger.setLevel(julLevel);
        this.configureLogback(this.m_staticConfigFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureLogback(String configFileName) {
        Throwable problem;
        block18: {
            this.m_logbackContext.getStatusManager().clear();
            this.lock(true);
            problem = null;
            try {
                File file = null;
                if (configFileName != null) {
                    file = new File(configFileName);
                }
                if (file != null && !file.isFile()) {
                    WarnStatus warn = new WarnStatus("Configuration file '" + file + "' is not available. Default configuration will be used.", null);
                    this.m_logbackContext.getStatusManager().add(warn);
                    file = null;
                }
                if (file == null && !this.emptyConfiguration.compareAndSet(false, true)) {
                    this.m_configNotifier.configurationDone();
                    return;
                }
                this.m_logbackContext.reset();
                this.m_logbackContext.putObject(LOGGER_CONTEXT_BUNDLECONTEXT_KEY, this.m_bundleContext);
                try {
                    ContextAwareBase configurator;
                    if (file == null) {
                        configurator = new BasicConfigurator();
                        configurator.setContext(this.m_logbackContext);
                        configurator.configure(this.m_logbackContext);
                        Level l = Level.toLevel(this.m_r7LogLevel.name(), Level.DEBUG);
                        Logger rootLogger = this.m_logbackContext.getLogger("ROOT");
                        rootLogger.setLevel(l);
                        InfoStatus info = new InfoStatus("Logback configured using default configuration.", this);
                        this.m_logbackContext.getStatusManager().add(info);
                        break block18;
                    }
                    try {
                        String hostName = InetAddress.getLocalHost().getCanonicalHostName();
                        int n = hostName.indexOf(46);
                        if (n >= 0) {
                            hostName = hostName.substring(0, n);
                        }
                        this.m_logbackContext.putProperty("HOSTNAMENONCANON", hostName.toLowerCase(Locale.ENGLISH));
                    }
                    catch (UnknownHostException hostName) {
                        // empty catch block
                    }
                    configurator = new JoranConfigurator();
                    configurator.setContext(this.m_logbackContext);
                    ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                        ((GenericXMLConfigurator)configurator).doConfigure(file);
                        this.emptyConfiguration.set(false);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(tccl);
                    }
                    InfoStatus info = new InfoStatus("Logback configured using file '" + file + "'.", this);
                    this.m_logbackContext.getStatusManager().add(info);
                }
                catch (Throwable e) {
                    ErrorStatus error = new ErrorStatus("Logback configuration problem: " + e.getMessage(), e);
                    this.m_logbackContext.getStatusManager().add(error);
                    problem = e;
                }
            }
            finally {
                this.unlock(true);
            }
        }
        this.setLevelToJavaLogging();
        if (problem == null) {
            this.m_configNotifier.configurationDone();
        } else {
            this.m_configNotifier.configurationError(problem);
        }
        this.logbackStatus();
        this.m_logbackContext.getStatusManager().clear();
        this.m_logbackContext.getStatusManager().add(this::logLogbackStatus);
    }

    private Level extractLevel(String log4jLevelConfig) {
        String[] config = log4jLevelConfig.split("\\s*,\\s*");
        return Level.toLevel(config[0]);
    }

    private void setLevelToJavaLogging() {
        Enumeration<String> enum_ = LogManager.getLogManager().getLoggerNames();
        while (enum_.hasMoreElements()) {
            String name = enum_.nextElement();
            java.util.logging.Logger.getLogger(name).setLevel(null);
        }
        for (Logger logger : this.m_logbackContext.getLoggerList()) {
            if (logger == null) continue;
            Level l = logger.getEffectiveLevel();
            java.util.logging.Level julLevel = BackendSupport.toJULLevel(l.toString());
            if ("ROOT".equals(logger.getName()) || "".equals(logger.getName())) {
                java.util.logging.Logger.getGlobal().setLevel(julLevel);
                java.util.logging.Logger.getLogger("").setLevel(julLevel);
                java.util.logging.Logger.getLogger("global").setLevel(julLevel);
                continue;
            }
            java.util.logging.Logger.getLogger(logger.getName()).setLevel(julLevel);
        }
    }

    private void configurePax(Dictionary<String, ?> config) {
        Object size = config.get("org.ops4j.pax.logging.logReaderServiceSize");
        if (size == null) {
            size = config.get("pax.logging.entries.size");
        }
        if (null != size && this.m_logReader != null) {
            try {
                this.m_logReader.setMaxEntries(Integer.parseInt((String)size));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void logbackStatus() {
        StatusManager sm = this.m_logbackContext.getStatusManager();
        if (sm != null && this.logLog.isDebugEnabled()) {
            for (Status status : sm.getCopyOfStatusList()) {
                this.logLogbackStatus(status);
            }
        }
    }

    private void logLogbackStatus(Status status) {
        Throwable t = status.getThrowable();
        if (t != null) {
            switch (status.getLevel()) {
                case 2: {
                    this.logLog.error(status.getMessage(), (Object)status.getThrowable());
                    break;
                }
                case 1: {
                    this.logLog.warn(status.getMessage(), (Object)status.getThrowable());
                    break;
                }
                case 0: {
                    this.logLog.info(status.getMessage(), (Object)status.getThrowable());
                }
            }
        } else {
            switch (status.getLevel()) {
                case 2: {
                    this.logLog.error(status.getMessage());
                    break;
                }
                case 1: {
                    this.logLog.warn(status.getMessage());
                    break;
                }
                case 0: {
                    this.logLog.info(status.getMessage());
                }
            }
        }
    }

    public Object getService(final Bundle bundle, ServiceRegistration registration) {
        class ManagedPaxLoggingService
        implements PaxLoggingService {
            private final String FQCN;

            ManagedPaxLoggingService() {
                this.FQCN = ManagedPaxLoggingService.class.getName();
            }

            public void log(int level, String message) {
                PaxLoggingServiceImpl.this.logImpl(bundle, level, message, null, this.FQCN);
            }

            public void log(int level, String message, Throwable exception) {
                PaxLoggingServiceImpl.this.logImpl(bundle, level, message, exception, this.FQCN);
            }

            public void log(ServiceReference sr, int level, String message) {
                Bundle b = bundle == null && sr != null ? sr.getBundle() : bundle;
                PaxLoggingServiceImpl.this.logImpl(b, level, message, null, this.FQCN);
            }

            public void log(ServiceReference sr, int level, String message, Throwable exception) {
                Bundle b = bundle == null && sr != null ? sr.getBundle() : bundle;
                PaxLoggingServiceImpl.this.logImpl(b, level, message, exception, this.FQCN);
            }

            public LogLevel getLogLevel() {
                return PaxLoggingServiceImpl.this.getLogLevel();
            }

            public PaxLogger getLogger(Bundle myBundle, String category, String fqcn) {
                return PaxLoggingServiceImpl.this.getLogger(myBundle, category, fqcn);
            }

            public PaxContext getPaxContext() {
                return PaxLoggingServiceImpl.this.getPaxContext();
            }

            public org.osgi.service.log.Logger getLogger(String name) {
                return PaxLoggingServiceImpl.this.getLogger(bundle, name, PaxLoggerImpl.FQCN);
            }

            public org.osgi.service.log.Logger getLogger(Class<?> clazz) {
                return PaxLoggingServiceImpl.this.getLogger(bundle, clazz.getName(), PaxLoggerImpl.FQCN);
            }

            public <L extends org.osgi.service.log.Logger> L getLogger(String name, Class<L> loggerType) {
                return (L)PaxLoggingServiceImpl.this.getLogger(bundle, name, loggerType, PaxLoggerImpl.FQCN);
            }

            public <L extends org.osgi.service.log.Logger> L getLogger(Class<?> clazz, Class<L> loggerType) {
                return (L)PaxLoggingServiceImpl.this.getLogger(bundle, clazz.getName(), loggerType, PaxLoggerImpl.FQCN);
            }

            public <L extends org.osgi.service.log.Logger> L getLogger(Bundle bundle2, String name, Class<L> loggerType) {
                return (L)PaxLoggingServiceImpl.this.getLogger(bundle2, name, loggerType, PaxLoggerImpl.FQCN);
            }
        }
        return new ManagedPaxLoggingService();
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
    }
}

