/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.analysis.datasource;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.ElasticsearchService;
import de.virtimo.bpc.module.analysis.AnalysisModule;
import de.virtimo.bpc.module.analysis.datasource.DataSource;
import de.virtimo.bpc.util.MapUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class Elasticsearch
implements DataSource {
    @Override
    public String getData(Map dataSetConfig, Map variables) throws IOException, ServiceNotFoundException {
        SearchResponse searchResponse = this.getEsData(dataSetConfig, variables);
        String searchResponseJson = searchResponse.toString();
        return searchResponseJson;
    }

    private SearchResponse getEsData(Map dataSetConfig, Map variables) throws IOException, ServiceNotFoundException {
        ElasticsearchService es = AnalysisModule.getInstance().getElasticsearchService();
        RestHighLevelClient esClient = es.getClient();
        ObjectMapper objectMapper = new ObjectMapper();
        String indexName = (String)dataSetConfig.get("indexName");
        Map query = (Map)dataSetConfig.get("query");
        Map finalQuery = MapUtil.deepCopy((Map)query);
        this.applyVariables(finalQuery, variables);
        SearchRequest searchRequest = new SearchRequest().indices(new String[]{indexName}).source(this.createSearchSourceBuilder(objectMapper.writeValueAsString((Object)finalQuery)));
        SearchResponse searchResponse = esClient.search(searchRequest, RequestOptions.DEFAULT);
        return searchResponse;
    }

    private Map applyVariables(Map<String, Object> sourceMap, Map variables) {
        for (Map.Entry<String, Object> entry : sourceMap.entrySet()) {
            Object o = entry.getValue();
            if (o instanceof HashMap) {
                HashMap map = (HashMap)o;
                this.applyVariables(map, variables);
                continue;
            }
            if (o instanceof List) {
                ArrayList items = (ArrayList)o;
                for (Object item : items) {
                    if (item instanceof String) {
                        this.setVariables(items, variables, entry, (String)item);
                        continue;
                    }
                    if (!(item instanceof Map)) continue;
                    this.applyVariables((Map)item, variables);
                }
                continue;
            }
            if (!(entry.getValue() instanceof String)) continue;
            this.setVariables(sourceMap, variables, entry, (String)o);
        }
        return sourceMap;
    }

    private void setVariables(Object sourceObj, Map variables, Map.Entry<String, Object> entry, String queryValue) {
        String value;
        Pattern pattern = Pattern.compile("\\{([^}]*?)\\}");
        Matcher matcher = pattern.matcher(value = queryValue);
        if (matcher.find()) {
            String varName = matcher.group(1);
            List varValues = variables.getOrDefault(varName, null);
            if (varValues != null) {
                String varValue = (String)varValues.get(0);
                String valueAfterApplyingVar = value.replace("{" + varName + "}", varValue);
                this.replaceVariablePlaceholder(sourceObj, entry, valueAfterApplyingVar);
            } else {
                this.replaceVariablePlaceholder(sourceObj, entry, null);
            }
        }
    }

    private void replaceVariablePlaceholder(Object sourceObj, Map.Entry<String, Object> entry, String valueAfterApplyingVar) {
        if (sourceObj instanceof Map) {
            ((Map)sourceObj).put(entry.getKey(), valueAfterApplyingVar);
        } else if (sourceObj instanceof List) {
            int index = ((List)sourceObj).indexOf("{TEST1}");
            ((List)sourceObj).set(index, valueAfterApplyingVar);
        }
    }

    private SearchSourceBuilder createSearchSourceBuilder(String query) throws IOException {
        SearchModule searchModule = new SearchModule(Settings.EMPTY, false, Collections.emptyList());
        NamedXContentRegistry contentRegistry = new NamedXContentRegistry(searchModule.getNamedXContents());
        XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(contentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, query);
        return SearchSourceBuilder.fromXContent((XContentParser)parser);
    }
}

