/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.elasticsearch.plugin.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;

public class JsonUtil {
    private static final Logger LOG = Loggers.getLogger(JsonUtil.class, (String[])new String[]{"es-bpc-plugin"});

    public static Map<String, Object> asMap(String jsonString) throws IOException {
        LOG.debug("asMap jsonString=...");
        if (jsonString != null) {
            try (XContentParser parser = null;){
                parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, jsonString);
                Map map = parser.map();
                return map;
            }
        }
        return null;
    }

    public static Map<String, Object> asMap(BytesReference bytesReference) throws IOException {
        LOG.debug("asMap bytesReference=...");
        if (bytesReference != null) {
            try (XContentParser parser = null;){
                Map map;
                block11: {
                    StreamInput bytesReferenceInputStream = bytesReference.streamInput();
                    try {
                        parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (InputStream)bytesReferenceInputStream);
                        map = parser.map();
                        if (bytesReferenceInputStream == null) break block11;
                    }
                    catch (Throwable throwable) {
                        if (bytesReferenceInputStream != null) {
                            try {
                                bytesReferenceInputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    bytesReferenceInputStream.close();
                }
                return map;
            }
        }
        return null;
    }
}

