/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.elasticsearch.plugin;

import de.virtimo.bpc.elasticsearch.plugin.utils.TimestampUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDateTime;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;

public class ClusterMessage {
    private static final Logger LOG = Loggers.getLogger(ClusterMessage.class, (String[])new String[]{"es-bpc-plugin"});
    public static final String WEBSOCKET_MSG_PREFIX = "ClusterMessage:::";
    private String action;
    private String serverUUID;
    private long sendedAtUtcMilli;

    private ClusterMessage() {
    }

    public ClusterMessage(String action, String serverUUID) {
        this.action = action;
        this.serverUUID = serverUUID;
        this.sendedAtUtcMilli = TimestampUtil.getNowInUtcEpochMilli();
    }

    public String getAction() {
        return this.action;
    }

    public String getServerUUID() {
        return this.serverUUID;
    }

    public long getSendedAtUtcMilli() {
        return this.sendedAtUtcMilli;
    }

    public LocalDateTime getSendetAt() {
        return TimestampUtil.asLocalDateTime(this.sendedAtUtcMilli);
    }

    public String asJsonString() {
        try {
            XContentBuilder builder = new XContentBuilder((XContent)JsonXContent.jsonXContent, (OutputStream)new BytesStreamOutput());
            builder.startObject().field("action", this.action).field("serverUUID", this.serverUUID).field("sendedAtUtcMilli", this.sendedAtUtcMilli);
            builder.endObject();
            return Strings.toString((XContentBuilder)builder);
        }
        catch (IOException ex) {
            LOG.error("Failed to create the cluster message JSON.", (Throwable)ex);
            return null;
        }
    }

    public String toString() {
        return "ClusterMessage{action='" + this.action + "', serverUUID='" + this.serverUUID + "', sendedAtUtcMilli=" + this.sendedAtUtcMilli + ", sendedAt=" + this.getSendetAt() + "}";
    }
}

