/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.elasticsearch.plugin;

import de.virtimo.bpc.elasticsearch.plugin.utils.TimestampUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;

public class IndexOperation {
    private static final Logger LOG = Loggers.getLogger(IndexOperation.class, (String[])new String[]{"es-bpc-plugin"});
    private final String index;
    private final Set<String> aliasesOfIndex;
    private final String id;
    private final Operation operation;
    private final long version;
    private final long timestampInUtcMillis;
    private final BytesReference source;

    public IndexOperation(String index, Set<String> aliasesOfIndex, String id, Operation operation, long version, BytesReference source) {
        this.index = index;
        this.aliasesOfIndex = aliasesOfIndex;
        this.id = id;
        this.operation = operation;
        this.version = version;
        this.timestampInUtcMillis = TimestampUtil.getNowInUtcEpochMilli();
        this.source = source;
    }

    public String getIndex() {
        return this.index;
    }

    public Set<String> getAliasesOfIndex() {
        return this.aliasesOfIndex;
    }

    public String getId() {
        return this.id;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public long getTimestampInUtcMillis() {
        return this.timestampInUtcMillis;
    }

    public long getVersion() {
        return this.version;
    }

    public BytesReference getSource() {
        return this.source;
    }

    public String asJsonString() {
        try {
            XContentBuilder builder = new XContentBuilder((XContent)JsonXContent.jsonXContent, (OutputStream)new BytesStreamOutput());
            builder.startObject().field("index", this.index).field("aliasesOfIndex", this.aliasesOfIndex).field("id", this.id).field("timestampInUtcMillis", this.timestampInUtcMillis).field("version", this.version).field("operation", this.operation.toString());
            if (this.source != null) {
                try (StreamInput sourceStreamInput = this.source.streamInput();){
                    builder.rawField("source", (InputStream)sourceStreamInput, XContentType.JSON);
                }
            }
            builder.endObject();
            return Strings.toString((XContentBuilder)builder);
        }
        catch (IOException e) {
            LOG.error("Failed to create JSON", (Throwable)e);
            return null;
        }
    }

    public static enum Operation {
        INDEX,
        CREATE,
        DELETE;

    }
}

