/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.elasticsearch.plugin;

import de.virtimo.bpc.elasticsearch.plugin.BpcConnection;
import de.virtimo.bpc.elasticsearch.plugin.ClusterSettings;
import de.virtimo.bpc.elasticsearch.plugin.ServerStateInfo;
import de.virtimo.bpc.elasticsearch.plugin.WebSocket;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;

public class BpcConnections {
    private static final Logger LOG = Loggers.getLogger(BpcConnections.class, (String[])new String[]{"es-bpc-plugin"});
    private ClusterSettings clusterSettings;
    private Set<BpcConnection> connections;

    public BpcConnections(ClusterSettings clusterSettings) {
        this.clusterSettings = clusterSettings;
        this.connections = new HashSet<BpcConnection>();
    }

    public Set<BpcConnection> createBpcConnections(Map<String, Object> connectionsMap) {
        Object entries;
        LOG.debug("createBpcConnections connectionsMap=" + connectionsMap);
        HashSet<BpcConnection> result = null;
        if (connectionsMap != null && (entries = connectionsMap.get("entries")) instanceof List) {
            result = new HashSet<BpcConnection>();
            for (Object listEntry : (List)entries) {
                if (!(listEntry instanceof Map)) continue;
                BpcConnection connection = new BpcConnection((Map)listEntry);
                result.add(connection);
            }
        }
        return result;
    }

    public void writeConnectionsSetting() {
        LOG.debug("writeConnectionsSetting");
        try {
            XContentBuilder builder = new XContentBuilder((XContent)JsonXContent.jsonXContent, (OutputStream)new BytesStreamOutput());
            builder.startObject();
            builder.startArray("entries");
            for (BpcConnection connection : this.connections) {
                connection.addToBuilder(builder);
            }
            builder.endArray();
            builder.endObject();
            this.clusterSettings.setTransientSetting("connections", Strings.toString((XContentBuilder)builder));
        }
        catch (Exception ex) {
            LOG.error("Failed to write the transient cluster setting 'connections'.", (Throwable)ex);
        }
    }

    public boolean hasEntries() {
        return !this.connections.isEmpty();
    }

    public Set<BpcConnection> getAll() {
        return new HashSet<BpcConnection>(this.connections);
    }

    public BpcConnection addConnection(String nodeName, WebSocket webSocket) {
        LOG.debug("addConnection nodeName=" + nodeName + ", webSocket=" + webSocket);
        BpcConnection connection = new BpcConnection(nodeName, webSocket);
        this.connections.add(connection);
        return connection;
    }

    public void addOrUpdateConnection(BpcConnection connection) {
        LOG.debug("addOrUpdateConnection connection=" + connection);
        if (connection != null) {
            WebSocket existingWebSocket;
            BpcConnection existingConnection = this.getConnectionByWebsocketId(connection.getWebsocketId());
            if (existingConnection != null && connection.getWebSocket() == null && (existingWebSocket = existingConnection.getWebSocket()) != null) {
                connection.setWebSocket(existingWebSocket);
            }
            if (existingConnection != null) {
                this.connections.remove(existingConnection);
            }
            this.connections.add(connection);
        }
    }

    public boolean removeConnection(BpcConnection connection) {
        LOG.debug("removeConnection connection=" + connection);
        if (connection != null) {
            BpcConnection existingConnection = this.getConnectionByWebsocketId(connection.getWebsocketId());
            return existingConnection != null && this.connections.remove(existingConnection);
        }
        return false;
    }

    public void processBpcConnectionsSetting(Set<BpcConnection> bpcConnections) {
        LOG.debug("processBpcConnectionsSetting bpcConnections=...");
        if (bpcConnections != null) {
            HashMap<String, WebSocket> currentWebsocketConnections = new HashMap<String, WebSocket>();
            for (BpcConnection connection : this.connections) {
                WebSocket webSocket = connection.getWebSocket();
                if (webSocket == null) continue;
                currentWebsocketConnections.put(webSocket.getId(), webSocket);
            }
            for (BpcConnection connection : bpcConnections) {
                if (!currentWebsocketConnections.containsKey(connection.getWebsocketId())) continue;
                connection.setWebSocket((WebSocket)currentWebsocketConnections.get(connection.getWebsocketId()));
            }
            this.connections.clear();
            this.connections.addAll(bpcConnections);
        }
    }

    public List<BpcConnection> getConnectionsByElasticsearchNodeNames(Set<String> nodeNames) {
        LOG.debug("getConnectionsByElasticsearchNodeNames nodeNames=" + nodeNames);
        ArrayList<BpcConnection> result = new ArrayList<BpcConnection>();
        if (nodeNames != null && !nodeNames.isEmpty()) {
            for (BpcConnection connection : this.connections) {
                if (!nodeNames.contains(connection.getConnectedtNode())) continue;
                result.add(connection);
            }
        }
        return result;
    }

    public BpcConnection getConnectionByWebsocketId(String websocketId) {
        LOG.debug("getConnectionByWebsocketId websocketId=" + websocketId);
        if (websocketId != null && websocketId.length() > 0) {
            for (BpcConnection connection : this.connections) {
                if (!connection.getWebsocketId().equals(websocketId)) continue;
                return connection;
            }
        }
        return null;
    }

    public BpcConnection getConnectionByServerUUID(String serverUUID) {
        LOG.debug("getConnectionByServerUUID serverUUID=" + serverUUID);
        if (serverUUID != null && serverUUID.length() > 0) {
            for (BpcConnection connection : this.connections) {
                ServerStateInfo serverStateInfo = connection.getServerStateInfo();
                if (serverStateInfo == null || !serverStateInfo.getServerUUID().equals(serverUUID)) continue;
                return connection;
            }
        }
        return null;
    }

    public String getServerUUIDForWebsocketId(String websocketId) {
        ServerStateInfo serverStateInfo;
        LOG.debug("getServerUUIDForWebsocketId websocketId=" + websocketId);
        BpcConnection connection = this.getConnectionByWebsocketId(websocketId);
        if (connection != null && (serverStateInfo = connection.getServerStateInfo()) != null) {
            return serverStateInfo.getServerUUID();
        }
        return null;
    }

    public ServerStateInfo getServerStateInfoByServerUUID(String serverUUID) {
        LOG.debug("getServerStateInfoByServerUUID serverUUID=" + serverUUID);
        BpcConnection connection = this.getConnectionByServerUUID(serverUUID);
        if (connection != null) {
            return connection.getServerStateInfo();
        }
        return null;
    }

    public void sendWebsocketMessage(String message, List<String> serverUUIDsToIgnore) {
        LOG.debug("sendWebsocketMessage message=" + message + ", serverUUIDsToIgnore=" + serverUUIDsToIgnore);
        if (message != null) {
            for (BpcConnection connection : this.connections) {
                WebSocket webSocket;
                ServerStateInfo serverStateInfo = connection.getServerStateInfo();
                if (serverUUIDsToIgnore != null && serverStateInfo != null && serverUUIDsToIgnore.contains(serverStateInfo.getServerUUID()) || (webSocket = connection.getWebSocket()) == null) continue;
                try {
                    webSocket.sendMessageAsync(message);
                }
                catch (Exception e) {
                    LOG.error("Failed to send websocket message", (Throwable)e);
                }
            }
        }
    }

    public void sendWebsocketMessageToServerUUIDs(String message, List<String> serverUUIDs) {
        LOG.debug("sendWebsocketMessageToServerUUIDs message=" + message + ", serverUUIDs=" + serverUUIDs);
        if (message != null && serverUUIDs != null) {
            for (BpcConnection connection : this.connections) {
                WebSocket webSocket;
                ServerStateInfo serverStateInfo = connection.getServerStateInfo();
                if (serverStateInfo == null || !serverUUIDs.contains(serverStateInfo.getServerUUID()) || (webSocket = connection.getWebSocket()) == null) continue;
                try {
                    webSocket.sendMessageAsync(message);
                }
                catch (Exception e) {
                    LOG.error("Failed to send websocket message", (Throwable)e);
                }
            }
        }
    }
}

