/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin;

import de.virtimo.bpc.opensearch.plugin.BpcConnection;
import de.virtimo.bpc.opensearch.plugin.WebSocket;
import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ServerStateInfoDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.logging.Loggers;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class BpcConnections
implements OpenSearchPluginDTO {
    private static final Logger LOG = Loggers.getLogger(BpcConnections.class, (String[])new String[]{"os-bpc-plugin"});
    public static final long LAST_UPDATED_NOT_INITIALIZED = -1L;
    private final Set<BpcConnection> connections = new HashSet<BpcConnection>();
    private long lastUpdated = -1L;
    private static final Object CONNECTIONS_LOCK = new Object();

    public BpcConnections() {
    }

    public BpcConnections(Map<String, Object> connectionsMap) {
        this();
        this.connections.addAll(MapUtil.getArrayValueAsListOfObjects(connectionsMap, (String)"entries", BpcConnection.class));
        this.lastUpdated = MapUtil.getValueAsLong(connectionsMap, (String)"lastUpdated", (long)-1L);
    }

    public BpcConnections(StreamInput in) throws IOException {
        this();
        this.connections.addAll(in.readSet(BpcConnection::new));
        this.lastUpdated = in.readLong();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.connections);
        out.writeLong(this.lastUpdated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            builder.startObject();
            builder.field("lastUpdated", this.lastUpdated);
            builder.startArray("entries");
            for (BpcConnection connection : this.connections) {
                connection.toXContent(builder, params);
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }
    }

    public static BpcConnections fromXContent(XContentParser parser) throws IOException {
        return new BpcConnections(parser.map());
    }

    private void _keepNowAsLastUpdated() {
        this.lastUpdated = System.currentTimeMillis();
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasEntries() {
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            return !this.connections.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<BpcConnection> getAll() {
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            return new HashSet<BpcConnection>(this.connections);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BpcConnection addConnection(String nodeName, WebSocket webSocket) {
        LOG.debug("addConnection nodeName=" + nodeName + ", webSocket=" + webSocket);
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            BpcConnection connection = new BpcConnection(nodeName, webSocket);
            this.connections.add(connection);
            this._keepNowAsLastUpdated();
            return connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrUpdateConnection(BpcConnection connection) {
        LOG.debug("addOrUpdateConnection connection=" + connection);
        if (connection == null) {
            return;
        }
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            WebSocket existingWebSocket;
            BpcConnection existingConnection = this._getConnectionByWebsocketId(connection.getWebsocketId());
            if (existingConnection != null && connection.getWebSocket() == null && (existingWebSocket = existingConnection.getWebSocket()) != null) {
                connection.setWebSocket(existingWebSocket);
            }
            if (existingConnection != null) {
                this.connections.remove(existingConnection);
            }
            this.connections.add(connection);
            this._keepNowAsLastUpdated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeConnection(BpcConnection connection) {
        LOG.debug("removeConnection connection=" + connection);
        if (connection == null) {
            return false;
        }
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            BpcConnection existingConnection = this._getConnectionByWebsocketId(connection.getWebsocketId());
            if (existingConnection != null) {
                boolean removed = this.connections.remove(existingConnection);
                if (removed) {
                    this._keepNowAsLastUpdated();
                }
                return removed;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processBpcConnectionsSetting(Set<BpcConnection> bpcConnections) {
        LOG.debug("processBpcConnectionsSetting bpcConnections=...");
        if (bpcConnections == null) {
            return;
        }
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            HashMap<String, WebSocket> currentWebsocketConnections = new HashMap<String, WebSocket>();
            for (BpcConnection connection : this.connections) {
                WebSocket webSocket = connection.getWebSocket();
                if (webSocket == null) continue;
                currentWebsocketConnections.put(webSocket.getId(), webSocket);
            }
            for (BpcConnection connection : bpcConnections) {
                if (!currentWebsocketConnections.containsKey(connection.getWebsocketId())) continue;
                connection.setWebSocket((WebSocket)currentWebsocketConnections.get(connection.getWebsocketId()));
            }
            this.connections.clear();
            this.connections.addAll(bpcConnections);
            this._keepNowAsLastUpdated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BpcConnection> getConnectionsByOpenSearchNodeNames(Set<String> nodeNames) {
        LOG.debug("getConnectionsByOpenSearchNodeNames nodeNames=" + nodeNames);
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            ArrayList<BpcConnection> result = new ArrayList<BpcConnection>();
            if (nodeNames != null && !nodeNames.isEmpty()) {
                for (BpcConnection connection : this.connections) {
                    if (!nodeNames.contains(connection.getConnectedNode())) continue;
                    result.add(connection);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BpcConnection getConnectionByWebsocketId(String websocketId) {
        LOG.debug("getConnectionByWebsocketId websocketId=" + websocketId);
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            return this._getConnectionByWebsocketId(websocketId);
        }
    }

    private BpcConnection _getConnectionByWebsocketId(String websocketId) {
        LOG.debug("_getConnectionByWebsocketId websocketId=" + websocketId);
        if (!StringUtil.isNullOrEmpty((String)websocketId)) {
            for (BpcConnection connection : this.connections) {
                if (!connection.getWebsocketId().equals(websocketId)) continue;
                return connection;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BpcConnection getConnectionByServerUUID(String serverUUID) {
        LOG.debug("getConnectionByServerUUID serverUUID=" + serverUUID);
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            return this._getConnectionByServerUUID(serverUUID);
        }
    }

    private BpcConnection _getConnectionByServerUUID(String serverUUID) {
        LOG.debug("_getConnectionByServerUUID serverUUID=" + serverUUID);
        if (!StringUtil.isNullOrEmpty((String)serverUUID)) {
            for (BpcConnection connection : this.connections) {
                ServerStateInfoDTO serverStateInfo = connection.getServerStateInfo();
                if (serverStateInfo == null || !serverStateInfo.getServerUUID().equals(serverUUID)) continue;
                return connection;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getServerUUIDForWebsocketId(String websocketId) {
        LOG.debug("getServerUUIDForWebsocketId websocketId=" + websocketId);
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            ServerStateInfoDTO serverStateInfo;
            BpcConnection connection = this._getConnectionByWebsocketId(websocketId);
            if (connection != null && (serverStateInfo = connection.getServerStateInfo()) != null) {
                return serverStateInfo.getServerUUID();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerStateInfoDTO getServerStateInfoByServerUUID(String serverUUID) {
        LOG.debug("getServerStateInfoByServerUUID serverUUID=" + serverUUID);
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            BpcConnection connection = this._getConnectionByServerUUID(serverUUID);
            if (connection != null) {
                return connection.getServerStateInfo();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getServerUUIDsOfServersAvailableForReplication() {
        LOG.debug("getServerUUIDsOfServersAvailableForReplication");
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            HashSet<String> serverUUIDs = new HashSet<String>();
            for (BpcConnection connection : this.connections) {
                ServerStateInfoDTO serverStateInfo = connection.getServerStateInfo();
                if (serverStateInfo == null || !serverStateInfo.isAvailableForReplication()) continue;
                serverUUIDs.add(serverStateInfo.getServerUUID());
            }
            return serverUUIDs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerStateInfoDTO evaluateNextAvailableMasterServer() {
        LOG.debug("evaluateNextAvailableMasterServer");
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            for (BpcConnection connection : this.connections) {
                ServerStateInfoDTO serverStateInfo = connection.getServerStateInfo();
                if (serverStateInfo == null || serverStateInfo.isMaintenanceModeEnabled() || serverStateInfo.isMasterServer()) continue;
                return serverStateInfo;
            }
            return null;
        }
    }

    public void sendWebsocketMessage(WebsocketMessage websocketMessage, List<String> serverUUIDsToIgnore) {
        LOG.debug("sendWebsocketMessage websocketMessage=" + websocketMessage + ", serverUUIDsToIgnore=" + serverUUIDsToIgnore);
        this.sendWebsocketMessage(websocketMessage, serverUUIDsToIgnore, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendWebsocketMessage(WebsocketMessage websocketMessage, List<String> serverUUIDsToIgnore, PreSendWebsocketMessagesCallback preSendWebsocketMessagesCallback, PostSendWebsocketMessagesCallback postSendWebsocketMessagesCallback) {
        LOG.debug("sendWebsocketMessage websocketMessage=" + websocketMessage + ", serverUUIDsToIgnore=" + serverUUIDsToIgnore + ", preSendWebsocketMessagesCallback=" + preSendWebsocketMessagesCallback + ", postSendWebsocketMessagesCallback=" + postSendWebsocketMessagesCallback);
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            ArrayList<WebSocket> relatedWebSockets = new ArrayList<WebSocket>();
            for (BpcConnection connection : this.connections) {
                WebSocket webSocket;
                ServerStateInfoDTO serverStateInfo = connection.getServerStateInfo();
                if (serverUUIDsToIgnore != null && serverStateInfo != null && serverUUIDsToIgnore.contains(serverStateInfo.getServerUUID()) || (webSocket = connection.getWebSocket()) == null) continue;
                relatedWebSockets.add(webSocket);
            }
            this.sendWebsocketMessage(relatedWebSockets, websocketMessage, preSendWebsocketMessagesCallback, postSendWebsocketMessagesCallback);
        }
    }

    public void sendWebsocketMessageToServerUUIDs(WebsocketMessage websocketMessage, List<String> serverUUIDs) {
        LOG.debug("sendWebsocketMessageToServerUUIDs websocketMessage=" + websocketMessage + ", serverUUIDs=" + serverUUIDs);
        this.sendWebsocketMessageToServerUUIDs(websocketMessage, serverUUIDs, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendWebsocketMessageToServerUUIDs(WebsocketMessage websocketMessage, List<String> serverUUIDs, PreSendWebsocketMessagesCallback preSendWebsocketMessagesCallback, PostSendWebsocketMessagesCallback postSendWebsocketMessagesCallback) {
        LOG.debug("sendWebsocketMessageToServerUUIDs websocketMessage=" + websocketMessage + ", serverUUIDs=" + serverUUIDs + ", preSendWebsocketMessagesCallback=" + preSendWebsocketMessagesCallback + ", postSendWebsocketMessagesCallback=" + postSendWebsocketMessagesCallback);
        Object object = CONNECTIONS_LOCK;
        synchronized (object) {
            ArrayList<WebSocket> relatedWebSockets = new ArrayList<WebSocket>();
            for (BpcConnection connection : this.connections) {
                WebSocket webSocket;
                ServerStateInfoDTO serverStateInfo = connection.getServerStateInfo();
                if (serverStateInfo == null || serverUUIDs == null || !serverUUIDs.contains(serverStateInfo.getServerUUID()) || (webSocket = connection.getWebSocket()) == null) continue;
                relatedWebSockets.add(webSocket);
            }
            this.sendWebsocketMessage(relatedWebSockets, websocketMessage, preSendWebsocketMessagesCallback, postSendWebsocketMessagesCallback);
        }
    }

    public void sendWebsocketMessageToServerUUID(WebsocketMessage websocketMessage, String serverUUID) {
        LOG.debug("sendWebsocketMessageToServerUUID websocketMessage=" + websocketMessage + ", serverUUID=" + serverUUID);
        if (websocketMessage == null || StringUtil.isNullOrEmpty((String)serverUUID)) {
            return;
        }
        this.sendWebsocketMessageToServerUUIDs(websocketMessage, Collections.singletonList(serverUUID));
    }

    private void sendWebsocketMessage(List<WebSocket> relatedWebSockets, final WebsocketMessage websocketMessage, PreSendWebsocketMessagesCallback preSendWebsocketMessagesCallback, PostSendWebsocketMessagesCallback postSendWebsocketMessagesCallback) {
        LOG.debug("sendWebsocketMessage relatedWebSockets=..., websocketMessage=" + websocketMessage + ", preSendWebsocketMessagesCallback=" + preSendWebsocketMessagesCallback + ", postSendWebsocketMessagesCallback=" + postSendWebsocketMessagesCallback);
        if (preSendWebsocketMessagesCallback != null) {
            preSendWebsocketMessagesCallback.goingToSendNumberOfWebsocketMessages(relatedWebSockets.size());
        }
        final WebsocketMessagesSentStatus status = new WebsocketMessagesSentStatus();
        for (WebSocket relatedWebSocket : relatedWebSockets) {
            relatedWebSocket.sendMessageAsync(websocketMessage, new ActionListener<Boolean>(){

                public void onResponse(Boolean aBoolean) {
                    status.increaseSuccessfullySent();
                }

                public void onFailure(Exception ex) {
                    LOG.error("Failed to send websocket message: " + websocketMessage, (Throwable)ex);
                    status.increaseFailedToSent();
                }
            });
        }
        if (postSendWebsocketMessagesCallback != null) {
            postSendWebsocketMessagesCallback.websocketMessagesSent(status.getSuccessfullySent(), status.getFailedToSent());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BpcConnections that = (BpcConnections)o;
        return this.lastUpdated == that.lastUpdated && Objects.equals(this.connections, that.connections);
    }

    public int hashCode() {
        return Objects.hash(this.connections, this.lastUpdated);
    }

    public String toString() {
        return "BpcConnections{connections=" + this.connections + ", lastUpdated=" + this.lastUpdated + "}";
    }

    @FunctionalInterface
    public static interface PreSendWebsocketMessagesCallback {
        public void goingToSendNumberOfWebsocketMessages(int var1);
    }

    @FunctionalInterface
    public static interface PostSendWebsocketMessagesCallback {
        public void websocketMessagesSent(int var1, int var2);
    }

    private static class WebsocketMessagesSentStatus {
        private int successfullySent = 0;
        private int failedToSent = 0;

        private WebsocketMessagesSentStatus() {
        }

        public void increaseSuccessfullySent() {
            ++this.successfullySent;
        }

        public int getSuccessfullySent() {
            return this.successfullySent;
        }

        public void increaseFailedToSent() {
            ++this.failedToSent;
        }

        public int getFailedToSent() {
            return this.failedToSent;
        }
    }
}

