/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.dto;

import de.virtimo.bpc.opensearch.plugin.dto.LoadedModulesDTO;
import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ServerStateInfoDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class ConnectedServerDTO
implements OpenSearchPluginDTO {
    private final String nodeName;
    private final String websocketId;
    private final ServerStateInfoDTO serverStateInfo;
    private final LoadedModulesDTO loadedModules;

    public ConnectedServerDTO(String nodeName, String websocketId, ServerStateInfoDTO serverStateInfo, LoadedModulesDTO serverLoadedModules) {
        this.nodeName = nodeName;
        this.websocketId = websocketId;
        this.serverStateInfo = serverStateInfo;
        this.loadedModules = serverLoadedModules != null ? serverLoadedModules : new LoadedModulesDTO();
    }

    public ConnectedServerDTO(Map<String, Object> serverData) {
        this.nodeName = MapUtil.getValueAsString(serverData, (String)"nodeName", null);
        this.websocketId = MapUtil.getValueAsString(serverData, (String)"websocketId", null);
        Map serverStateInfoMap = MapUtil.getValueAsMap(serverData, (String)"serverStateInfo", null);
        this.serverStateInfo = serverStateInfoMap != null ? new ServerStateInfoDTO(serverStateInfoMap) : null;
        List loadedModulesList = MapUtil.getValueAsList(serverData, (String)"loadedModules", null);
        this.loadedModules = loadedModulesList != null ? new LoadedModulesDTO(loadedModulesList) : new LoadedModulesDTO();
    }

    public ConnectedServerDTO(StreamInput in) throws IOException {
        this.nodeName = in.readString();
        this.websocketId = in.readString();
        ServerStateInfoDTO serverStateInfo = (ServerStateInfoDTO)in.readOptionalWriteable(ServerStateInfoDTO::new);
        this.serverStateInfo = serverStateInfo != null ? serverStateInfo : null;
        LoadedModulesDTO readLoadedModulesDTO = (LoadedModulesDTO)in.readOptionalWriteable(LoadedModulesDTO::new);
        this.loadedModules = readLoadedModulesDTO != null ? readLoadedModulesDTO : new LoadedModulesDTO();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.nodeName);
        out.writeString(this.websocketId);
        out.writeOptionalWriteable((Writeable)this.serverStateInfo);
        out.writeOptionalWriteable((Writeable)this.loadedModules);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("nodeName", this.getNodeName());
        builder.field("websocketId", this.getWebsocketId());
        if (this.serverStateInfo != null) {
            builder.field("serverStateInfo", (ToXContent)this.serverStateInfo, params);
        }
        if (this.loadedModules != null) {
            builder.field("loadedModules", (ToXContent)this.loadedModules, params);
        }
        builder.endObject();
        return builder;
    }

    public ConnectedServerDTO fromXContent(XContentParser parser) throws IOException {
        return new ConnectedServerDTO(parser.map());
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getWebsocketId() {
        return this.websocketId;
    }

    public ServerStateInfoDTO getServerStateInfo() {
        return this.serverStateInfo;
    }

    public LoadedModulesDTO getLoadedModules() {
        return this.loadedModules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectedServerDTO that = (ConnectedServerDTO)o;
        return Objects.equals(this.nodeName, that.nodeName) && Objects.equals(this.websocketId, that.websocketId) && Objects.equals(this.serverStateInfo, that.serverStateInfo) && Objects.equals(this.loadedModules, that.loadedModules);
    }

    public int hashCode() {
        return Objects.hash(this.nodeName, this.websocketId, this.serverStateInfo);
    }

    public String toString() {
        return "ConnectedServerDTO{nodeName='" + this.nodeName + "', websocketId='" + this.websocketId + "', serverStateInfo=" + this.serverStateInfo + ", loadedModules=" + this.loadedModules + "}";
    }
}

