/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.decanter.parser.regex;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.karaf.decanter.api.parser.Parser;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="org.apache.karaf.decanter.parser.regex", immediate=true, property={"parserId=regex"})
public class RegexParser
implements Parser {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegexParser.class);
    private Pattern pattern;
    private String keys = null;

    @Activate
    public void activate(ComponentContext componentContext) {
        this.activate(componentContext.getProperties());
    }

    public void activate(Dictionary<String, Object> config) {
        String regex = config.get("regex") != null ? (String)config.get("regex") : "(.*)";
        this.pattern = Pattern.compile(regex);
        this.keys = config.get("keys") != null ? (String)config.get("keys") : null;
    }

    public Map<String, Object> parse(String key, String line) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (line != null) {
            int i;
            String[] keysArray;
            Matcher matcher = this.pattern.matcher(line);
            if (this.keys != null) {
                keysArray = this.keys.split(",");
                if (keysArray.length != matcher.groupCount()) {
                    LOGGER.warn("keys count and regex groups count don't match, using default keys ID");
                    keysArray = new String[matcher.groupCount()];
                    for (i = 0; i < keysArray.length; ++i) {
                        keysArray[i] = "key-" + i;
                    }
                }
            } else {
                keysArray = new String[matcher.groupCount()];
                for (i = 0; i < keysArray.length; ++i) {
                    keysArray[i] = "key-" + i;
                }
            }
            if (matcher.find()) {
                for (i = 0; i < matcher.groupCount(); ++i) {
                    try {
                        data.put(keysArray[i], Integer.parseInt(matcher.group(i + 1)));
                        continue;
                    }
                    catch (Exception exception) {
                        try {
                            data.put(keysArray[i], Long.parseLong(matcher.group(i + 1)));
                            continue;
                        }
                        catch (Exception exception2) {
                            data.put(keysArray[i], matcher.group(i + 1));
                        }
                    }
                }
            }
        }
        return data;
    }
}

