/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collection;
import javax.crypto.Cipher;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.BuildInfo;
import oracle.jdbc.driver.resource.InstalledProviders;
import oracle.jdbc.driver.resource.ResourceType;
import oracle.jdbc.pool.OracleDataSource;

public class OracleDriver
extends oracle.jdbc.driver.OracleDriver {
    public static boolean isDMS() {
        return BuildInfo.isDMS();
    }

    public static boolean isInServer() {
        return BuildInfo.isInServer();
    }

    public static boolean isJDK14() {
        return BuildInfo.isJDK14();
    }

    public static boolean isDebug() {
        return true;
    }

    public static boolean isPrivateDebug() {
        return false;
    }

    public static String getJDBCVersion() {
        return BuildInfo.getJDBCVersion();
    }

    public static String getDriverVersion() {
        return BuildInfo.getDriverVersion();
    }

    public static String getBuildDate() {
        return BuildInfo.getBuildDate();
    }

    public static void main(String[] args) throws Exception {
        System.out.println(OracleDriver.getBuildInformation());
        if (args != null && args.length > 0 && args[0].equals("getVersion")) {
            System.out.println("\n[Database and JDK Information]");
            System.out.println(OracleDriver.getVersionInformation(args));
        }
        System.out.println("\n[Default Properties Resource]");
        System.out.println(OracleDriver.getDefaultPropertiesInformation());
        System.out.println("\n[Java Cryptography Extensions Policy]");
        System.out.println(OracleDriver.getJceInformation());
        System.out.println("\n[OracleResourceProvider Names]");
        System.out.println(OracleDriver.getProviderInformation());
    }

    private static String getBuildInformation() {
        return "Oracle " + OracleDriver.getDriverVersion() + " " + OracleDriver.getJDBCVersion() + (OracleDriver.isDMS() ? " DMS" : "") + (OracleDriver.isPrivateDebug() ? " private" : "") + (OracleDriver.isDebug() ? " debug" : "") + (OracleDriver.isInServer() ? " for JAVAVM" : "") + " compiled with " + BuildInfo.getCompilerVersion() + " on " + OracleDriver.getBuildDate();
    }

    private static String getDefaultPropertiesInformation() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(128);
        DEFAULT_CONNECTION_PROPERTIES.store(os, "Default Connection Properties Resource");
        return os.toString("ISO-8859-1");
    }

    private static String getJceInformation() throws NoSuchAlgorithmException {
        int maxKeySize = Cipher.getMaxAllowedKeyLength("AES");
        if (maxKeySize < 256) {
            return "***** JCE UNLIMITED STRENGTH NOT INSTALLED ****";
        }
        return "***** JCE UNLIMITED STRENGTH IS INSTALLED ****";
    }

    private static String getVersionInformation(String[] args) throws SQLException {
        if (args.length < 2) {
            System.out.println("Please provide the connection URL.");
            return "";
        }
        String dbVersionInformation = "";
        String DB_URL = args[1];
        OracleDataSource ods = new OracleDataSource();
        ods.setURL(DB_URL);
        try (OracleConnection connection = (OracleConnection)ods.getConnection();){
            DatabaseMetaData dbmd = connection.getMetaData();
            dbVersionInformation = "Database Version: " + dbmd.getDatabaseProductVersion() + System.getProperty("line.separator") + "Installed JDK: " + System.getProperty("java.version");
        }
        return dbVersionInformation;
    }

    private static String getProviderInformation() {
        StringBuilder information = new StringBuilder();
        boolean isFirst = true;
        for (ResourceType<?, ?> resourceType : ResourceType.allTypes()) {
            String providerInformation;
            Collection<String> providerNames = InstalledProviders.load(resourceType).getNames();
            String string = providerInformation = providerNames.isEmpty() ? "NO PROVIDER INSTALLED" : "[" + String.join((CharSequence)", ", providerNames) + "]";
            if (!isFirst) {
                information.append("\n");
            } else {
                isFirst = false;
            }
            information.append(resourceType.getProviderClass().getName()).append(" : ").append(providerInformation);
        }
        return information.toString();
    }
}

