/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.securityconf;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opensearch.security.securityconf.ConfigModelV7;
import org.opensearch.security.securityconf.InMemorySecurityRoles;
import org.opensearch.security.support.WildcardMatcher;

public class InMemorySecurityRolesV7
extends ConfigModelV7.SecurityRoles
implements InMemorySecurityRoles {
    public InMemorySecurityRolesV7(int roleCount) {
        super(roleCount);
    }

    @Override
    public void addSecurityRole(String roleName, Set<String> clusterPerms, Map<String, Set<String>> indexPatternToAllowedActions) {
        HashSet<ConfigModelV7.IndexPattern> ipatterns = new HashSet<ConfigModelV7.IndexPattern>();
        for (Map.Entry<String, Set<String>> entry : indexPatternToAllowedActions.entrySet()) {
            ConfigModelV7.IndexPattern idxPattern = new ConfigModelV7.IndexPattern(entry.getKey());
            idxPattern.addPerm(entry.getValue());
            ipatterns.add(idxPattern);
        }
        ConfigModelV7.SecurityRole role = new ConfigModelV7.SecurityRole(roleName, ipatterns, WildcardMatcher.from(clusterPerms));
        this.roles.add(role);
    }
}

