/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.config.impl;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.ops4j.pax.jdbc.config.ConfigLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileConfigLoader
implements ConfigLoader {
    private static final Logger LOG = LoggerFactory.getLogger(FileConfigLoader.class);

    @Override
    public String getName() {
        return "FILE";
    }

    @Override
    public String resolve(String key) {
        return FileConfigLoader.readFile(key, Charset.defaultCharset());
    }

    private static String readFile(String path, Charset encoding) {
        try {
            byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
            return new String(encoded, encoding);
        }
        catch (IOException ex) {
            LOG.error("Unable to read external configuration from " + path, (Throwable)ex);
            return null;
        }
    }
}

