/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.region.hook;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.equinox.internal.region.hook.RegionBundleFindHook;
import org.eclipse.equinox.internal.region.hook.RegionServiceFindHook;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.service.EventHook;

public final class RegionServiceEventHook
implements EventHook {
    private final RegionDigraph regionDigraph;

    public RegionServiceEventHook(RegionDigraph regionDigraph) {
        this.regionDigraph = regionDigraph;
    }

    public void event(ServiceEvent event, Collection<BundleContext> contexts) {
        ServiceReference eventService = event.getServiceReference();
        HashMap<Region, Boolean> regionAccess = new HashMap<Region, Boolean>();
        Iterator<BundleContext> i = contexts.iterator();
        while (i.hasNext()) {
            Bundle bundle = RegionBundleFindHook.getBundle(i.next());
            if (bundle == null) {
                i.remove();
                continue;
            }
            if (bundle.getBundleId() == 0L) continue;
            Region region = this.regionDigraph.getRegion(bundle);
            if (region == null) {
                i.remove();
                continue;
            }
            Boolean accessible = (Boolean)regionAccess.get(region);
            if (accessible == null) {
                accessible = this.isAccessible(region, eventService);
                regionAccess.put(region, accessible);
            }
            if (accessible.booleanValue()) continue;
            i.remove();
        }
    }

    private Boolean isAccessible(Region region, ServiceReference<?> candidateServiceReference) {
        ArrayList candidates = new ArrayList(1);
        candidates.add(candidateServiceReference);
        RegionServiceFindHook.find(region, candidates);
        return !candidates.isEmpty();
    }
}

